/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import java.util.Iterator;
import java.util.Set;

public final class RequiredParameterMissingException
extends DispatchException {
    private Set<Parameter<?>> missingParameters;

    public RequiredParameterMissingException(Set<Parameter<?>> set) {
        super(RequiredParameterMissingException.createMessage(set));
        this.missingParameters = set;
    }

    private static String createMessage(Set<Parameter<?>> set) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Parameter<?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Parameter<?> parameter = iterator.next();
            stringBuilder.append(parameter.getPersistentKey().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (set.size() == 1) {
            stringBuilder.append(" is");
        } else {
            stringBuilder.append(" are");
        }
        stringBuilder.append(" required and missing.");
        return stringBuilder.toString();
    }

    public Set<Parameter<?>> getMissingParameters() {
        return this.missingParameters;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RequiredParameterMissingException requiredParameterMissingException = (RequiredParameterMissingException)object;
        return this.sameRequiredParameterMissingExceptionAs(requiredParameterMissingException);
    }

    private boolean sameRequiredParameterMissingExceptionAs(RequiredParameterMissingException requiredParameterMissingException) {
        if (!((Object)this.missingParameters).equals(requiredParameterMissingException.missingParameters)) {
            return false;
        }
        return this.sameRemoteExecutionExceptionAs(requiredParameterMissingException);
    }

    @Override
    public int hashCode() {
        return 31 * ((Object)this.missingParameters).hashCode() + super.hashCode();
    }
}

