/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;

public final class ServerSocketConnectInfo
implements ConnectInfo,
Serializable {
    private InetSocketAddress fSocketAddress;
    private final UUID fGroupUuid;
    private final ConnectorSecurityDescription fSecurityDescription;
    private final long fHandShakeTimeout;

    public ServerSocketConnectInfo(InetSocketAddress inetSocketAddress, UUID uUID, ConnectorSecurityDescription connectorSecurityDescription, long l) {
        this.fSocketAddress = inetSocketAddress;
        this.fGroupUuid = uUID;
        this.fSecurityDescription = connectorSecurityDescription;
        this.fHandShakeTimeout = l;
    }

    public ServerSocketConnectInfo(String string, int n, UUID uUID, ConnectorSecurityDescription connectorSecurityDescription, long l) {
        this(new InetSocketAddress(string, n), uUID, connectorSecurityDescription, l);
    }

    public ServerSocketConnectInfo(InetAddress inetAddress, int n, UUID uUID, ConnectorSecurityDescription connectorSecurityDescription, long l) {
        this(new InetSocketAddress(inetAddress, n), uUID, connectorSecurityDescription, l);
    }

    @Override
    public UUID getGroupUUID() {
        return this.fGroupUuid;
    }

    @Override
    public ConnectorSecurityDescription getConnectorSecurityDescription() {
        return this.fSecurityDescription;
    }

    public InetSocketAddress getSocketAddress() {
        return this.fSocketAddress;
    }

    public ServerSocketConnectInfo createMangledConnectionInfo(InetAddress inetAddress) {
        return new ServerSocketConnectInfo(inetAddress, this.fSocketAddress.getPort(), this.fGroupUuid, this.fSecurityDescription, this.fHandShakeTimeout);
    }

    public ServerSocketConnectInfo createCopyReplaceSecurityDescription(ConnectorSecurityDescription connectorSecurityDescription) {
        return new ServerSocketConnectInfo(this.fSocketAddress, this.fGroupUuid, connectorSecurityDescription, this.fHandShakeTimeout);
    }

    public String createErrorStringSegment() {
        return "that attempted to connect to a server socket on " + this.fSocketAddress.getHostName() + " port " + this.fSocketAddress.getPort();
    }

    @Override
    public String getConnectInfoDescription() {
        return "socket at " + this.fSocketAddress;
    }

    @Override
    public long getHandShakeTimeout() {
        return this.fHandShakeTimeout;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " at " + this.fSocketAddress + " for group " + this.fGroupUuid;
    }

    @Override
    public boolean peersConnectingAsGroupShareBarrier() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)object;
        if (this.fHandShakeTimeout != serverSocketConnectInfo.fHandShakeTimeout) {
            return false;
        }
        if (!this.fGroupUuid.equals(serverSocketConnectInfo.fGroupUuid)) {
            return false;
        }
        if (!this.fSecurityDescription.equals(serverSocketConnectInfo.fSecurityDescription)) {
            return false;
        }
        return this.fSocketAddress.equals(serverSocketConnectInfo.fSocketAddress);
    }

    public int hashCode() {
        int n = this.fSocketAddress.hashCode();
        n = 31 * n + this.fGroupUuid.hashCode();
        n = 31 * n + this.fSecurityDescription.hashCode();
        n = 31 * n + (int)(this.fHandShakeTimeout ^ this.fHandShakeTimeout >>> 32);
        return n;
    }

    public String toString() {
        return "ServerSocketConnectInfo{fSocketAddress=" + this.fSocketAddress + ", fGroupUuid=" + this.fGroupUuid + ", fSecurityDescription=" + this.fSecurityDescription + ", fHandShakeTimeout=" + this.fHandShakeTimeout + '}';
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fSocketAddress = new InetSocketAddress(this.fSocketAddress.getHostName(), this.fSocketAddress.getPort());
    }
}

