/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ObjectCountDownLatch;
import com.mathworks.toolbox.distcomp.util.RunCallableOnce;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class MultipleFinalReturnMessageObserver<T extends FinalReturnMessage>
implements MessageObserver {
    private final ObjectCountDownLatch<Instance> fLatch;
    private final Map<Instance, T> fMessageMap;
    private final Class<T> fExpectedMessageClass;
    private final RunCallableOnce fRunOnAllCompleteOnce;

    MultipleFinalReturnMessageObserver(Class<T> clazz, int n) {
        this(n, clazz);
    }

    protected MultipleFinalReturnMessageObserver(int n, Class<T> clazz) {
        this.fLatch = new ObjectCountDownLatch(n);
        this.fMessageMap = Collections.synchronizedMap(new HashMap());
        this.fExpectedMessageClass = clazz;
        this.fRunOnAllCompleteOnce = new RunCallableOnce(new Runnable(){

            @Override
            public void run() {
                MultipleFinalReturnMessageObserver.this.onAllComplete();
            }
        });
    }

    protected void onAllComplete() {
    }

    @Override
    public synchronized void completed(ReturnMessage returnMessage, Instance instance) {
        if (this.fExpectedMessageClass.isInstance(returnMessage)) {
            this.fLatch.countDown(instance);
            this.fMessageMap.put(instance, this.fExpectedMessageClass.cast(returnMessage));
            this.callOnAllCompletedIfAllReceived();
        }
    }

    private void callOnAllCompletedIfAllReceived() {
        if (this.fLatch.complete()) {
            this.fRunOnAllCompleteOnce.run();
        }
    }

    public boolean await(long l, TimeUnit timeUnit) {
        return this.fLatch.await(l, timeUnit);
    }

    public boolean allMessagesReceived() {
        return this.fLatch.complete();
    }

    public synchronized Collection<T> getReturnMessages() {
        return this.fMessageMap.values();
    }

    protected synchronized Collection<Map.Entry<Instance, T>> getSourcesAndReturnMessages() {
        return this.fMessageMap.entrySet();
    }
}

