/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;

class IntervalResultImpl
implements ParforController.IntervalResult {
    private int fTag;
    private Object fResult;
    private Object fError;

    IntervalResultImpl(int n, FevalResult fevalResult) {
        this.fTag = n;
        this.fResult = null;
        this.fError = null;
        this.initResultAndError(fevalResult);
    }

    private void initResultAndError(FevalResult fevalResult) {
        if (fevalResult.getExecutionStatus() != 0) {
            switch (fevalResult.getExecutionStatus()) {
                case 1: {
                    this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : COMPILE_ERROR";
                    break;
                }
                case 2: {
                    this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : RUNTIME_ERROR";
                    break;
                }
                case 3: {
                    this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : EXECUTION_DBQUIT";
                    break;
                }
                case 4: {
                    this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : EXECUTION_CTRLC";
                    break;
                }
                default: {
                    assert (false) : "Unknown Execution status encountered : getExecutionStatus = " + fevalResult.getExecutionStatus();
                    break;
                }
            }
            return;
        }
        this.fResult = fevalResult.getResult();
        int n = fevalResult.getNlhs();
        switch (n) {
            case 0: {
                if (this.fResult == null) break;
                this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : non-null output for NLHS 0";
                break;
            }
            case 1: {
                if (this.fResult == null) {
                    this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : null output for NLHS 1";
                    break;
                }
                if (!this.outputSuggestsError(this.fResult)) break;
                this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : a single boolean output indicates an error occurred";
                break;
            }
            default: {
                if (this.fResult instanceof Object[] && ((Object[])this.fResult).length == n) {
                    Object[] objectArray = (Object[])this.fResult;
                    if (!this.outputSuggestsError(objectArray[0])) break;
                    this.fError = objectArray[1];
                    break;
                }
                this.fError = "Error in remote execution of " + SessionConstants.sPARFOR_FUNCTION + " : Object[" + n + "] expected : " + this.fResult + "received";
            }
        }
    }

    private boolean outputSuggestsError(Object object) {
        if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            return blArray.length == 1 ? blArray[0] : false;
        }
        return false;
    }

    @Override
    public int getTag() {
        return this.fTag;
    }

    @Override
    public boolean hasError() {
        return this.fError != null;
    }

    @Override
    public Object getResult() {
        return this.fResult;
    }

    @Override
    public Object getError() {
        return this.fError;
    }
}

