/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.concurrent.DaemonThreadFactory;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabErrorId;
import com.mathworks.toolbox.distcomp.util.i18n.I18NMatlabMessage;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.EOFException;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class FatalErrorHandler
implements ErrorHandler {
    private ShutdownHandler fShutdownHandler = null;
    private final AtomicBoolean fIsShuttingDown;
    private boolean fHasError = false;
    private FatalError fError;
    private final boolean fIsClient;
    private boolean fHasBeenDeactivated = false;
    private final ExecutorService fShutdownExecutor = Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.getClass().getSimpleName() + " fShutdownExecutor", PackageInfo.LOGGER));

    public FatalErrorHandler(boolean bl) {
        this.fIsShuttingDown = new AtomicBoolean(false);
        this.fIsClient = bl;
    }

    @Override
    public synchronized void deactivate() {
        this.fShutdownHandler = null;
        this.fHasBeenDeactivated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(ShutdownHandler shutdownHandler) {
        FatalErrorHandler fatalErrorHandler = this;
        synchronized (fatalErrorHandler) {
            if (!this.fHasError) {
                assert (!this.fHasBeenDeactivated) : "Attempt to activate a handler after it has been deactivated";
                this.fShutdownHandler = shutdownHandler;
                return;
            }
        }
        if (shutdownHandler != null) {
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readError(Instance instance, Throwable throwable) {
        FatalError fatalError;
        ShutdownHandler shutdownHandler;
        ProcessInstance processInstance = instance instanceof ProcessInstance ? (ProcessInstance)instance : null;
        FatalErrorHandler fatalErrorHandler = this;
        synchronized (fatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            this.fError = this.fIsClient ? (throwable instanceof EOFException ? FatalErrorHandler.msgLostConnectionToLab(processInstance, throwable) : FatalErrorHandler.msgReadErrorFromLab(processInstance, throwable)) : (throwable instanceof EOFException ? FatalErrorHandler.msgLostConnectionToClient(throwable) : FatalErrorHandler.msgReadErrorFromClient(throwable));
            shutdownHandler = this.fShutdownHandler;
            fatalError = this.fError;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, fatalError.getMessage());
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Read error, forcing a shutdown.", throwable);
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeError(Instance instance, Throwable throwable) {
        FatalError fatalError;
        ShutdownHandler shutdownHandler;
        ProcessInstance processInstance = instance instanceof ProcessInstance ? (ProcessInstance)instance : null;
        FatalErrorHandler fatalErrorHandler = this;
        synchronized (fatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            this.fError = this.fIsClient ? FatalErrorHandler.msgWriteErrorToLab(processInstance, throwable) : FatalErrorHandler.msgWriteErrorToClient(throwable);
            shutdownHandler = this.fShutdownHandler;
            fatalError = this.fError;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, fatalError.getMessage());
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Write error, forcing a shutdown.", throwable);
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lostCommunication(Instance instance, Throwable throwable) {
        FatalError fatalError;
        ShutdownHandler shutdownHandler;
        ProcessInstance processInstance = instance instanceof ProcessInstance ? (ProcessInstance)instance : null;
        FatalErrorHandler fatalErrorHandler = this;
        synchronized (fatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            this.fError = this.fIsClient ? FatalErrorHandler.msgLostConnectionToLab(processInstance, throwable) : FatalErrorHandler.msgLostConnectionToClient(throwable);
            shutdownHandler = this.fShutdownHandler;
            fatalError = this.fError;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, fatalError.getMessage());
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Write error, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executorError(Throwable throwable) {
        FatalError fatalError;
        ShutdownHandler shutdownHandler;
        FatalErrorHandler fatalErrorHandler = this;
        synchronized (fatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            this.fError = FatalErrorHandler.msgExecutorError(throwable);
            shutdownHandler = this.fShutdownHandler;
            fatalError = this.fError;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, fatalError.getMessage());
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Executor error, forcing a shutdown.", throwable);
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryShutdown(final ShutdownHandler shutdownHandler) {
        FatalError fatalError;
        assert (shutdownHandler != null) : "Shutdown handler was null during a call to tryShutdown";
        if (this.fIsShuttingDown.getAndSet(true)) {
            return;
        }
        FatalErrorHandler fatalErrorHandler = this;
        synchronized (fatalErrorHandler) {
            assert (this.fHasError) : "tryShutdown was called without an error";
            fatalError = this.fError;
        }
        this.fShutdownExecutor.execute(new Runnable(){

            @Override
            public void run() {
                shutdownHandler.forceShutdown(fatalError);
            }
        });
        this.fShutdownExecutor.shutdown();
    }

    private static FatalError msgLostConnectionToLab(ProcessInstance processInstance, Throwable throwable) {
        if (null == processInstance) {
            return new FatalError(FatalErrorHandlerI18NText.LostConnectionToAnUnknownLab, throwable, new Object[0]);
        }
        return new FatalError(FatalErrorHandlerI18NText.LostConnectionToLab, throwable, processInstance.getLabIndex());
    }

    private static FatalError msgReadErrorFromLab(ProcessInstance processInstance, Throwable throwable) {
        return new FatalError(FatalErrorHandlerI18NText.ReadErrorLostConnectionToLab, throwable, processInstance.getLabIndex());
    }

    private static FatalError msgLostConnectionToClient(Throwable throwable) {
        return new FatalError(FatalErrorHandlerI18NText.LostConnectionToClient, throwable, new Object[0]);
    }

    private static FatalError msgReadErrorFromClient(Throwable throwable) {
        return new FatalError(FatalErrorHandlerI18NText.ReadErrorLostConnectionToClient, throwable, new Object[0]);
    }

    private static FatalError msgWriteErrorToLab(ProcessInstance processInstance, Throwable throwable) {
        return new FatalError(FatalErrorHandlerI18NText.WriteErrorLostConnectionToLab, throwable, processInstance.getLabIndex());
    }

    private static FatalError msgWriteErrorToClient(Throwable throwable) {
        return new FatalError(FatalErrorHandlerI18NText.WriteErrorLostConnectionToClient, throwable, new Object[0]);
    }

    private static FatalError msgExecutorError(Throwable throwable) {
        return new FatalError(FatalErrorHandlerI18NText.InternalRuntimeError, throwable, new Object[0]);
    }

    private static final class FatalError
    implements I18NMatlabMessage,
    Serializable {
        private final FatalErrorHandlerI18NText fErrorText;
        private final Throwable fCause;
        private final Object[] fMessageArguments;

        FatalError(FatalErrorHandlerI18NText fatalErrorHandlerI18NText, Throwable throwable, Object ... objectArray) {
            this.fErrorText = fatalErrorHandlerI18NText;
            this.fMessageArguments = objectArray;
            this.fCause = throwable;
        }

        @Override
        public String getLocalizedMessage() {
            String string = this.fErrorText.createLocalizedMessage(this.fMessageArguments);
            if (null != this.fCause && this.fCause instanceof HasI18nMatlabErrorId) {
                string = string + " " + FatalErrorHandlerI18NText.CauseClause.createLocalizedMessage(this.fCause.getLocalizedMessage());
            }
            return string;
        }

        @Override
        public String getMessage() {
            String string = this.fErrorText.createMessage(this.fMessageArguments);
            if (null != this.fCause && this.fCause instanceof HasI18nMatlabErrorId) {
                string = string + " " + FatalErrorHandlerI18NText.CauseClause.createMessage(this.fCause.getLocalizedMessage());
            }
            return string;
        }

        @Override
        public String getMatlabErrorId() {
            return this.fErrorText.getMatlabErrorId();
        }
    }

    public static enum FatalErrorHandlerI18NText implements HasI18nMatlabErrorId,
    Serializable
    {
        CauseClause,
        LostConnectionToLab,
        LostConnectionToAnUnknownLab,
        LostConnectionToClient,
        ReadErrorLostConnectionToLab,
        ReadErrorLostConnectionToClient,
        WriteErrorLostConnectionToLab,
        WriteErrorLostConnectionToClient,
        InternalRuntimeError;

        private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.pmode.resources.RES_pmode";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "distcomp.matlabpool.";
        private static final String MATLAB_ERROR_ID_PREFIX = "distcomp:matlabpool:";

        @Override
        public String getMatlabErrorId() {
            return MATLAB_ERROR_ID_PREFIX + this.toString();
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BASE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.toString();
        }

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, false, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, false, objectArray);
        }
    }
}

