/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pml;

import com.mathworks.toolbox.distcomp.worker.Worker;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class LabCompatibilityChecker {
    public static final String[][] COMPATIBLE_COMPUTER_GROUPS = new String[][]{{"GLNXA64", "MACI64"}, {"PCWIN64"}, {"GLNX86", "MACI"}, {"PCWIN"}, {"MAC"}, {"SOL64"}};
    private static LabCompatibilityChecker sLabCompatibilityChecker = null;
    private static Map<String, Integer> sComputerToGroupMap = new HashMap<String, Integer>();

    private LabCompatibilityChecker() {
        for (int i = 0; i < COMPATIBLE_COMPUTER_GROUPS.length; ++i) {
            for (int j = 0; j < COMPATIBLE_COMPUTER_GROUPS[i].length; ++j) {
                sComputerToGroupMap.put(COMPATIBLE_COMPUTER_GROUPS[i][j], new Integer(i));
            }
        }
    }

    public boolean areComputersCompatible(String string, String string2) {
        Integer n = this.getWorkerGroupNumber(string);
        Integer n2 = this.getWorkerGroupNumber(string2);
        if (n != null && n2 != null) {
            return n.equals(n2);
        }
        return false;
    }

    public static LabCompatibilityChecker instance() {
        if (sLabCompatibilityChecker == null) {
            sLabCompatibilityChecker = new LabCompatibilityChecker();
        }
        return sLabCompatibilityChecker;
    }

    Worker[][] getCompatibleLabs(Worker[] workerArray) {
        TreeMap<Integer, List<Worker>> treeMap = new TreeMap<Integer, List<Worker>>();
        for (Worker object : workerArray) {
            this.addWorkerToMap(treeMap, object);
        }
        Worker[] workerArray2 = new Worker[treeMap.size()][];
        int n = 0;
        for (List<Worker> list : treeMap.values()) {
            workerArray2[n] = list.toArray(new Worker[list.size()]);
            ++n;
        }
        return workerArray2;
    }

    private void addWorkerToMap(TreeMap<Integer, List<Worker>> treeMap, Worker worker) {
        String string = null;
        try {
            string = worker.getComputerMLType();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Integer n = this.getWorkerGroupNumber(string);
        List<Worker> list = this.workersInGroup(treeMap, n);
        list.add(worker);
    }

    private Integer getWorkerGroupNumber(String string) {
        return sComputerToGroupMap.get(string);
    }

    private List<Worker> workersInGroup(TreeMap<Integer, List<Worker>> treeMap, Integer n) {
        List<Worker> list = treeMap.get(n);
        if (list == null) {
            treeMap.put(n, new ArrayList());
            list = treeMap.get(n);
        }
        return list;
    }
}

