/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.cwo;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.cwo.ByteArrayConcurrentBuffer;
import com.mathworks.toolbox.distcomp.mjs.cwo.ConcurrentBuffer;
import com.mathworks.toolbox.distcomp.mjs.cwo.Log;
import com.mathworks.toolbox.distcomp.mjs.cwo.NotifiableTaskReader;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskCWOStreamIdentifier;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class NotifyingWritablePipedStream
extends OutputStream {
    private final ConcurrentBuffer<byte[]> fBuffer;
    private final NotifiableTaskReader fReader;
    private final TaskCWOStreamIdentifier fTaskCWOStreamId;

    public NotifyingWritablePipedStream(TaskCWOStreamIdentifier taskCWOStreamIdentifier, NotifiableTaskReader notifiableTaskReader, int n) {
        this.fTaskCWOStreamId = taskCWOStreamIdentifier;
        this.fReader = notifiableTaskReader;
        this.fBuffer = new ByteArrayConcurrentBuffer(n);
    }

    @Override
    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        boolean bl;
        try {
            bl = this.fBuffer.checkEmptyAndPut(byArray);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Interrupted while waiting for buffer to drain.");
        }
        if (bl) {
            try {
                Log.LOGGER.log(DistcompLevel.SIX, "Notifying " + this.fReader + " of new bytes for " + this.fTaskCWOStreamId);
                this.fReader.notifyBytesAvailable(this.fTaskCWOStreamId);
            }
            catch (MJSException mJSException) {
                Log.LOGGER.log(DistcompLevel.ONE, "Failed to notify task: " + this.fTaskCWOStreamId + " of new bytes", mJSException);
                throw new IOException("Failed to notify reader of new bytes", mJSException);
            }
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.write(Arrays.copyOfRange(byArray, n, n2));
    }

    @Override
    public void flush() throws IOException {
        try {
            this.fBuffer.awaitEmpty();
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.ONE, "NotifyingWritablePipedStream interrupted during flush", interruptedException);
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    ConcurrentBuffer<byte[]> getBuffer() {
        return this.fBuffer;
    }
}

