/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.auth.AuthorisationContext;
import com.mathworks.toolbox.distcomp.auth.InvocationAdminOnly;
import com.mathworks.toolbox.distcomp.auth.InvocationChangePassword;
import com.mathworks.toolbox.distcomp.auth.InvocationNewAdminUser;
import com.mathworks.toolbox.distcomp.auth.InvocationNewUser;
import com.mathworks.toolbox.distcomp.auth.InvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.RemoteCredentialStorer;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.distcompobjects.ListenerInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxyPeerSession;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerRemote;
import com.mathworks.toolbox.distcomp.jobmanager.LogRetrievalException;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.InvocationWithDataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeDataInvoker;
import com.mathworks.toolbox.distcomp.mjs.datastore.NullLargeDataInvokerException;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.mjs.remoteio.RemoteOutputStreamImpl;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.pml.ParallelJobAccessLocal;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.DistcompServiceProxy;
import com.mathworks.toolbox.distcomp.service.ExportConfigInfo;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.service.ServiceExporterFactory;
import com.mathworks.toolbox.distcomp.test.CommTestInfo;
import com.mathworks.toolbox.distcomp.uddadaptor.DistcompObjectRemoteEventListener;
import com.mathworks.toolbox.distcomp.uddadaptor.MatlabEventAdaptor;
import com.mathworks.toolbox.distcomp.util.MCRShutdownHandler;
import com.mathworks.toolbox.distcomp.util.PortUnavailableException;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.DistcompListenableAccess;
import com.mathworks.toolbox.distcomp.workunit.JobAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.UUID;
import java.util.logging.Level;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;

public class JobManagerProxy
extends DistcompServiceProxy
implements JobManagerLocal {
    private static final long serialVersionUID = 1L;
    private final String fLookupURL;
    private final long fDataStoreMinLimit;
    private final String fSessionID;
    private final RemoteAuthorisationModule fRemoteAuth;
    private ServerSocketConnectInfo fPeerSessionConnectInfo;
    private final boolean fRequireWebLicensing;
    private ServerSocketAcceptInfo fWorkerAcceptInfoTemplate;
    private transient String fSSLCertificateAlias;
    private transient LargeDataInvoker fLargeDataInvoker;
    private transient DistcompObjectRemoteEventListener fEventForwarder;
    private transient ExporterFactory fCredentialProviderExporterFactory;
    private transient ExporterFactory fRemoteEventListenerExporterFactory;
    private transient ExporterFactory fLargeDataInvokerExporterFactory;
    private transient ExporterFactory fRemoteInputStreamFactoryExporterFactory;
    private transient ExporterFactory fLogExporterFactory;
    private transient PeerInstance fPeerInstance;
    private transient JobManagerProxyPeerSession fProxyPeerSession;
    private boolean fForceVanillaRmi = false;

    public JobManagerProxy(JobManagerRemote jobManagerRemote, Uuid uuid, long l, String[] stringArray, String string, String string2, String string3, String string4, String string5, RemoteAuthorisationModule remoteAuthorisationModule, int n, ServerSocketConnectInfo serverSocketConnectInfo, ServerSocketAcceptInfo serverSocketAcceptInfo, boolean bl) throws IOException {
        super(jobManagerRemote, uuid, stringArray, string, string2, string3, n);
        this.fLookupURL = string4;
        this.fDataStoreMinLimit = l;
        this.fSessionID = string5;
        this.fRemoteAuth = remoteAuthorisationModule;
        this.fPeerSessionConnectInfo = serverSocketConnectInfo;
        this.fWorkerAcceptInfoTemplate = serverSocketAcceptInfo;
        this.fRequireWebLicensing = bl;
    }

    @Override
    public String getSessionID() {
        return this.fSessionID;
    }

    @Override
    public synchronized void attachToListenableObject(DistcompListenableAccess distcompListenableAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        RemoteEventListener[] remoteEventListenerArray = new RemoteEventListener[]{(RemoteEventListener)this.fEventForwarder.getProxy()};
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        MarshalledObject[] marshalledObjectArray = new MarshalledObject[1];
        distcompListenableAccess.addEventListener(uuidArray, remoteEventListenerArray, lArray, lArray2, marshalledObjectArray);
    }

    @Override
    public ListenerInfo[] createListenerInfoArrayForAllEvents() throws IOException {
        MarshalledObject<Object> marshalledObject = new MarshalledObject<Object>(this.fEventForwarder.getProxy());
        long l = 0L;
        long l2 = 0L;
        MarshalledObject marshalledObject2 = null;
        ListenerInfo[] listenerInfoArray = new ListenerInfo[]{new ListenerInfo(marshalledObject, l, l2, marshalledObject2)};
        return listenerInfoArray;
    }

    @Override
    public synchronized void detachFromListenableObject(DistcompListenableAccess distcompListenableAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        RemoteEventListener[] remoteEventListenerArray = new RemoteEventListener[]{(RemoteEventListener)this.fEventForwarder.getProxy()};
        distcompListenableAccess.removeEventListener(uuidArray, remoteEventListenerArray);
    }

    @Override
    public synchronized void addEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) throws PortUnavailableException {
        if (this.fEventForwarder == null) {
            Exporter exporter = this.getRemoteEventListenerExporterFactory().createExporter();
            try {
                this.fEventForwarder = new DistcompObjectRemoteEventListener(exporter);
            }
            catch (ExportException exportException) {
                throw new PortUnavailableException();
            }
        }
        this.fEventForwarder.addEventAdaptor(matlabEventAdaptor);
    }

    @Override
    public void removeEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) {
        if (this.fEventForwarder != null) {
            this.fEventForwarder.removeEventAdaptor(matlabEventAdaptor);
        }
    }

    @Override
    public ServerSocketConnectInfo getBrokerServerSocketConnectInfo() {
        return this.fPeerSessionConnectInfo;
    }

    @Override
    public ServerSocketAcceptInfo getWorkerAcceptInfoTemplate() {
        return this.fWorkerAcceptInfoTemplate;
    }

    @Override
    public RemoteAuthorisationModule getRemoteAuth() {
        return this.fRemoteAuth.copy();
    }

    @Override
    public void pauseQueue() throws RemoteException, MJSException {
        this.getRemoteObject().pauseQueue();
    }

    @Override
    public void resumeQueue() throws RemoteException, MJSException {
        this.getRemoteObject().resumeQueue();
    }

    @Override
    public JobIDAndMLType[] getJobs() throws RemoteException {
        return this.getRemoteObject().getJobs();
    }

    @Override
    public JobIDAndMLType[][] getJobs(int[] nArray) throws RemoteException {
        return this.getRemoteObject().getJobs(nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uuid createJob(AuthorisationContext authorisationContext, final JobInfo jobInfo) throws RemoteException, MJSException {
        this.putJobDataInDataStore(jobInfo);
        RemoteCredentialStorer remoteCredentialStorer = new RemoteCredentialStorer(this.getCredentialProviderExporterFactory());
        JobManagerProxy.putCredentialsInCredentialStore(remoteCredentialStorer, jobInfo);
        UserIdentity userIdentity = new UserIdentity(jobInfo.getUserName());
        try {
            Uuid uuid = authorisationContext.invokeWithAuth(new InvocationWithAuth<Uuid>(userIdentity){

                @Override
                public Uuid invoke() throws RemoteException, MJSException {
                    return JobManagerProxy.this.getRemoteObject().createJob(jobInfo, this.getCredentialProvider());
                }
            });
            return uuid;
        }
        finally {
            remoteCredentialStorer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uuid createParallelJob(AuthorisationContext authorisationContext, final JobInfo jobInfo) throws RemoteException, MJSException {
        this.putJobDataInDataStore(jobInfo);
        RemoteCredentialStorer remoteCredentialStorer = new RemoteCredentialStorer(this.getCredentialProviderExporterFactory());
        JobManagerProxy.putCredentialsInCredentialStore(remoteCredentialStorer, jobInfo);
        UserIdentity userIdentity = new UserIdentity(jobInfo.getUserName());
        try {
            Uuid uuid = authorisationContext.invokeWithAuth(new InvocationWithAuth<Uuid>(userIdentity){

                @Override
                public Uuid invoke() throws RemoteException, MJSException {
                    return JobManagerProxy.this.getRemoteObject().createParallelJob(jobInfo, this.getCredentialProvider());
                }
            });
            return uuid;
        }
        finally {
            remoteCredentialStorer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uuid createMatlabPoolJob(AuthorisationContext authorisationContext, final JobInfo jobInfo, final byte[] byArray, final byte[] byArray2) throws RemoteException, MJSException {
        this.putJobDataInDataStore(jobInfo);
        RemoteCredentialStorer remoteCredentialStorer = new RemoteCredentialStorer(this.getCredentialProviderExporterFactory());
        JobManagerProxy.putCredentialsInCredentialStore(remoteCredentialStorer, jobInfo);
        UserIdentity userIdentity = new UserIdentity(jobInfo.getUserName());
        try {
            Uuid uuid = authorisationContext.invokeWithAuth(new InvocationWithAuth<Uuid>(userIdentity){

                @Override
                public Uuid invoke() throws RemoteException, MJSException {
                    return JobManagerProxy.this.getRemoteObject().createMatlabPoolJob(jobInfo, this.getCredentialProvider(), byArray, byArray2);
                }
            });
            return uuid;
        }
        finally {
            remoteCredentialStorer.dispose();
        }
    }

    private void putJobDataInDataStore(JobInfo jobInfo) throws DataStoreException, DistcompException, PortUnavailableException {
        LargeData[] largeDataArray = WorkUnitInfo.getWorkUnitInfoLargeDataItems(new JobInfo[]{jobInfo});
        LargeData[] largeDataArray2 = this.putLargeInputsInDataStore(largeDataArray);
        WorkUnitInfo.setWorkUnitInfoLargeDataItems(new JobInfo[]{jobInfo}, largeDataArray2);
    }

    private static void putCredentialsInCredentialStore(RemoteCredentialStorer remoteCredentialStorer, JobInfo jobInfo) throws CredentialTransferException, RemoteException {
        CredentialProviderLocal credentialProviderLocal = jobInfo.getLocalCredentialProvider();
        UserIdentity userIdentity = new UserIdentity(jobInfo.getUserName());
        CredentialProviderLocal credentialProviderLocal2 = remoteCredentialStorer.putCredentialsInCredentialStore(credentialProviderLocal, userIdentity);
        jobInfo.setLocalCredentialProvider(credentialProviderLocal2);
    }

    @Override
    public boolean requireWebLicensing() throws RemoteException {
        return this.fRequireWebLicensing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getClusterLogs(AuthorisationContext authorisationContext, OutputStream outputStream) throws RemoteException, MJSException {
        UserIdentity userIdentity = this.getRemoteObject().getAdminUserIdentity();
        final RemoteOutputStreamImpl remoteOutputStreamImpl = new RemoteOutputStreamImpl(outputStream, this.getLogExporterFactory().createExporter());
        try {
            authorisationContext.invokeWithAuth(new InvocationAdminOnly<Object>(userIdentity){

                @Override
                public Object invoke() throws RemoteException, MJSException {
                    try {
                        JobManagerProxy.this.getRemoteObject().getClusterLogs(remoteOutputStreamImpl.getProxy(), this.getCredentialProvider());
                    }
                    catch (IOException iOException) {
                        PackageInfo.LOGGER.log(Level.SEVERE, "Failed to retrieve logs from the job manager", iOException);
                        throw new LogRetrievalException("Failed to retrieve logs from the job manager", iOException);
                    }
                    return null;
                }
            });
        }
        finally {
            try {
                remoteOutputStreamImpl.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void setClusterLogLevel(AuthorisationContext authorisationContext, final int n) throws MJSException, RemoteException {
        UserIdentity userIdentity = this.getRemoteObject().getAdminUserIdentity();
        authorisationContext.invokeWithAuth(new InvocationAdminOnly<Object>(userIdentity){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                JobManagerProxy.this.getRemoteObject().setClusterLogLevel(n, this.getCredentialProvider());
                return null;
            }
        });
    }

    @Override
    public int getClusterLogLevel() throws MJSException, RemoteException {
        return this.getRemoteObject().getLogLevel();
    }

    @Override
    public int getNumIdleWorkers() throws RemoteException {
        return this.getRemoteObject().getNumIdleWorkers();
    }

    @Override
    public int getNumBusyWorkers() throws RemoteException {
        return this.getRemoteObject().getNumBusyWorkers();
    }

    @Override
    public Worker[] getIdleWorkers() throws RemoteException {
        return this.getRemoteObject().getIdleWorkers();
    }

    @Override
    public Worker[] getBusyWorkers() throws RemoteException {
        return this.getRemoteObject().getBusyWorkers();
    }

    @Override
    public JobAccessLocal getJobAccess() throws RemoteException, MJSException {
        JobAccessLocal jobAccessLocal = this.getRemoteObject().getJobAccess();
        if (jobAccessLocal != null) {
            jobAccessLocal.initLargeDataInvoker(this.getLargeDataInvokerOrNull());
        }
        return jobAccessLocal;
    }

    @Override
    public ParallelJobAccessLocal getParallelJobAccess() throws RemoteException, MJSException {
        ParallelJobAccessLocal parallelJobAccessLocal = this.getRemoteObject().getParallelJobAccess();
        if (parallelJobAccessLocal != null) {
            parallelJobAccessLocal.initLargeDataInvoker(this.getLargeDataInvokerOrNull());
        }
        return parallelJobAccessLocal;
    }

    @Override
    public TaskAccessLocal getTaskAccess() throws RemoteException, MJSException {
        TaskAccessLocal taskAccessLocal = this.getRemoteObject().getTaskAccess();
        if (taskAccessLocal != null) {
            taskAccessLocal.initLargeDataInvoker(this.getLargeDataInvokerOrNull());
            taskAccessLocal.initRemoteInputStreamExporterFactory(this.getRemoteInputStreamExporterFactory());
        }
        return taskAccessLocal;
    }

    @Override
    public WorkerRegistration getWorkerRegistration() throws RemoteException {
        return this.getRemoteObject().getWorkerRegistration();
    }

    @Override
    public boolean allowClientPasswordCache() throws RemoteException {
        return this.getRemoteObject().allowClientPasswordCache();
    }

    @Override
    public boolean testCommunication() {
        Throwable throwable;
        try {
            this.getRemoteObject().getState();
        }
        catch (RemoteException remoteException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "testCommunication failed due to a RemoteException", remoteException);
            return false;
        }
        if (this.usePeerRmi() && (throwable = this.getProxyPeerSession().hasErrored()) != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "testCommunication failed because the proxy peer session failed", throwable);
            return false;
        }
        return true;
    }

    @Override
    public void promote(Uuid uuid) throws RemoteException {
        this.getRemoteObject().promote(uuid);
    }

    @Override
    public void demote(Uuid uuid) throws RemoteException {
        this.getRemoteObject().demote(uuid);
    }

    @Override
    public String getLookupURL() {
        return this.fLookupURL;
    }

    @Override
    public void removeWorker(Uuid uuid) throws RemoteException {
        this.getRemoteObject().removeWorker(uuid);
    }

    @Override
    public void changeCredentialsOfExistingUser(AuthorisationContext authorisationContext, UserIdentity userIdentity) throws RemoteException, MJSException {
        UserIdentity userIdentity2 = authorisationContext.getCurrentUser();
        if (userIdentity == null) {
            userIdentity = userIdentity2;
        }
        authorisationContext.invokeWithAuth(new InvocationChangePassword(userIdentity, userIdentity2){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                JobManagerProxy.this.getRemoteObject().changeCredentialsOfExistingUser(this.getUserIdentity(), this.getTokenProvider(), this.getCredentialProvider());
                return null;
            }
        });
    }

    @Override
    public void checkCredentialsUserOnly(AuthorisationContext authorisationContext, final UserIdentity userIdentity) throws RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationWithAuth<Object>(userIdentity){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                JobManagerProxy.this.getRemoteObject().checkCredentialsUserOnly(userIdentity, this.getCredentialProvider());
                return null;
            }
        });
    }

    @Override
    public boolean userExists(UserIdentity userIdentity) throws RemoteException, MJSException {
        return this.getRemoteObject().userExists(userIdentity);
    }

    @Override
    public void addNewUser(AuthorisationContext authorisationContext, final UserIdentity userIdentity) throws RemoteException, MJSException {
        authorisationContext.invokeWithAuth(new InvocationNewUser(userIdentity){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                JobManagerProxy.this.getRemoteObject().addNewUser(userIdentity, this.getCredentialProvider());
                return null;
            }
        });
    }

    @Override
    public void addAdminUser(AuthorisationContext authorisationContext, SignatureModule.Signer signer) throws RemoteException, MJSException {
        UserIdentity userIdentity = this.getRemoteObject().getAdminUserIdentity();
        authorisationContext.invokeWithAuth(new InvocationNewAdminUser(userIdentity, signer){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                JobManagerProxy.this.getRemoteObject().addAdminUser(this.getCredentialProvider());
                return null;
            }
        });
    }

    @Override
    public void testCommunicationWithWorker(WorkerProxy workerProxy) throws RemoteException {
        BasicWorkerCommTestInfo basicWorkerCommTestInfo = new BasicWorkerCommTestInfo(workerProxy);
        this.testCommunicationWithClient(basicWorkerCommTestInfo);
    }

    @Override
    public void testTwoWayDataStoreCommunication() throws RemoteException, MJSException {
        this.setInvokeWithDataStore(new InvocationWithDataStore<Object>(){

            @Override
            public Object invoke() throws RemoteException, MJSException {
                JobManagerProxy.this.testCommunicationWithClient(new DataStoreCommTestInfo(this.getDataStore()));
                return null;
            }
        });
    }

    @Override
    public void testCommunicationWithClient(CommTestInfo commTestInfo) throws RemoteException {
        this.getRemoteObject().testCommunicationWithClient(commTestInfo);
    }

    @Override
    public synchronized String getSSLCertificateAlias() {
        if (this.fSSLCertificateAlias == null) {
            String string = UUID.randomUUID().toString();
            this.fSSLCertificateAlias = String.format("%s@%s %s", this.getName(), this.getLookupURL(), string);
        }
        return this.fSSLCertificateAlias;
    }

    @Override
    public void setSSLCertificate(Certificate certificate) {
        String string = this.getSSLCertificateAlias();
        ClientCertificateStore.getInstance().setCertificateEntry(string, certificate);
    }

    @Override
    public void setSSLCertificate(File file) throws CertificateException, FileNotFoundException {
        String string = this.getSSLCertificateAlias();
        ClientCertificateStore.getInstance().setCertificateEntry(string, file);
    }

    @Override
    public void setSSLCertificate(String string) throws CertificateException {
        String string2 = this.getSSLCertificateAlias();
        ClientCertificateStore.getInstance().setCertificateEntry(string2, string);
    }

    private void removeSSLCertificate() {
        String string = this.getSSLCertificateAlias();
        if (ClientCertificateStore.getInstance().containsEntry(string)) {
            ClientCertificateStore.getInstance().removeCertificateEntry(string);
        }
    }

    @Override
    public void forceVanillaRmi(boolean bl) {
        this.fForceVanillaRmi = bl;
    }

    @Override
    public long getDataStoreMinLimit() {
        return this.fDataStoreMinLimit;
    }

    private TransferableData[] putLargeInputsInDataStore(LargeData[] largeDataArray) throws DistcompException, DataStoreException, PortUnavailableException {
        return this.getLargeDataInvoker().putLargeInputsInDataStore(largeDataArray);
    }

    private <T> T setInvokeWithDataStore(InvocationWithDataStore<T> invocationWithDataStore) throws RemoteException, MJSException {
        return this.getLargeDataInvoker().setInvokeWithDataStore(invocationWithDataStore);
    }

    private JobManagerRemote getRemoteObject() throws DistcompProxy.DeserializeProxyException {
        return (JobManagerRemote)this.getSerializedProxy();
    }

    private synchronized LargeDataInvoker getLargeDataInvoker() throws PortUnavailableException, NullLargeDataInvokerException {
        LargeDataInvoker largeDataInvoker = this.getLargeDataInvokerOrNull();
        if (largeDataInvoker == null) {
            throw new NullLargeDataInvokerException("Client not configured correctly.");
        }
        return largeDataInvoker;
    }

    private LargeDataInvoker getLargeDataInvokerOrNull() throws PortUnavailableException {
        if (this.fLargeDataInvoker == null) {
            Exporter exporter = this.getLargeDataInvokerExporterFactory().createExporter();
            try {
                this.fLargeDataInvoker = LargeDataInvoker.createLargeDataInvoker(this.fDataStoreMinLimit, exporter);
            }
            catch (ExportException exportException) {
                throw new PortUnavailableException();
            }
        }
        return this.fLargeDataInvoker;
    }

    private synchronized ExporterFactory getRemoteInputStreamExporterFactory() {
        if (this.fRemoteInputStreamFactoryExporterFactory == null) {
            this.fRemoteInputStreamFactoryExporterFactory = this.createExporterFactory();
        }
        return this.fRemoteInputStreamFactoryExporterFactory;
    }

    private synchronized ExporterFactory getLargeDataInvokerExporterFactory() {
        if (this.fLargeDataInvokerExporterFactory == null) {
            this.fLargeDataInvokerExporterFactory = this.createExporterFactory();
        }
        return this.fLargeDataInvokerExporterFactory;
    }

    @Override
    public synchronized ExporterFactory getCredentialProviderExporterFactory() {
        if (this.fCredentialProviderExporterFactory == null) {
            this.fCredentialProviderExporterFactory = this.createExporterFactory();
        }
        return this.fCredentialProviderExporterFactory;
    }

    private synchronized ExporterFactory getRemoteEventListenerExporterFactory() {
        if (this.fRemoteEventListenerExporterFactory == null) {
            this.fRemoteEventListenerExporterFactory = this.createExporterFactory();
        }
        return this.fRemoteEventListenerExporterFactory;
    }

    private synchronized ExporterFactory getLogExporterFactory() {
        if (this.fLogExporterFactory == null) {
            this.fLogExporterFactory = this.createExporterFactory();
        }
        return this.fLogExporterFactory;
    }

    private ExporterFactory createExporterFactory() {
        if (!this.usePeerRmi()) {
            return this.createJrmpExporterFactory();
        }
        return this.createPeerRmiExporterFactory();
    }

    private ExporterFactory createJrmpExporterFactory() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating JRMP exporter factory.");
        int[] nArray = ExportConfigInfo.getPortRange();
        return new ServiceExporterFactory(nArray[0], nArray[1]);
    }

    private ExporterFactory createPeerRmiExporterFactory() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating PeerRmi exporter factory.");
        return this.getProxyPeerSession().createPeerRmiExporterFactory();
    }

    private boolean usePeerRmi() {
        return !this.fForceVanillaRmi && this.fPeerSessionConnectInfo != null;
    }

    private synchronized JobManagerProxyPeerSession getProxyPeerSession() {
        if (this.fProxyPeerSession == null) {
            this.fProxyPeerSession = new JobManagerProxyPeerSession(this.getPeerInstance(), this.fPeerSessionConnectInfo);
        }
        return this.fProxyPeerSession;
    }

    private synchronized PeerInstance getPeerInstance() {
        if (this.fPeerInstance == null) {
            this.fPeerInstance = new PeerInstance(ProtocolId.MJS, this.fPeerSessionConnectInfo.getGroupUUID(), UUID.randomUUID());
        }
        return this.fPeerInstance;
    }

    @Override
    public void addShutdownHookForCurrentMCR() {
        JobManagerProxyDisposer jobManagerProxyDisposer = new JobManagerProxyDisposer(this);
        MCRShutdownHandler.addShutdownHookForCurrentMCR(new Thread(jobManagerProxyDisposer));
    }

    @Override
    public synchronized void dispose() {
        if (this.fEventForwarder != null) {
            this.fEventForwarder.unexport();
        }
        this.fEventForwarder = null;
        if (this.fLargeDataInvoker != null) {
            this.fLargeDataInvoker.dispose();
        }
        this.fLargeDataInvoker = null;
        this.removeSSLCertificate();
        if (this.fProxyPeerSession != null) {
            this.fProxyPeerSession.shutdown();
        }
        this.fProxyPeerSession = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public WorkerProperties[] getIdleWorkerProperties() throws RemoteException {
        return this.getRemoteObject().getIdleWorkerProperties();
    }

    @Override
    public WorkerProperties[] getBusyWorkerProperties() throws RemoteException {
        return this.getRemoteObject().getBusyWorkerProperties();
    }

    private static class JobManagerProxyDisposer
    implements Runnable {
        private JobManagerProxy fProxy;

        JobManagerProxyDisposer(JobManagerProxy jobManagerProxy) {
            this.fProxy = jobManagerProxy;
        }

        @Override
        public void run() {
            this.fProxy.dispose();
        }
    }

    private static class DataStoreCommTestInfo
    implements CommTestInfo {
        private final DataStore fDataStoreProxy;

        DataStoreCommTestInfo(DataStore dataStore) {
            this.fDataStoreProxy = dataStore;
        }

        @Override
        public void testCommunication() throws RemoteException {
            if (this.fDataStoreProxy == null) {
                throw new DistcompException(new NullPointerException("DataStoreProxy was null"));
            }
            this.fDataStoreProxy.read(new DataStoreItem(0, this.fDataStoreProxy), 0);
        }
    }

    private static class BasicWorkerCommTestInfo
    implements CommTestInfo {
        private WorkerProxy fWorkerProxy;

        BasicWorkerCommTestInfo(WorkerProxy workerProxy) {
            this.fWorkerProxy = workerProxy;
        }

        @Override
        public void testCommunication() throws RemoteException {
            this.fWorkerProxy.getState();
        }
    }
}

