/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.servicerequest;

import com.mathworks.toolbox.distcomp.control.servicerequest.MdceShellCommand;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.cli.CommandCreationErrorCode;
import com.mathworks.toolbox.distcomp.remote.cli.CommandFactory;
import com.mathworks.toolbox.distcomp.remote.cli.I18nCommandCreationException;
import com.mathworks.toolbox.distcomp.remote.util.MatlabRootUnknownException;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.util.List;

public class MdceShellCommandFactory
implements CommandFactory<MdceShellCommand> {
    private static final String MDCE_COMMAND_TYPE = "mdce";
    private static final ParameterSet COMMAND_PARAMETERS = new ParameterSet(PathUtils.MatlabRootParameter.MATLAB_ROOT);
    private PathUtils.Platform fRemotePlatform = PathUtils.Platform.getLocal();

    @Override
    public MdceShellCommand createCommand(ParameterMap parameterMap, List<String> list) throws I18nCommandCreationException {
        try {
            Logger.LOGGER.finest("MATLAB_ROOT property is " + parameterMap.get(PathUtils.MatlabRootParameter.MATLAB_ROOT));
            String string = PathUtils.findMatlabRoot(parameterMap.get(PathUtils.MatlabRootParameter.MATLAB_ROOT));
            return MdceShellCommand.createMdceShellCommand(string, list, this.fRemotePlatform);
        }
        catch (MatlabRootUnknownException matlabRootUnknownException) {
            throw new CommandCreationMdceException(matlabRootUnknownException);
        }
    }

    @Override
    public Class<MdceShellCommand> getCommandClass() {
        return MdceShellCommand.class;
    }

    @Override
    public String getCommandType() {
        return MDCE_COMMAND_TYPE;
    }

    @Override
    public ParameterSet getParameterSet() {
        return COMMAND_PARAMETERS;
    }

    @Override
    public void setRemotePlatform(PathUtils.Platform platform) {
        this.fRemotePlatform = platform;
    }

    private static final class CommandCreationMdceException
    extends I18nCommandCreationException {
        private final Throwable fCause;

        CommandCreationMdceException(Throwable throwable) {
            super(CommandCreationErrorCode.MdceCommandCreation);
            this.fCause = throwable;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fCause};
        }
    }
}

