/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NodeServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class JobManagerServiceInfo
extends NodeServiceInfo<JobManagerNodeInfo> {
    private static final long serialVersionUID = -4195139762826380423L;
    private static final ServiceType sServiceType = ServiceType.JOBMANAGER;
    private List<String> fWorkerNames = new Vector<String>();
    private List<String> fWorkerHostNames;
    private Long fDatabaseSize;
    private Long fVMHeapSize;
    private Long fWorkerLeaseTimeout;

    public JobManagerServiceInfo(JobManagerNodeInfo jobManagerNodeInfo, Host host) {
        super(jobManagerNodeInfo, host);
        this.fWorkerNames.addAll(Arrays.asList(jobManagerNodeInfo.getWorkerNames()));
        this.fWorkerHostNames = new Vector<String>();
        this.fWorkerHostNames.addAll(Arrays.asList(jobManagerNodeInfo.getWorkerHostnames()));
        this.fDatabaseSize = jobManagerNodeInfo.getDatabaseSize();
        this.fVMHeapSize = jobManagerNodeInfo.getVMHeapSize();
        this.fWorkerLeaseTimeout = jobManagerNodeInfo.getWorkerLeaseTimeout();
    }

    public JobManagerServiceInfo(String string, Host host) {
        super(string, host, null, ServiceStatus.STOPPED);
        this.fWorkerHostNames = new Vector<String>();
        this.fDatabaseSize = null;
        this.fVMHeapSize = null;
        this.fWorkerLeaseTimeout = null;
    }

    public List<String> getWorkerNames() {
        return this.fWorkerNames;
    }

    public List<String> getWorkerHostNames() {
        return this.fWorkerHostNames;
    }

    @Override
    public String toString() {
        String string = "Jobmanager: " + super.toString();
        if (this.getStatus() == ServiceStatus.RUNNING) {
            string = string + " | " + this.fWorkerNames.size();
        }
        return string;
    }

    public Long getDatabaseSize() {
        return this.fDatabaseSize;
    }

    public Long getVMHeapSize() {
        return this.fVMHeapSize;
    }

    public Long getWorkerLeaseTimeout() {
        return this.fWorkerLeaseTimeout;
    }

    @Override
    protected ServiceType getServiceType() {
        return sServiceType;
    }
}

