/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerMessageSession;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerMessageSessionLeaseSource;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerSCHostParameterKey;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerSCShellSender;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegment;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegmentInputStream;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegmentOutputStream;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.ExceptionReturnMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.ExitStatusReturnMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionCancelMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionCommandMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.StreamSegmentMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.StreamSegmentReturnMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.SuccessfulDispatchMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.ProtocolFulfillmentException;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.LocalShellSender;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

public final class PeerSCShellFuture
implements ShellFuture,
MessageObserver,
StreamSegmentInputStream.EoFListener,
StreamSegmentOutputStream.StreamSegmentSink {
    private static final AtomicLong SEQUENCE_NUMBER_SOURCE = new AtomicLong(0L);
    private final long fSequenceNumber;
    private final ShellCommand fCommand;
    private final Lease<PeerMessageSession> fSessionLease;
    private final String fLogIdString;
    private final StreamSegmentInputStream fStdErr = new StreamSegmentInputStream("stderr", this);
    private final StreamSegmentInputStream fStdOut = new StreamSegmentInputStream("stdout", this);
    private final StreamSegmentOutputStream fStdIn = new StreamSegmentOutputStream("stdin", this);
    private final Lock fLock = new ReentrantLock();
    private final Condition fConfirmStarted = this.fLock.newCondition();
    private boolean fHasConfirmedStart = false;
    private DispatchException fDispatchException = null;
    private final Condition fEnded = this.fLock.newCondition();
    private boolean fHasEnded = false;
    private int fExitStatus;
    private boolean fExitStatusSet = false;
    private FulfillmentException fFulfillmentException = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PeerSCShellFuture createPeerSCShellFuture(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws DispatchException {
        int n = parameterMap.getOrSuggest(PeerSCShellSender.PeerSCParameter.PORT);
        String string2 = PeerSCShellFuture.createLogId(shellCommand, string, n);
        Lease<PeerMessageSession> lease = null;
        boolean bl = false;
        try {
            PeerSCHostParameterKey peerSCHostParameterKey = new PeerSCHostParameterKey(string, parameterMap);
            lease = PeerMessageSessionLeaseSource.INSTANCE.getLease(peerSCHostParameterKey);
            Log.LOGGER.finest(string2 + ": claimed lease " + lease);
            PeerSCShellFuture peerSCShellFuture = new PeerSCShellFuture(shellCommand, parameterMap, string2, lease);
            peerSCShellFuture.awaitConfirmStart();
            bl = true;
            Log.LOGGER.fine(string2 + ": started");
            PeerSCShellFuture peerSCShellFuture2 = peerSCShellFuture;
            return peerSCShellFuture2;
        }
        finally {
            if (!bl && lease != null) {
                lease.release();
                Log.LOGGER.finest(string2 + ": released lease " + lease);
            }
        }
    }

    private static String createLogId(ShellCommand shellCommand, String string, int n) {
        String string2;
        List<String> list = shellCommand.getCommand();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            string2 = iterator.next();
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" ");
        }
        string2 = stringBuilder.toString();
        return string + ":" + n + " " + string2;
    }

    private PeerSCShellFuture(ShellCommand shellCommand, ParameterMap parameterMap, String string, Lease<PeerMessageSession> lease) throws ProtocolDispatchException {
        this.fCommand = shellCommand;
        this.fLogIdString = string;
        this.fSessionLease = lease;
        this.fSequenceNumber = SEQUENCE_NUMBER_SOURCE.getAndIncrement();
        ParameterMap parameterMap2 = parameterMap.createCopyRetaining(LocalShellSender.LOCAL_PARAMETER_SET);
        RemoteExecutionCommandMessage remoteExecutionCommandMessage = new RemoteExecutionCommandMessage(shellCommand, parameterMap2, this.fSequenceNumber);
        Log.LOGGER.finest(string + ": about to send command " + remoteExecutionCommandMessage);
        this.fSessionLease.getLeasedConnection().sendCommandMessage(remoteExecutionCommandMessage, this);
        Log.LOGGER.finest(string + ": sent command " + remoteExecutionCommandMessage);
    }

    private void awaitConfirmStart() throws ProtocolDispatchException {
        try {
            this.fLock.lock();
            if (!this.fHasConfirmedStart) {
                Log.LOGGER.finest(this.fLogIdString + ": start awaiting confirm start ");
                this.fConfirmStarted.await();
                Log.LOGGER.finest(this.fLogIdString + ": finish awaiting confirm start ");
            }
            if (this.fDispatchException != null) {
                throw new ProtocolDispatchException(this.fDispatchException);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ProtocolDispatchException(this.fLogIdString + ": While awaiting confirm start", (Throwable)interruptedException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalConfirmStart() {
        try {
            this.fLock.lock();
            assert (!this.fHasConfirmedStart) : "signalConfirmStart() should be called exactly once.";
            this.fHasConfirmedStart = true;
            this.fConfirmStarted.signalAll();
            Log.LOGGER.finest(this.fLogIdString + ": confirmed start signaled to stop waiting.");
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDispatchExceptionAndFailToStart(DispatchException dispatchException) {
        try {
            this.fLock.lock();
            this.fDispatchException = dispatchException;
            Log.LOGGER.log(Level.WARNING, this.fLogIdString + ": During dispatch: ", this.fDispatchException);
            this.signalConfirmStart();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void cancel() {
        Log.LOGGER.finest(this.fLogIdString + ": cancel procedure started");
        RemoteExecutionCancelMessage remoteExecutionCancelMessage = new RemoteExecutionCancelMessage(this.fSequenceNumber);
        this.fSessionLease.getLeasedConnection().sendMessage(remoteExecutionCancelMessage);
        Log.LOGGER.finest(this.fLogIdString + ": cancel message sent.");
        try {
            this.fStdIn.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(Level.WARNING, this.fLogIdString + ": while closing stdout.", iOException);
        }
        try {
            this.fStdOut.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(Level.WARNING, this.fLogIdString + ": while closing stdout.", iOException);
        }
        try {
            this.fStdErr.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(Level.WARNING, this.fLogIdString + ": while closing stderr.", iOException);
        }
        this.signalEnd();
        Log.LOGGER.fine(this.fLogIdString + ": canceled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        try {
            this.fLock.lock();
            boolean bl = !this.fHasEnded;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        try {
            this.fLock.lock();
            if (!this.fHasEnded) {
                Log.LOGGER.finest(this.fLogIdString + ": started awaiting end.");
                this.fEnded.await();
                Log.LOGGER.finest(this.fLogIdString + ": finished awaiting end.");
            }
            if (this.fFulfillmentException != null) {
                throw new ProtocolFulfillmentException(this.fFulfillmentException);
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalEnd() {
        try {
            this.fLock.lock();
            this.fHasEnded = true;
            this.fSessionLease.release();
            this.fEnded.signalAll();
            Log.LOGGER.finest(this.fLogIdString + ": signalled end.");
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExitStatus(int n) {
        try {
            this.fLock.lock();
            this.fExitStatus = n;
            this.fExitStatusSet = true;
            Log.LOGGER.finest(this.fLogIdString + ": exit status set to " + this.fExitStatus);
        }
        finally {
            this.fLock.unlock();
        }
        this.checkEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnded() {
        Log.LOGGER.finest(this.fLogIdString + ": checking ended start");
        boolean bl = this.fStdErr.isAtEoF();
        boolean bl2 = this.fStdOut.isAtEoF();
        try {
            this.fLock.lock();
            Log.LOGGER.finest(this.fLogIdString + ": checking ended with exit status " + this.fExitStatusSet + " stderr " + bl + " stdout " + bl2);
            if (this.fExitStatusSet && bl && bl2) {
                this.signalEnd();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFulfillmentExceptionAndEnd(FulfillmentException fulfillmentException) {
        try {
            this.fLock.lock();
            this.fFulfillmentException = fulfillmentException;
            this.signalEnd();
            Log.LOGGER.log(Level.WARNING, this.fLogIdString + ": During fulfillment: ", this.fFulfillmentException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean isExitStatusOfRemoteCommand() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getExitStatus() throws InterruptedException, FulfillmentException {
        try {
            this.fLock.lock();
            this.awaitEnd();
            int n = this.fExitStatus;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public InputStream getErrorStream() throws RemoteStreamException {
        return this.fStdErr;
    }

    @Override
    public OutputStream getOutputStream() throws RemoteStreamException {
        return this.fStdIn;
    }

    @Override
    public InputStream getInputStream() throws RemoteStreamException {
        return this.fStdOut;
    }

    @Override
    public void reachedEoF() {
        this.checkEnded();
    }

    @Override
    public void putStreamSegment(StreamSegment streamSegment) {
        StreamSegmentMessage streamSegmentMessage = new StreamSegmentMessage(this.fSequenceNumber, streamSegment);
        this.fSessionLease.getLeasedConnection().sendMessage(streamSegmentMessage);
        Log.LOGGER.finest(this.fLogIdString + ": sent " + streamSegmentMessage);
    }

    @Override
    public void completed(ReturnMessage returnMessage, Instance instance) {
        Log.LOGGER.finest(this.fLogIdString + ":received " + returnMessage);
        if (returnMessage instanceof FinalReturnMessage) {
            this.handleFinalReturnMessage((FinalReturnMessage)returnMessage);
        } else if (returnMessage instanceof SuccessfulDispatchMessage) {
            this.signalConfirmStart();
        } else if (returnMessage instanceof StreamSegmentReturnMessage) {
            this.handleStreamSegmentReturnMessage((StreamSegmentReturnMessage)returnMessage);
        } else {
            Log.LOGGER.warning(this.fLogIdString + ": Don't understand " + returnMessage + " " + returnMessage.getClass());
            assert (false) : "Don't understand " + returnMessage + " " + returnMessage.getClass();
        }
    }

    private void handleFinalReturnMessage(FinalReturnMessage finalReturnMessage) {
        if (finalReturnMessage instanceof ExitStatusReturnMessage) {
            ExitStatusReturnMessage exitStatusReturnMessage = (ExitStatusReturnMessage)finalReturnMessage;
            this.setExitStatus(exitStatusReturnMessage.getExitStatus());
        } else if (finalReturnMessage instanceof ExceptionReturnMessage) {
            this.handleExceptionReturnMessage((ExceptionReturnMessage)finalReturnMessage);
        } else {
            Log.LOGGER.warning(this.fLogIdString + ": Don't understand " + finalReturnMessage + " " + finalReturnMessage.getClass());
            assert (false) : "Don't understand " + finalReturnMessage + " " + finalReturnMessage.getClass();
        }
    }

    private void handleExceptionReturnMessage(ExceptionReturnMessage exceptionReturnMessage) {
        RemoteExecutionException remoteExecutionException = exceptionReturnMessage.getException();
        if (remoteExecutionException instanceof FulfillmentException) {
            FulfillmentException fulfillmentException = (FulfillmentException)remoteExecutionException;
            this.setFulfillmentExceptionAndEnd(fulfillmentException);
        } else if (remoteExecutionException instanceof DispatchException) {
            DispatchException dispatchException = (DispatchException)remoteExecutionException;
            this.setDispatchExceptionAndFailToStart(dispatchException);
        } else {
            Log.LOGGER.warning(this.fLogIdString + ": Don't understand " + exceptionReturnMessage + " " + exceptionReturnMessage.getClass());
            assert (false) : "Don't understand " + exceptionReturnMessage + " " + exceptionReturnMessage.getClass() + " " + remoteExecutionException.getClass();
        }
    }

    private void handleStreamSegmentReturnMessage(StreamSegmentReturnMessage streamSegmentReturnMessage) {
        StreamSegment streamSegment = streamSegmentReturnMessage.getStreamSegment();
        if ("stderr".equals(streamSegment.getStreamName())) {
            this.fStdErr.putStreamSegment(streamSegment);
        } else if ("stdout".equals(streamSegment.getStreamName())) {
            this.fStdOut.putStreamSegment(streamSegment);
        } else {
            Log.LOGGER.warning(this.fLogIdString + ": Don't know how to route streamSegment with name " + streamSegment.getStreamName());
            assert (false) : "Don't know how to route streamSegment with name " + streamSegment.getStreamName();
        }
    }
}

