/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerMessageSession;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerSCShellSender;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsRemoteExecutionException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsRemoteExecutionSession;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionCommandMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.RemoteExecutionMessage;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionFatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.io.File;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

final class PeerSCMessageSession
implements PeerMessageSession {
    private final ParameterMap fParameterMap;
    private final String fHostName;
    private final UUID fGroupUuid;
    private PeerSession fClientPeerSession = null;
    private Instance fRemotePeer = null;
    private AtomicBoolean fIsConnected = new AtomicBoolean(false);
    private Lock fWindowsServiceLock = new ReentrantLock();
    private boolean fIsWindowsServiceRunning = false;
    private WindowsRemoteExecutionSession fWindowsRemoteExecutionSession = null;

    PeerSCMessageSession(String string, ParameterMap parameterMap) {
        this.fHostName = string;
        this.fParameterMap = parameterMap;
        this.fGroupUuid = UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWindowsService(int n) throws WindowsRemoteExecutionException {
        File file = new File(this.fParameterMap.getOrSuggest(PathUtils.MatlabRootParameter.MATLAB_ROOT));
        long l = 5000L;
        Log.LOGGER.finest(this.fHostName + ": Attempting to start on port:" + n + " matlabroot:" + file);
        this.fWindowsServiceLock.lock();
        try {
            this.fWindowsRemoteExecutionSession = new WindowsRemoteExecutionSession(this.fHostName, n, this.fGroupUuid, file.toString(), l);
            this.fWindowsRemoteExecutionSession.start();
            Log.LOGGER.finest(this.fHostName + ": Started on port:" + n + " matlabroot:" + file);
            this.fIsWindowsServiceRunning = true;
        }
        finally {
            this.fWindowsServiceLock.unlock();
        }
    }

    private void connectSession(int n) throws ProtocolDispatchException {
        Connection connection;
        UUID uUID = UUID.randomUUID();
        PeerInstance peerInstance = new PeerInstance(ProtocolId.WINSC, this.fGroupUuid, uUID);
        ServerSocketConnectInfo serverSocketConnectInfo = new ServerSocketConnectInfo(this.fHostName, n, this.fGroupUuid, (ConnectorSecurityDescription)new ConnectorPlainSecurityDescription(), 10000L);
        PeerConnector peerConnector = new PeerConnector();
        try {
            connection = peerConnector.activelyConnectTo(serverSocketConnectInfo, 100L, 10000L, peerInstance);
            Log.LOGGER.finest(this.fHostName + ": connected via " + connection);
        }
        catch (PeerMessagingException peerMessagingException) {
            throw new ProtocolDispatchException(peerMessagingException);
        }
        this.fRemotePeer = connection.getRemoteInstance();
        HashSet<PeerDispatcher<? extends Message>> hashSet = new HashSet<PeerDispatcher<? extends Message>>();
        HashSet<Connection> hashSet2 = new HashSet<Connection>();
        hashSet2.add(connection);
        this.fClientPeerSession = new PeerSession(peerInstance, new PeerSessionFatalErrorHandler(), hashSet, hashSet2);
        Log.LOGGER.finest(this.fHostName + ": set up dispatchers.");
        this.fIsConnected.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws DispatchException {
        try {
            int n = this.fParameterMap.getOrSuggest(PeerSCShellSender.PeerSCParameter.PORT);
            this.startWindowsService(n);
            this.connectSession(n);
        }
        finally {
            if (!this.fIsConnected.get()) {
                Log.LOGGER.finest(this.fHostName + ": did not connect.");
                this.disconnect();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.fIsConnected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.fClientPeerSession != null) {
            this.fClientPeerSession.normalShutdown();
            Log.LOGGER.finest(this.fHostName + ": shut down client peer.");
        }
        this.fWindowsServiceLock.lock();
        try {
            if (this.fWindowsRemoteExecutionSession != null && this.fIsWindowsServiceRunning) {
                try {
                    this.fWindowsRemoteExecutionSession.stop();
                    this.fIsWindowsServiceRunning = false;
                    Log.LOGGER.finest(this.fHostName + ": remote execution session stopped.");
                }
                catch (WindowsRemoteExecutionException windowsRemoteExecutionException) {
                    Log.LOGGER.log(Level.SEVERE, "Failed to stop Remote Execution Service", windowsRemoteExecutionException);
                }
            }
        }
        finally {
            this.fWindowsServiceLock.unlock();
        }
        this.fIsConnected.set(false);
    }

    @Override
    public void sendCommandMessage(RemoteExecutionCommandMessage remoteExecutionCommandMessage, MessageObserver messageObserver) {
        this.fClientPeerSession.getOutputGroup().sendTo(this.fRemotePeer, remoteExecutionCommandMessage, messageObserver);
        Log.LOGGER.finest(this.fHostName + " was sent " + remoteExecutionCommandMessage);
    }

    @Override
    public void sendMessage(RemoteExecutionMessage remoteExecutionMessage) {
        this.fClientPeerSession.getOutputGroup().sendTo(this.fRemotePeer, remoteExecutionMessage);
        Log.LOGGER.finest(this.fHostName + " was sent " + remoteExecutionMessage);
    }
}

