/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.CommandListener;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.MDCSHostInfo;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.StatusResults;
import com.mathworks.toolbox.distcomp.control.serviceinfo.CheckpointDirInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.StatusRequestResponse;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.jobmanager.JobManager;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.util.ActivationAdminWrapper;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.Version;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class StatusCommand
extends MDCSCommand {
    private static final long serialVersionUID = 1L;
    private String fRemoteHostname = "";
    private int fInfolevel;
    private boolean fProduceStatusRequestResponse = false;
    private String fUserSpecifiedHostName = null;
    private static final Object UNPARSABLE_BASEPORT_STR = "UNPARSABLE_BASEPORT_STR";

    public StatusCommand(int n) {
        this.fInfolevel = n;
    }

    public void setRemoteHostname(String string) {
        this.fRemoteHostname = string != null ? string : "";
    }

    @Override
    public String getPreRunDescription() {
        if (this.fRemoteHostname.length() == 0) {
            return "Retrieving the node status.";
        }
        return "Retrieving the node status on the host " + this.fRemoteHostname + ".";
    }

    public void produceStatusRequestResponse(boolean bl) {
        this.fProduceStatusRequestResponse = bl;
    }

    public void setUserSpecifiedHostName(String string) {
        this.fUserSpecifiedHostName = string;
    }

    @Override
    public MDCSCommandResults run() throws Exception {
        int n;
        String string = System.getProperty("com.mathworks.toolbox.distcomp.hostname", null);
        String string2 = System.getProperty("com.mathworks.toolbox.distcomp.base_port", null);
        Integer n2 = Integer.getInteger("com.mathworks.toolbox.distcomp.securityLevel");
        Date date = CommandListener.getStartTime();
        MDCSHostInfo mDCSHostInfo = MDCSHostInfo.forLocalHost();
        String string3 = System.getProperty("com.mathworks.toolbox.distcomp.matlabroot", null);
        String string4 = System.getProperty("com.mathworks.toolbox.distcomp.mdceDefFile", null);
        String string5 = Version.VERSION_STRING;
        if (this.fUserSpecifiedHostName == null) {
            this.setUserSpecifiedHostName(string);
        }
        Host host = new Host(this.fUserSpecifiedHostName, string);
        try {
            n = PortConfig.getPhoenixPort(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DistcompDiagnosticException((Throwable)illegalArgumentException, UNPARSABLE_BASEPORT_STR, new Object[]{string2}){};
        }
        ActivationAdminWrapper activationAdminWrapper = new ActivationAdminWrapper(string, n);
        activationAdminWrapper.verifyAdminTryManyTimes();
        WorkerNodeInfo[] workerNodeInfoArray = this.getWorkerNodeInfoArray(activationAdminWrapper);
        JobManagerNodeInfo[] jobManagerNodeInfoArray = this.getJobManagerNodeInfoArray(activationAdminWrapper);
        MDCSServiceInfo mDCSServiceInfo = MDCSServiceInfo.createRunningInfo(host, date, activationAdminWrapper.hasLookup(), mDCSHostInfo, n2, string5, string3, string4);
        List<ServiceInfo> list = this.getStoppedServicesList(this.fUserSpecifiedHostName);
        if (this.fProduceStatusRequestResponse) {
            return StatusRequestResponse.create(jobManagerNodeInfoArray, workerNodeInfoArray, mDCSServiceInfo, list, this.fInfolevel);
        }
        return StatusResults.create(jobManagerNodeInfoArray, workerNodeInfoArray, mDCSServiceInfo, list, this.fInfolevel);
    }

    private JobManagerNodeInfo[] getJobManagerNodeInfoArray(ActivationAdminWrapper activationAdminWrapper) {
        JobManager[] jobManagerArray = activationAdminWrapper.getJobManagers();
        JobManagerNodeInfo[] jobManagerNodeInfoArray = null;
        if (jobManagerArray != null) {
            jobManagerNodeInfoArray = new JobManagerNodeInfo[jobManagerArray.length];
            for (int i = 0; i < jobManagerArray.length; ++i) {
                try {
                    jobManagerNodeInfoArray[i] = (JobManagerNodeInfo)jobManagerArray[i].getNodeInfo();
                    continue;
                }
                catch (RemoteException remoteException) {
                    jobManagerNodeInfoArray[i] = null;
                }
            }
        }
        return jobManagerNodeInfoArray;
    }

    private WorkerNodeInfo[] getWorkerNodeInfoArray(ActivationAdminWrapper activationAdminWrapper) {
        Worker[] workerArray = activationAdminWrapper.getWorkers();
        WorkerNodeInfo[] workerNodeInfoArray = null;
        if (workerArray != null) {
            workerNodeInfoArray = new WorkerNodeInfo[workerArray.length];
            for (int i = 0; i < workerArray.length; ++i) {
                try {
                    workerNodeInfoArray[i] = (WorkerNodeInfo)workerArray[i].getNodeInfo();
                    continue;
                }
                catch (RemoteException remoteException) {
                    workerNodeInfoArray[i] = null;
                }
            }
            Arrays.sort(workerNodeInfoArray, new NameComparator());
        }
        return workerNodeInfoArray;
    }

    private List<ServiceInfo> getStoppedServicesList(String string) {
        return CheckpointDirInfo.getStoppedServicesList(string);
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 10000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 2000;
    }

    private static class NameComparator
    implements Comparator<WorkerNodeInfo> {
        private NameComparator() {
        }

        @Override
        public int compare(WorkerNodeInfo workerNodeInfo, WorkerNodeInfo workerNodeInfo2) {
            String string = workerNodeInfo == null ? "" : workerNodeInfo.getName();
            String string2 = workerNodeInfo2 == null ? "" : workerNodeInfo2.getName();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }
}

