/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotConnectException;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotMakeRemoteDataLocationException;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotSendJobFilesException;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.JobAlreadyMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.Logger;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.clusteraccess.SharedPath;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FileSystemManipulatorFuture;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.MakeDirectoryCommand;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.spi.FileSystemManipulator;
import java.io.File;
import java.util.Set;

final class UploadFilesChore
extends OneTimeChore {
    private final MirrorFilesInfo fMirrorFilesInfo;

    UploadFilesChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string, parameterMap, fileMirrorControl);
        this.fMirrorFilesInfo = mirrorFilesInfo;
    }

    @Override
    public boolean runChore() throws CouldNotSendJobFilesException, CouldNotMakeRemoteDataLocationException, JobAlreadyMirroredException, CouldNotConnectException {
        this.sendFiles();
        if (!this.hasBeenCanceled()) {
            this.getFileMirrorControl().startMirrorForJob(this.fMirrorFilesInfo);
            return true;
        }
        return false;
    }

    @Override
    FileSystemManipulatorFuture getFuture() throws InterruptedException {
        return (FileSystemManipulatorFuture)super.getFuture();
    }

    private void sendFiles() throws CouldNotSendJobFilesException, CouldNotMakeRemoteDataLocationException {
        try {
            FileSystemManipulator fileSystemManipulator = (FileSystemManipulator)ProtocolProvider.getInstance().getProtocolByType("sftp");
            if (this.fMirrorFilesInfo.getMakeRemoteDataLocationOnFirstUse()) {
                this.makeRemoteDataLocation(fileSystemManipulator);
            }
            for (SharedPath sharedPath : this.fMirrorFilesInfo.getDataFilePaths()) {
                this.sendFile(sharedPath, fileSystemManipulator);
            }
            for (SharedPath sharedPath : this.fMirrorFilesInfo.getStateFilePaths()) {
                this.sendFile(sharedPath, fileSystemManipulator);
            }
        }
        catch (NoSuchProtocolException noSuchProtocolException) {
            AssertionError assertionError = new AssertionError((Object)"Someone's removed sftp from the ProtocolProvider");
            ((Throwable)((Object)assertionError)).initCause(noSuchProtocolException);
            throw assertionError;
        }
    }

    private void makeRemoteDataLocation(FileSystemManipulator fileSystemManipulator) throws CouldNotMakeRemoteDataLocationException {
        if (!this.hasBeenCanceled()) {
            MakeDirectoryCommand makeDirectoryCommand = new MakeDirectoryCommand(this.fMirrorFilesInfo.getRemoteDataLocation(), true);
            Logger.LOGGER.finest(this.logPrefix() + "About to make " + this.fMirrorFilesInfo.getRemoteDataLocation() + " if it does not exist");
            try {
                this.performRemoteCommand(makeDirectoryCommand, fileSystemManipulator, "Started making " + this.fMirrorFilesInfo.getRemoteDataLocation() + " for job " + this.fMirrorFilesInfo.getJobId());
            }
            catch (DispatchException dispatchException) {
                throw new CouldNotMakeRemoteDataLocationException(this.fMirrorFilesInfo.getJobId(), this.fMirrorFilesInfo.getRemoteDataLocation(), dispatchException);
            }
            this.awaitEndOfMakingDirectory();
        }
    }

    private void awaitEndOfMakingDirectory() throws CouldNotMakeRemoteDataLocationException {
        try {
            if (!this.hasBeenCanceled()) {
                this.awaitEndOfFuture();
                Logger.LOGGER.finer(this.logPrefix() + "Finished making " + this.fMirrorFilesInfo.getRemoteDataLocation());
            }
        }
        catch (FulfillmentException fulfillmentException) {
            throw new CouldNotMakeRemoteDataLocationException(this.fMirrorFilesInfo.getJobId(), this.fMirrorFilesInfo.getRemoteDataLocation(), fulfillmentException);
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotMakeRemoteDataLocationException(this.fMirrorFilesInfo.getJobId(), this.fMirrorFilesInfo.getRemoteDataLocation(), interruptedException);
        }
    }

    private void sendFile(SharedPath sharedPath, FileSystemManipulator fileSystemManipulator) throws CouldNotSendJobFilesException {
        if (!this.hasBeenCanceled()) {
            Set<File> set = SharedPath.sharedPathsToLocalFiles(this.fMirrorFilesInfo.getExcludeFromUpload(), this.fMirrorFilesInfo.getLocalDataLocation());
            CopyToRemoteCommand copyToRemoteCommand = new CopyToRemoteCommand(sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation()), sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation()), set);
            Logger.LOGGER.finest(this.logPrefix() + "About to start to send " + sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation()) + " to " + this.getHostname() + ":" + sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation()));
            try {
                this.performRemoteCommand(copyToRemoteCommand, fileSystemManipulator, "Started sending " + sharedPath + " for job " + this.fMirrorFilesInfo.getJobId());
            }
            catch (DispatchException dispatchException) {
                throw new CouldNotSendJobFilesException(this.fMirrorFilesInfo.getJobId(), sharedPath, (RemoteExecutionException)dispatchException);
            }
            this.awaitEndOfSendingFile(sharedPath);
        }
    }

    private void awaitEndOfSendingFile(SharedPath sharedPath) throws CouldNotSendJobFilesException {
        try {
            if (!this.hasBeenCanceled()) {
                this.awaitEndOfFuture();
                this.fMirrorFilesInfo.addToSentFiles(SharedPath.remotePathKeysToSharedPathKeys(this.getFuture().getFileAttributes(), this.fMirrorFilesInfo.getRemoteDataLocation()));
                Logger.LOGGER.finer(this.logPrefix() + "Finished sending " + sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation()) + " to " + this.getHostname() + ":" + sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation()));
            }
        }
        catch (FulfillmentException fulfillmentException) {
            throw new CouldNotSendJobFilesException(this.fMirrorFilesInfo.getJobId(), sharedPath, (RemoteExecutionException)fulfillmentException);
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotSendJobFilesException(this.fMirrorFilesInfo.getJobId(), sharedPath, interruptedException);
        }
    }

    @Override
    public String logPrefix() {
        return "Upload files for job " + this.fMirrorFilesInfo.getJobId() + " to " + this.getHostname() + ": ";
    }
}

