/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.JobNotMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.Logger;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesHelper;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class LastMirrorFilesChore
extends OneTimeChore {
    private MirrorFilesHelper fHelper = null;
    private final MirrorFilesChore fOriginalChore;
    private final Lock fLock = new ReentrantLock();

    LastMirrorFilesChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string, parameterMap, fileMirrorControl);
        this.fHelper = new MirrorFilesHelper(mirrorFilesInfo, string, parameterMap);
        this.fOriginalChore = null;
    }

    LastMirrorFilesChore(MirrorFilesChore mirrorFilesChore, FileMirrorControl fileMirrorControl) {
        super(mirrorFilesChore.getHostname(), mirrorFilesChore.getParameterMap(), fileMirrorControl);
        this.fOriginalChore = mirrorFilesChore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        try {
            this.fLock.lock();
            super.cancel();
            MirrorFilesHelper mirrorFilesHelper = this.getHelper();
            if (mirrorFilesHelper != null) {
                mirrorFilesHelper.cancel();
            }
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.fine(this.logPrefix() + "Canceled");
    }

    @Override
    public boolean runChore() throws JobNotMirroredException {
        if (!this.hasBeenCanceled()) {
            MirrorFilesHelper mirrorFilesHelper = this.getAndPossiblyCreateHelper();
            return mirrorFilesHelper.runChore();
        }
        return false;
    }

    private MirrorFilesHelper getAndPossiblyCreateHelper() throws JobNotMirroredException {
        MirrorFilesHelper mirrorFilesHelper = this.getHelper();
        if (mirrorFilesHelper == null) {
            this.createHelper();
            mirrorFilesHelper = this.getHelper();
        }
        return mirrorFilesHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MirrorFilesHelper getHelper() {
        try {
            this.fLock.lock();
            MirrorFilesHelper mirrorFilesHelper = this.fHelper;
            return mirrorFilesHelper;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHelper(MirrorFilesHelper mirrorFilesHelper) {
        try {
            this.fLock.lock();
            this.fHelper = mirrorFilesHelper;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void createHelper() throws JobNotMirroredException {
        assert (this.fOriginalChore != null) : "Can not initialize a helper without a chore, but fOriginalChore is null";
        if (!this.hasBeenCanceled()) {
            try {
                MirrorFilesHelper mirrorFilesHelper = this.fOriginalChore.copyHelper();
                this.setHelper(mirrorFilesHelper);
            }
            catch (InterruptedException interruptedException) {
                throw new JobNotMirroredException("Interrupted while waiting for a safe copy of job file state", this.fOriginalChore.getJobId(), interruptedException);
            }
        }
    }

    private int getJobId() {
        if (this.fOriginalChore != null) {
            return this.fOriginalChore.getJobId();
        }
        return this.getHelper().getJobFileInfo().getJobId();
    }

    @Override
    public String logPrefix() {
        return "Last mirror files for job " + this.getJobId() + " on " + this.getHostname() + ": ";
    }
}

