/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotExecuteCommandException;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotFinishReadingStreamsException;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.Logger;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.SimpleShellCommand;
import com.mathworks.toolbox.distcomp.remote.spi.ShellCommandSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class ExecuteCommandChore
extends OneTimeChore {
    private final String fCommand;
    private Lock fLock = new ReentrantLock();
    private StreamBufferer fStdOutBufferer = null;
    private StreamBufferer fStdErrBufferer = null;
    private int fExitStatus = 0;
    private byte[] fStdOut = null;
    private byte[] fStdErr = null;
    private boolean fStdOutReliable = false;
    private boolean fStdErrReliable = false;

    ExecuteCommandChore(String string, String string2, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string2, parameterMap, fileMirrorControl);
        this.fCommand = string;
    }

    @Override
    public boolean runChore() throws CouldNotExecuteCommandException {
        return this.executeCommand();
    }

    @Override
    ShellFuture getFuture() throws InterruptedException {
        return (ShellFuture)super.getFuture();
    }

    private boolean executeCommand() throws CouldNotExecuteCommandException {
        if (!this.hasBeenCanceled()) {
            try {
                ShellCommandSender shellCommandSender = (ShellCommandSender)ProtocolProvider.getInstance().getProtocolByType("ssh");
                SimpleShellCommand simpleShellCommand = new SimpleShellCommand(this.fCommand);
                Logger.LOGGER.finest(this.logPrefix() + "About to start");
                try {
                    this.performRemoteCommand(simpleShellCommand, shellCommandSender, this.toString());
                }
                catch (DispatchException dispatchException) {
                    throw new CouldNotExecuteCommandException(this, (RemoteExecutionException)dispatchException);
                }
                this.bufferStreamsAndAwaitEnd();
                return true;
            }
            catch (NoSuchProtocolException noSuchProtocolException) {
                AssertionError assertionError = new AssertionError((Object)"Someone's removed ssh from the ProtocolProvider");
                ((Throwable)((Object)assertionError)).initCause(noSuchProtocolException);
                throw assertionError;
            }
        }
        return false;
    }

    private void bufferStreamsAndAwaitEnd() throws CouldNotExecuteCommandException {
        try {
            if (!this.hasBeenCanceled()) {
                this.bufferStreamsAwaitEndAndSetValues();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotExecuteCommandException(this, interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferStreamsAwaitEndAndSetValues() throws CouldNotExecuteCommandException, InterruptedException {
        block11: {
            CouldNotExecuteCommandException couldNotExecuteCommandException = null;
            try {
                this.bufferStdOutAndStdErrorAndAwaitEnd();
            }
            catch (CouldNotExecuteCommandException couldNotExecuteCommandException2) {
                couldNotExecuteCommandException = couldNotExecuteCommandException2;
            }
            finally {
                block12: {
                    try {
                        this.setStdErrStdOutAndExitStatus();
                    }
                    catch (FulfillmentException fulfillmentException) {
                        if (couldNotExecuteCommandException != null) break block12;
                        couldNotExecuteCommandException = new CouldNotExecuteCommandException(this, (RemoteExecutionException)fulfillmentException);
                    }
                }
                if (couldNotExecuteCommandException == null) break block11;
                throw couldNotExecuteCommandException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferStdOutAndStdErrorAndAwaitEnd() throws CouldNotExecuteCommandException, InterruptedException {
        try {
            this.startStdErrBufferer();
            this.bufferStdOutAndAwaitEnd();
            this.fStdErrBufferer.joinReadingThread();
        }
        finally {
            this.fStdErrBufferer.stopThread();
        }
    }

    private void bufferStdOutAndAwaitEnd() throws CouldNotExecuteCommandException, InterruptedException {
        try {
            this.startStdOutBufferer();
            this.awaitEndOfFuture();
            Logger.LOGGER.finest(this.logPrefix() + "Remote call finished");
            this.fStdOutBufferer.joinReadingThread();
        }
        catch (FulfillmentException fulfillmentException) {
            throw new CouldNotExecuteCommandException(this, (RemoteExecutionException)fulfillmentException);
        }
        finally {
            this.fStdOutBufferer.stopThread();
        }
    }

    private void startStdOutBufferer() throws CouldNotExecuteCommandException {
        try {
            this.fLock.lock();
            this.fStdOutBufferer = this.createAndStartStreamBufferer("stdout", this.getFuture().getInputStream());
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotExecuteCommandException(this, interruptedException);
        }
        catch (RemoteStreamException remoteStreamException) {
            throw new CouldNotExecuteCommandException(this, (RemoteExecutionException)remoteStreamException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void startStdErrBufferer() throws CouldNotExecuteCommandException {
        try {
            this.fLock.lock();
            this.fStdErrBufferer = this.createAndStartStreamBufferer("stderr", this.getFuture().getErrorStream());
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotExecuteCommandException(this, interruptedException);
        }
        catch (RemoteStreamException remoteStreamException) {
            throw new CouldNotExecuteCommandException(this, (RemoteExecutionException)remoteStreamException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    private StreamBufferer createAndStartStreamBufferer(String string, InputStream inputStream) {
        StreamBufferer streamBufferer = new StreamBufferer(string, inputStream, this);
        Thread thread = new Thread((Runnable)streamBufferer, this.logPrefix() + "." + streamBufferer.fName);
        thread.setDaemon(true);
        thread.start();
        return streamBufferer;
    }

    private void setStdErrStdOutAndExitStatus() throws FulfillmentException, InterruptedException {
        ShellFuture shellFuture = this.getFuture();
        this.setStdErr(this.fStdErrBufferer.getBytes(), this.fStdErrBufferer.areBytesReliable());
        this.setStdOut(this.fStdOutBufferer.getBytes(), this.fStdOutBufferer.areBytesReliable());
        this.setExitStatus(shellFuture.getExitStatus());
    }

    public String toString() {
        return this.fCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExitStatus(int n) {
        try {
            this.fLock.lock();
            this.fExitStatus = n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExitStatus() {
        try {
            this.fLock.lock();
            int n = this.fExitStatus;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStdOut(byte[] byArray, boolean bl) {
        try {
            this.fLock.lock();
            this.fStdOut = byArray;
            this.fStdOutReliable = bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStdOut() {
        try {
            this.fLock.lock();
            byte[] byArray = this.fStdOut;
            return byArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStdoutReliable() {
        try {
            this.fLock.lock();
            boolean bl = this.fStdOutReliable;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStdErr(byte[] byArray, boolean bl) {
        try {
            this.fLock.lock();
            this.fStdErr = byArray;
            this.fStdErrReliable = bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStdErr() {
        try {
            this.fLock.lock();
            byte[] byArray = this.fStdErr;
            return byArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStderrReliable() {
        try {
            this.fLock.lock();
            boolean bl = this.fStdErrReliable;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public String logPrefix() {
        return "Execute " + this.fCommand + " @" + this.getHostname() + " : ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        super.cancel();
        try {
            this.fLock.lock();
            try {
                if (this.fStdOutBufferer != null) {
                    this.fStdOutBufferer.stopThread();
                }
            }
            finally {
                if (this.fStdErrBufferer != null) {
                    this.fStdErrBufferer.stopThread();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.LOGGER.log(Level.FINE, "Interrupted during cancel", interruptedException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    private static final class StreamBufferer
    implements Runnable {
        private static final long JOIN_TIMEOUT = 20000L;
        private final InputStream fIn;
        private final ExecuteCommandChore fChore;
        private final String fName;
        private final Lock fLock = new ReentrantLock();
        private Thread fThread;
        private byte[] fBytes = new byte[0];
        private boolean fKeepReading = true;
        private boolean fAreBytesReliable = false;

        StreamBufferer(String string, InputStream inputStream, ExecuteCommandChore executeCommandChore) {
            this.fIn = inputStream;
            this.fChore = executeCommandChore;
            this.fName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] getBytes() {
            try {
                this.fLock.lock();
                byte[] byArray = this.fBytes;
                return byArray;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean areBytesReliable() {
            try {
                this.fLock.lock();
                boolean bl = this.fAreBytesReliable;
                return bl;
            }
            finally {
                this.fLock.unlock();
            }
        }

        boolean joinReadingThread() throws InterruptedException {
            Thread thread = this.getThread();
            Logger.LOGGER.finest(this.fChore.logPrefix() + this.fName + " waiting to join thread " + thread);
            thread.join(20000L);
            if (thread.isAlive()) {
                Logger.LOGGER.warning(this.fChore.logPrefix() + this.fName + " failed to join thread " + thread + " after " + 20L + " seconds.");
                return false;
            }
            Logger.LOGGER.finest(this.fChore.logPrefix() + this.fName + " joined thread " + thread);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Thread getThread() {
            try {
                this.fLock.lock();
                Thread thread = this.fThread;
                return thread;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setBytesReliable(boolean bl) {
            try {
                this.fLock.lock();
                this.fAreBytesReliable = bl;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() throws InterruptedException {
            Logger.LOGGER.finest(this.fChore.logPrefix() + this.fName + " stopThread() called.");
            try {
                this.fLock.lock();
                this.fKeepReading = false;
            }
            finally {
                this.fLock.unlock();
            }
            Thread thread = this.getThread();
            if (thread.isAlive()) {
                Logger.LOGGER.fine(this.fChore.logPrefix() + this.fName + " Interrupting " + thread);
                thread.interrupt();
            } else {
                Logger.LOGGER.finest(this.fChore.logPrefix() + this.fName + " " + thread + " is not alive");
            }
        }

        @Override
        public void run() {
            Logger.LOGGER.fine(this.fChore.logPrefix() + this.fName + " started on " + this.fThread);
            try {
                int n;
                this.setThread(Thread.currentThread());
                byte[] byArray = new byte[1024];
                do {
                    if ((n = this.fIn.read(byArray)) > 0) {
                        this.appendBytes(byArray, n);
                    }
                    byArray = new byte[1024];
                } while (this.keepReading() && n != -1);
                if (n == -1) {
                    Logger.LOGGER.fine(this.fChore.logPrefix() + this.fName + " finished reading stream.");
                    this.setBytesReliable(true);
                } else {
                    Logger.LOGGER.warning(this.fChore.logPrefix() + this.fName + " did not finish reading stream");
                    this.setBytesReliable(false);
                }
                Logger.LOGGER.fine(this.fChore.logPrefix() + this.fName + " finished.");
            }
            catch (InterruptedIOException interruptedIOException) {
                this.setBytesReliable(false);
                Logger.LOGGER.log(Level.WARNING, this.fChore.logPrefix() + this.fName + " interrupted while reading. " + this.fName + " end not detected.", interruptedIOException);
            }
            catch (IOException iOException) {
                this.setBytesReliable(false);
                CouldNotFinishReadingStreamsException couldNotFinishReadingStreamsException = new CouldNotFinishReadingStreamsException(this.fChore, " while reading from " + this.fChore.logPrefix() + this.fName, iOException);
                couldNotFinishReadingStreamsException.fillInStackTrace();
                this.fChore.addThrowable(couldNotFinishReadingStreamsException);
            }
            catch (RuntimeException runtimeException) {
                this.setBytesReliable(false);
                CouldNotFinishReadingStreamsException couldNotFinishReadingStreamsException = new CouldNotFinishReadingStreamsException(this.fChore, " while reading from " + this.fChore.logPrefix() + this.fName, runtimeException);
                couldNotFinishReadingStreamsException.fillInStackTrace();
                this.fChore.addThrowable(couldNotFinishReadingStreamsException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean keepReading() {
            try {
                this.fLock.lock();
                boolean bl = this.fKeepReading;
                return bl;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setThread(Thread thread) {
            try {
                this.fLock.lock();
                this.fThread = thread;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendBytes(byte[] byArray, int n) {
            try {
                this.fLock.lock();
                byte[] byArray2 = this.fBytes;
                this.fBytes = new byte[byArray2.length + n];
                System.arraycopy(byArray2, 0, this.fBytes, 0, byArray2.length);
                System.arraycopy(byArray, 0, this.fBytes, byArray2.length, n);
            }
            finally {
                this.fLock.unlock();
            }
        }
    }
}

