/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderRemote;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import java.rmi.RemoteException;

class CredentialStoreProxy
implements CredentialProviderLocal {
    private static final int SALT_LENGTH = 32;
    private final CredentialProviderRemote fCredentialProviderRemote;

    CredentialStoreProxy(CredentialProviderRemote credentialProviderRemote) throws DistcompProxy.SerializeProxyException {
        this.fCredentialProviderRemote = credentialProviderRemote;
    }

    @Override
    public NontransferableCredentials getCredentials(UserIdentity userIdentity, CryptoModule cryptoModule) throws CredentialTransferException {
        try {
            byte[] byArray = cryptoModule.createSalt(32);
            TransferableCredentials transferableCredentials = this.fCredentialProviderRemote.getCredentials(userIdentity, byArray, cryptoModule.getEncryptor());
            return transferableCredentials.unpack(byArray, cryptoModule.getDecryptor());
        }
        catch (AuthorisationFailedException authorisationFailedException) {
            throw new CredentialTransferException(userIdentity, (Throwable)authorisationFailedException);
        }
        catch (RemoteException remoteException) {
            throw new CredentialTransferException(userIdentity, (Throwable)remoteException);
        }
    }
}

