/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialVerificationException;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedPlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.SignedEncryptedPlainCredentials;
import java.security.PublicKey;
import java.util.Arrays;

public final class SignedPlainCredentials
extends PlainCredentials {
    private final byte[] fSignature;

    SignedPlainCredentials(PlainCredentials plainCredentials, byte[] byArray) throws CredentialCreationException {
        super(plainCredentials);
        this.fSignature = Arrays.copyOf(byArray, byArray.length);
    }

    @Override
    public SignedEncryptedPlainCredentials prepare(boolean bl, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException {
        EncryptedPlainCredentials encryptedPlainCredentials = super.prepare(bl, byArray, encryptor);
        return new SignedEncryptedPlainCredentials(encryptedPlainCredentials, this.fSignature);
    }

    public void checkSignature(PublicKey publicKey, SignatureModule.Verifier verifier) throws CredentialVerificationException {
        Erasable erasable = this.getPassword();
        try {
            verifier.verify(erasable, this.fSignature, publicKey);
        }
        catch (CryptoException cryptoException) {
            throw new CredentialVerificationException("Error during checkSignature", this.getUserIdentity(), cryptoException);
        }
        finally {
            erasable.erase();
        }
    }

    public static SignedPlainCredentials create(PlainCredentials plainCredentials, SignatureModule.Signer signer) throws CredentialCreationException {
        Erasable erasable = plainCredentials.getPassword();
        try {
            byte[] byArray = signer.sign(erasable);
            SignedPlainCredentials signedPlainCredentials = new SignedPlainCredentials(plainCredentials, byArray);
            return signedPlainCredentials;
        }
        catch (CryptoException cryptoException) {
            throw new CredentialCreationException("Unable to sign credentials.", plainCredentials.getUserIdentity(), cryptoException);
        }
        finally {
            erasable.erase();
        }
    }
}

