/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.PackageInfo;
import com.mathworks.toolbox.distcomp.auth.TrustModule;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleGlobalPasswordlessImpl;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleTrivialImpl;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleWithPasswordImpl;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleWithWarningImpl;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleKeyPairImpl;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleTrivialImpl;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.auth.modules.TrustModuleSSLImpl;
import com.mathworks.toolbox.distcomp.auth.modules.TrustModuleTrivialImpl;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;

public final class SecurityModuleProvider {
    private static boolean sMessageLogged = false;

    public static CryptoModule createCryptoModule(int n, boolean bl, String string) throws ModuleCreationException {
        switch (SecurityModuleProvider.checkLevel(n)) {
            case 2: 
            case 3: {
                return new CryptoModuleKeyPairImpl(string);
            }
        }
        if (bl) {
            return new CryptoModuleKeyPairImpl(string);
        }
        return new CryptoModuleTrivialImpl();
    }

    public static TrustModule createTrustModule(int n, CryptoModule cryptoModule, ExporterFactory exporterFactory) throws ModuleCreationException {
        switch (SecurityModuleProvider.checkLevel(n)) {
            case 3: {
                return new TrustModuleSSLImpl(cryptoModule, exporterFactory);
            }
        }
        return new TrustModuleTrivialImpl(cryptoModule);
    }

    public static AuthorisationModule createAuthorisationModule(AuthorisationModuleConfig authorisationModuleConfig) {
        int n = SecurityModuleProvider.checkLevel(authorisationModuleConfig.getSecurityLevel());
        authorisationModuleConfig.setSecurityLevel(n);
        switch (n) {
            case 2: 
            case 3: {
                return authorisationModuleConfig.allowGlobalPasswordlessLogon() ? new AuthorisationModuleGlobalPasswordlessImpl(authorisationModuleConfig) : new AuthorisationModuleWithPasswordImpl(authorisationModuleConfig);
            }
            case 1: {
                return new AuthorisationModuleWithWarningImpl(authorisationModuleConfig);
            }
        }
        return new AuthorisationModuleTrivialImpl();
    }

    public static boolean isRunAsUser(int n) {
        return n >= 3;
    }

    private static int checkLevel(int n) {
        String string = "Running on security level " + n;
        int n2 = n;
        if (n < 0) {
            string = "Switching security off (due to invalid security level " + n + ")";
            n2 = 0;
        } else if (n > 3) {
            string = "Maximum security level is 3 (invalid security level " + n + ")";
            n2 = 3;
        }
        if (!sMessageLogged) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, string);
            sMessageLogged = true;
        }
        return n2;
    }
}

