/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.SignedPlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import java.rmi.RemoteException;

public abstract class InvocationNewAdminUser
extends AbstractInvocationWithAuth<Object> {
    private SignatureModule.Signer fSigner;

    public InvocationNewAdminUser(UserIdentity userIdentity, SignatureModule.Signer signer) {
        super(userIdentity);
        this.fSigner = signer;
    }

    @Override
    public Object makeInvocation(CredentialStore<AuthenticationToken> credentialStore, RemoteAuthorisationModule remoteAuthorisationModule) throws AuthorisationFailedException, RemoteException, MJSException {
        CredentialProviderImpl credentialProviderImpl = this.makeCredentialProvider();
        this.setCredentialProvider(credentialProviderImpl.getProxy());
        NewPasswordReturn newPasswordReturn = null;
        while (true) {
            try {
                Object t = this.invoke();
                return t;
            }
            catch (AuthorisationFailedException authorisationFailedException) {
                newPasswordReturn = remoteAuthorisationModule.promptForNewPassword(this.getUserIdentity());
                SignedPlainCredentials signedPlainCredentials = SignedPlainCredentials.create(newPasswordReturn.getNewCredentials(), this.fSigner);
                credentialProviderImpl.getCredentialStore().putCredentials(signedPlainCredentials);
                continue;
            }
            break;
        }
        finally {
            if (newPasswordReturn != null) {
                newPasswordReturn.getNewCredentials().erase();
            }
            credentialProviderImpl.unexport();
        }
    }
}

