/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.mathworks.toolbox.distcomp.admincenter.resources.icons.AdminCenterIcon;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import java.util.ArrayList;
import javax.swing.Icon;

class ResultsComposite
implements Comparable<ResultsComposite> {
    private int fSuccessCount = 0;
    private int fInfoCount = 0;
    private int fWarningCount = 0;
    private int fSkipCount = 0;
    private int fErrorCount = 0;
    private int fErrorOrSkipCount = 0;
    private ArrayList<TestResultData> fResults = new ArrayList();

    ResultsComposite() {
    }

    public void addResult(TestResultData testResultData) {
        switch (testResultData.getReturnStatus()) {
            case ERROR: {
                ++this.fErrorCount;
                ++this.fErrorOrSkipCount;
                break;
            }
            case SKIPPED: {
                ++this.fSkipCount;
                ++this.fErrorOrSkipCount;
                break;
            }
            case INFO: {
                ++this.fInfoCount;
                break;
            }
            case SUCCESS: {
                ++this.fSuccessCount;
                break;
            }
            case WARNING: {
                ++this.fWarningCount;
            }
        }
        this.fResults.add(testResultData);
    }

    public void addResults(TestResultData[] testResultDataArray) {
        for (TestResultData testResultData : testResultDataArray) {
            this.addResult(testResultData);
        }
    }

    public TestResultData[] getResults() {
        return this.fResults.toArray(new TestResultData[0]);
    }

    public ReturnStatus getCompositeReturnStatus() {
        if (this.fErrorCount > 0) {
            return ReturnStatus.ERROR;
        }
        if (this.fSkipCount > 0) {
            return ReturnStatus.SKIPPED;
        }
        if (this.fWarningCount > 0) {
            return ReturnStatus.WARNING;
        }
        if (this.fInfoCount > 0) {
            return ReturnStatus.INFO;
        }
        return ReturnStatus.SUCCESS;
    }

    @Override
    public int compareTo(ResultsComposite resultsComposite) {
        if (this.fErrorCount > 0 || resultsComposite.fErrorCount > 0) {
            return this.fErrorOrSkipCount - resultsComposite.fErrorOrSkipCount;
        }
        if (this.fSkipCount > 0 || resultsComposite.fSkipCount > 0) {
            return this.fSkipCount - resultsComposite.fSkipCount;
        }
        if (this.fWarningCount > 0 || resultsComposite.fWarningCount > 0) {
            return this.fWarningCount - resultsComposite.fWarningCount;
        }
        if (this.fInfoCount > 0 || resultsComposite.fInfoCount > 0) {
            return this.fInfoCount - resultsComposite.fInfoCount;
        }
        return 0;
    }

    public int getCount(ReturnStatus returnStatus) {
        switch (returnStatus) {
            case ERROR: {
                return this.fErrorCount;
            }
            case INFO: {
                return this.fInfoCount;
            }
            case SKIPPED: {
                return this.fSkipCount;
            }
            case SUCCESS: {
                return this.fSuccessCount;
            }
            case WARNING: {
                return this.fWarningCount;
            }
        }
        return 0;
    }

    public Icon getStatusIcon() {
        switch (this.getCompositeReturnStatus()) {
            case ERROR: {
                return AdminCenterIcon.ERROR.getIcon();
            }
            case INFO: {
                return AdminCenterIcon.INFO.getIcon();
            }
            case SKIPPED: {
                return AdminCenterIcon.SKIPPED.getIcon();
            }
            case SUCCESS: {
                return AdminCenterIcon.SUCCESS.getIcon();
            }
            case WARNING: {
                return AdminCenterIcon.WARNING.getIcon();
            }
        }
        return null;
    }
}

