/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.NodeData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultsContainer;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.ResultsComposite;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.table.AbstractTableModel;

public class DetailTableModel
extends AbstractTableModel {
    private final LinkedHashMap<NodeData, HashMap<DetailColumn, ResultsComposite>> fTableData = new LinkedHashMap();
    private final NodeData[] fSortedKeys;

    public DetailTableModel(TestResultsContainer testResultsContainer) {
        for (TestResultData testResultData : testResultsContainer.getTestResults()) {
            NodeData nodeData = testResultData.getExecutorNode();
            NodeData nodeData2 = testResultData.getReceivingNode();
            DetailColumn detailColumn = null;
            DetailColumn detailColumn2 = null;
            switch (testResultData.getTestCategory()) {
                case CLIENT_HOSTNAMES: {
                    detailColumn2 = DetailColumn.CLIENT_HOSTNAME;
                    break;
                }
                case INTERNODE_HOSTNAMES: {
                    detailColumn2 = DetailColumn.INBOUND;
                    detailColumn = DetailColumn.OUTBOUND;
                    break;
                }
                case MDCE_CONNECT: {
                    detailColumn2 = DetailColumn.CLIENT_MDCS;
                    break;
                }
                case MDCE_HOSTNAME: {
                    detailColumn2 = DetailColumn.MDCS_HOSTNAME;
                    break;
                }
                case MPI_HOSTNAME: {
                    detailColumn2 = DetailColumn.MPI_HOSTNAME;
                    detailColumn = DetailColumn.MPI_HOSTNAME;
                    break;
                }
                case POOL2CLIENT: {
                    detailColumn = DetailColumn.NODE2CLIENT;
                    break;
                }
                case PORTS_AVAILABLE: {
                    detailColumn2 = DetailColumn.PORT_AVAILABILITY;
                    break;
                }
                case PORT_CONNECT: {
                    detailColumn2 = DetailColumn.PORT_CONNECT;
                    detailColumn = DetailColumn.PORT_CONNECT;
                }
            }
            this.addResult(testResultData, nodeData, detailColumn);
            if (nodeData.equals(nodeData2) && detailColumn == detailColumn2) continue;
            this.addResult(testResultData, nodeData2, detailColumn2);
        }
        this.fSortedKeys = this.fTableData.keySet().toArray(new NodeData[0]);
    }

    @Override
    public int getRowCount() {
        return this.fTableData.size();
    }

    @Override
    public int getColumnCount() {
        return DetailColumn.values().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        NodeData nodeData = this.getNode(n);
        DetailColumn detailColumn = DetailColumn.values()[n2];
        if (detailColumn == DetailColumn.NODE) {
            return nodeData;
        }
        return this.doGetResultsAt(nodeData, detailColumn);
    }

    public void sortBy(int n, int n2) {
        int n3;
        final DetailColumn detailColumn = DetailColumn.values()[n];
        int n4 = n3 = n2 == 0 ? 1 : -1;
        if (detailColumn == DetailColumn.NODE) {
            Arrays.sort(this.fSortedKeys, new Comparator<NodeData>(){

                @Override
                public int compare(NodeData nodeData, NodeData nodeData2) {
                    return nodeData.getHostname().compareTo(nodeData2.getHostname()) * n3;
                }
            });
        } else {
            Arrays.sort(this.fSortedKeys, new Comparator<NodeData>(){

                @Override
                public int compare(NodeData nodeData, NodeData nodeData2) {
                    ResultsComposite resultsComposite = (ResultsComposite)((HashMap)DetailTableModel.this.fTableData.get(nodeData)).get((Object)detailColumn);
                    ResultsComposite resultsComposite2 = (ResultsComposite)((HashMap)DetailTableModel.this.fTableData.get(nodeData2)).get((Object)detailColumn);
                    if (resultsComposite == null && resultsComposite2 == null) {
                        return 0;
                    }
                    if (resultsComposite == null) {
                        return -n3;
                    }
                    if (resultsComposite2 == null) {
                        return n3;
                    }
                    return resultsComposite.compareTo(resultsComposite2) * n3;
                }
            });
        }
        this.fireTableRowsUpdated(0, this.fSortedKeys.length);
    }

    public Class getColumnClass(int n) {
        DetailColumn detailColumn = DetailColumn.values()[n];
        return detailColumn == DetailColumn.NODE ? NodeData.class : ResultsComposite.class;
    }

    @Override
    public String getColumnName(int n) {
        return DetailColumn.values()[n].getName();
    }

    NodeData getNode(int n) {
        return this.fSortedKeys[n];
    }

    ResultsComposite getResultsAt(int n, int n2) {
        NodeData nodeData = this.getNode(n);
        DetailColumn detailColumn = DetailColumn.values()[n2];
        return this.doGetResultsAt(nodeData, detailColumn);
    }

    private void addResult(TestResultData testResultData, NodeData nodeData, DetailColumn detailColumn) {
        ResultsComposite resultsComposite;
        if (detailColumn == null) {
            return;
        }
        if (testResultData == null || nodeData == null) {
            throw new IllegalArgumentException("Result and node must be non-null.");
        }
        HashMap<DetailColumn, ResultsComposite> hashMap = this.fTableData.get(nodeData);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.fTableData.put(nodeData, hashMap);
        }
        if ((resultsComposite = hashMap.get((Object)detailColumn)) == null) {
            resultsComposite = new ResultsComposite();
            hashMap.put(detailColumn, resultsComposite);
        }
        resultsComposite.addResult(testResultData);
        if (detailColumn != DetailColumn.NODE) {
            this.addResult(testResultData, nodeData, DetailColumn.NODE);
        }
    }

    private ResultsComposite doGetResultsAt(NodeData nodeData, DetailColumn detailColumn) {
        HashMap<DetailColumn, ResultsComposite> hashMap = this.fTableData.get(nodeData);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get((Object)detailColumn);
    }

    static enum DetailColumn {
        NODE,
        CLIENT_HOSTNAME,
        CLIENT_MDCS,
        MDCS_HOSTNAME,
        MPI_HOSTNAME,
        OUTBOUND,
        INBOUND,
        PORT_AVAILABILITY,
        PORT_CONNECT,
        NODE2CLIENT;


        public String getName() {
            return ResourceStatics.sRes.getString("results.details." + (Object)((Object)this));
        }

        public String getShortName() {
            return ResourceStatics.sRes.getString("results.details.short." + (Object)((Object)this));
        }

        public String getTooltip() {
            return ResourceStatics.sRes.getString("results.details.tt." + (Object)((Object)this));
        }
    }
}

