/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.Node;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Result;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.TestCompletionObserver;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.TestFailureException;
import com.mathworks.toolbox.distcomp.control.CommandSender;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;

public final class TestCommandAdaptor<T extends Result>
extends MDCSCommand {
    private transient String fRemoteHostname = null;
    private transient Integer fRemotePort = null;
    private transient boolean fRunLocal = false;
    private RunnableTest<T> fRunnableTest = null;

    public TestCommandAdaptor(Node node, RunnableTest<T> runnableTest) {
        assert (node != null) : "attempt to set a null executingNode";
        assert (runnableTest != null) : "attempt to set a null runnableTest";
        this.fRemoteHostname = node.getHostname();
        this.fRemotePort = node.getRemotePort();
        this.fRunLocal = node.isLocal();
        this.fRunnableTest = runnableTest;
    }

    @Override
    public String getPreRunDescription() {
        return "MDCSCommand: AdminCenter infrastructure testing (" + this.fRunnableTest.getDescription() + ")";
    }

    public T run() {
        this.fRunnableTest.startTest();
        return this.fRunnableTest.getResult();
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 10000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 2000;
    }

    public Result call(TestCompletionObserver<T> testCompletionObserver) {
        MDCSCommandResults mDCSCommandResults = null;
        try {
            mDCSCommandResults = this.fRunLocal ? this.run() : this.sendTest(this.fRemoteHostname, this.fRemotePort);
        }
        catch (Exception exception) {
            String string = "Test execution on " + this.fRemoteHostname + ":" + this.fRemotePort + " failed.";
            mDCSCommandResults = this.failedToRun(new TestFailureException(string, exception));
        }
        testCompletionObserver.onTestComplete(mDCSCommandResults);
        return mDCSCommandResults;
    }

    private T sendTest(String string, Integer n) throws Exception {
        return (T)((Result)CommandSender.sendAndRunCommand(this, string, n));
    }

    private T failedToRun(Exception exception) {
        this.fRunnableTest.failedToRun(exception);
        return this.fRunnableTest.getResult();
    }
}

