/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.ConnectToServerSocketResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;

class ConnectToServerSocket
extends RunnableTest<ConnectToServerSocketResult> {
    private String fHostname = null;
    private Integer fPort = null;

    public ConnectToServerSocket(String string, Integer n) {
        super(TimeOutConstants.CONNECT_TO_SERVERSOCKET_TIMEOUT_MILLIS);
        this.fHostname = string;
        this.fPort = n;
    }

    @Override
    protected ConnectToServerSocketResult createResult() {
        return new ConnectToServerSocketResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        ConnectToServerSocketResult connectToServerSocketResult = this.createResult();
        Socket socket = null;
        try {
            socket = this.getSocketTryManyTimes(this.fHostname, this.fPort, TimeOutConstants.CONNECT_TO_SERVERSOCKET_TEST_MAX_TIME_MILLIS, TimeOutConstants.CONNECT_TO_SERVERSOCKET_TEST_SLEEP_TIME_MILLIS);
            SocketHandler socketHandler = new SocketHandler(socket);
            String string = "Test message from ConnectTest";
            String string2 = socketHandler.sendToServer(string);
            if (string2 == null || !string2.equals(string)) {
                connectToServerSocketResult.addInfo("sendMessage (" + string + ") was changed to " + string2);
            }
            connectToServerSocketResult.setSuccess();
        }
        catch (Exception exception) {
            connectToServerSocketResult.setFailure(exception);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    connectToServerSocketResult.addInfo("Unable to close socket.");
                }
            }
            this.setResult(connectToServerSocketResult);
        }
    }

    private Socket getSocketTryManyTimes(String string, Integer n, int n2, int n3) throws IOException {
        long l = System.currentTimeMillis() + (long)n2;
        while (System.currentTimeMillis() < l) {
            try {
                return this.getCommandSet().createSocket(string, n);
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new IOException("could not get socket");
    }

    private class SocketHandler {
        private Socket fSocket = null;
        private BufferedReader fIn = null;
        private PrintWriter fOut = null;

        public SocketHandler(Socket socket) throws IOException {
            this.fSocket = socket;
            try {
                this.fSocket.setSoTimeout(TimeOutConstants.CONNECT_TO_SERVERSOCKET_TEST_CLIENTSOCKET_TIMEOUT_MILLIS);
                this.fIn = new BufferedReader(new InputStreamReader(this.fSocket.getInputStream()));
                this.fOut = new PrintWriter(new OutputStreamWriter(this.fSocket.getOutputStream()));
            }
            catch (IOException iOException) {
                this.closeAll();
                throw iOException;
            }
        }

        public String sendToServer(String string) throws IOException {
            ConnectToServerSocket.this.log("Connecting to " + ConnectToServerSocket.this.fHostname + " on port " + ConnectToServerSocket.this.fPort);
            this.sendMessage(this.fOut, string);
            this.sendMessage(this.fOut, "/eot");
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                try {
                    String string2 = this.fIn.readLine();
                    return string2;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    ConnectToServerSocket.this.warn("failed to receive messages from server.", iOException);
                    throw iOException;
                }
            }
            return null;
        }

        private void closeAll() {
            try {
                this.fIn.close();
            }
            catch (IOException iOException) {
                ConnectToServerSocket.this.warn("unable to close input stream.", iOException);
            }
            this.fOut.close();
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {
                ConnectToServerSocket.this.warn("unable to close socket.", iOException);
            }
        }

        private void sendMessage(PrintWriter printWriter, String string) {
            printWriter.println(string);
            printWriter.flush();
            ConnectToServerSocket.this.log("sending message '" + string + "' back.");
        }
    }
}

