/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.AggregateTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ModuleAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.WorkerTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModulePane;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTable;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTableTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceStatusTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartWorkersAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StopActionEnum;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StopWorkersAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.TableModelRowsTargetSource;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.WorkerServiceRequest;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class WorkerModulePane
extends ModulePane<WorkerTableModel> {
    private static final String HELP = "AC_WORKER_MODULE";
    private static final String COMP_NAME_START = "startWorker";
    private static final String COMP_NAME_STOP = "stopWorker";
    private static final String COMP_NAME_DESTROY = "destroy";
    private static final String COMP_NAME_RESUME = "resumeWorker";
    private static final String COMP_NAME_RESTART = "restart";

    public WorkerModulePane(ClientMonitor clientMonitor) {
        super(clientMonitor.getWorkerTableModel(), ResourceStatics.sRes.getString("module.workers.name"), ResourceStatics.sRes.getString("module.workers.name"), HELP, clientMonitor);
        this.init();
    }

    @Override
    protected void initActions() {
        List<ModuleAction> list = this.getActionList(ModulePane.ActionPlacement.SHORTCUT);
        List<ModuleAction> list2 = this.getActionList(ModulePane.ActionPlacement.POPUP);
        List<ModuleAction> list3 = this.getActionList(ModulePane.ActionPlacement.MENUBAR);
        ServiceInfoTableTargetSource serviceInfoTableTargetSource = new ServiceInfoTableTargetSource(this.getMonitor(), this.getTable());
        ServiceStatusTargetSource serviceStatusTargetSource = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING, ServiceInfoTableTargetSource.CountQuality.AT_LEAST_ONE);
        AggregateTargetSource aggregateTargetSource = new AggregateTargetSource(new TableModelRowsTargetSource<MDCSServiceInfo>(this.getMonitor().getHostTableModel()), new TableModelRowsTargetSource<JobManagerServiceInfo>(this.getMonitor().getJobManagerTableModel()));
        ServiceStatusTargetSource serviceStatusTargetSource2 = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.STOPPED);
        ServiceStatusTargetSource serviceStatusTargetSource3 = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING);
        ServiceAction serviceAction = new StartWorkersAction(ResourceStatics.sRes.getString("module.workers.action.start"), aggregateTargetSource, COMP_NAME_START, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new StopWorkersAction(StopActionEnum.STOP, serviceStatusTargetSource3, COMP_NAME_STOP, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list.add(serviceAction);
        list2.add(serviceAction);
        list3.add(serviceAction);
        ActionRequestCreator actionRequestCreator = new ActionRequestCreator(){

            @Override
            public ActionRequest createActionServiceRequest(ActionEvent actionEvent, ClientMonitor clientMonitor, TargetSource targetSource, SystemErrorHandler systemErrorHandler) {
                ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
                for (ServiceInfo serviceInfo : targetSource.getTargets()) {
                    if (!(serviceInfo instanceof WorkerServiceInfo)) continue;
                    WorkerServiceInfo workerServiceInfo = (WorkerServiceInfo)serviceInfo;
                    arrayList.add(WorkerServiceRequest.createResumeRequest(workerServiceInfo.getServiceName(), workerServiceInfo.getHost(), workerServiceInfo.getJobManagerHostName()));
                }
                return new ActionRequest(clientMonitor, false, arrayList, systemErrorHandler);
            }
        };
        serviceAction = new ServiceAction(ResourceStatics.sRes.getString("module.workers.action.resume"), serviceStatusTargetSource2, COMP_NAME_RESUME, actionRequestCreator, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list.add(serviceAction);
        list2.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new StopWorkersAction(StopActionEnum.DESTROY, serviceInfoTableTargetSource, COMP_NAME_DESTROY, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list2.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new StopWorkersAction(StopActionEnum.RESTART, serviceStatusTargetSource, COMP_NAME_RESTART, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list2.add(serviceAction);
        list3.add(serviceAction);
    }

    @Override
    protected ServiceInfoTable<WorkerTableModel> createTable() {
        return new ServiceInfoTable<WorkerTableModel>((WorkerTableModel)this.getTableModel());
    }
}

