/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.toolbox.distcomp.admincenter.services.model.Hostname;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class HostnameRenderer
extends DefaultTableCellRenderer {
    private final boolean fShowBoth;

    public HostnameRenderer() {
        this(false);
    }

    public HostnameRenderer(boolean bl) {
        this.fShowBoth = bl;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof Hostname) {
            object = HostnameRenderer.getDisplayHostname((Hostname)object, this.fShowBoth);
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public static String getDisplayHostname(Hostname hostname) {
        return HostnameRenderer.getDisplayHostname(hostname, false);
    }

    public static String getDisplayHostname(Hostname hostname, boolean bl) {
        if (hostname == null) {
            return null;
        }
        return HostnameRenderer.getDisplayHostname(hostname.getUserHostname(), hostname.getMDCSHostname(), bl);
    }

    public static String getDisplayHostname(ServiceInfo serviceInfo) {
        return HostnameRenderer.getDisplayHostname(serviceInfo, false);
    }

    public static String getDisplayHostname(ServiceInfo serviceInfo, boolean bl) {
        if (serviceInfo == null) {
            return null;
        }
        String string = null;
        try {
            string = serviceInfo.getMDCSHostName();
        }
        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
            // empty catch block
        }
        return HostnameRenderer.getDisplayHostname(serviceInfo.getHostName(), string, bl);
    }

    private static String getDisplayHostname(String string, String string2, boolean bl) {
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (bl && string != null && !string.equals(string2)) {
                stringBuffer.append(" (").append(string).append(")");
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

