/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class AdminUserPanel
extends StyleGuidePanel {
    private static ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(AdminUserPanel.class);
    private static final String COMP_NAME_AUTHBLURB = "StartJobManagerDialog.AuthLabel";
    private static final String COMP_NAME_PASSWORD = "StartJobManagerDialog.PasswordField";
    private static final String COMP_NAME_CONFIRM = "StartJobManagerDialog.ConfirmField";
    private final JPasswordField fPasswordField;
    private final JPasswordField fConfirmField;
    private final MJLabel fPasswordLabel;
    private final MJLabel fConfirmLabel;
    private final MJMultilineLabel fAuthLabel;
    private MJButton fOkayButton;
    private MDCSServiceInfo fSelectedHost;

    AdminUserPanel() {
        String string = sRes.getString("services.dialog.startjm.admin.sectionTitle", new Object[0]);
        this.fPasswordLabel = new MJLabel(sRes.getString("services.dialog.startjm.admin.password", new Object[0]));
        this.fConfirmLabel = new MJLabel(sRes.getString("services.dialog.startjm.admin.confirm", new Object[0]));
        this.fPasswordField = new JPasswordField();
        this.fPasswordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AdminUserPanel.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AdminUserPanel.this.checkValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AdminUserPanel.this.checkValidity();
            }
        });
        this.fConfirmField = new JPasswordField();
        this.fConfirmField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AdminUserPanel.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AdminUserPanel.this.checkValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AdminUserPanel.this.checkValidity();
            }
        });
        this.fAuthLabel = new MJMultilineLabel(sRes.getString("services.dialog.startjm.admin.defaultBlurb", new Object[0]), true);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fAuthLabel);
        mJScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        mJScrollPane.setMinimumSize(new Dimension(300, 75));
        mJScrollPane.setPreferredSize(new Dimension(300, 75));
        mJScrollPane.setBorder(null);
        this.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), string));
        this.addLine((JComponent)mJScrollPane, 8);
        this.addLine((JComponent[][])new JComponent[][]{{this.fPasswordLabel, this.fPasswordField}, {this.fConfirmLabel, this.fConfirmField}}, 0, 1);
        this.fAuthLabel.setName(COMP_NAME_AUTHBLURB);
        this.fPasswordField.setName(COMP_NAME_PASSWORD);
        this.fConfirmField.setName(COMP_NAME_CONFIRM);
    }

    public char[] getValue() {
        return this.fPasswordField.getPassword();
    }

    public void registerOkayButton(MJButton mJButton) {
        this.fOkayButton = mJButton;
        this.checkValidity();
    }

    public void checkValidity() {
        if (this.fOkayButton == null) {
            return;
        }
        boolean bl = true;
        if (this.isAuthRequired() && this.isEnabled()) {
            char[] cArray = this.fPasswordField.getPassword();
            char[] cArray2 = this.fConfirmField.getPassword();
            bl = cArray != null && cArray.length > 0 && Arrays.equals(cArray, cArray2);
        }
        this.fOkayButton.setEnabled(bl);
    }

    public void setSelectedHost(MDCSServiceInfo mDCSServiceInfo) {
        this.fSelectedHost = mDCSServiceInfo;
        this.update();
    }

    private boolean isAuthRequired() {
        return this.fSelectedHost != null && this.fSelectedHost.getSecurityLevel() != null && this.fSelectedHost.getSecurityLevel() >= 2;
    }

    private void update() {
        String string = this.getAuthLabelString();
        this.fAuthLabel.setText(string);
        boolean bl = this.isAuthRequired();
        this.fPasswordField.setEnabled(bl && this.isEnabled());
        this.fPasswordLabel.setEnabled(bl && this.isEnabled());
        this.fConfirmField.setEnabled(bl && this.isEnabled());
        this.fConfirmLabel.setEnabled(bl && this.isEnabled());
        this.fAuthLabel.setEnabled(this.isEnabled());
    }

    private String getAuthLabelString() {
        if (this.fSelectedHost == null) {
            return sRes.getString("services.dialog.startjm.admin.defaultBlurb", new Object[0]);
        }
        String string = this.fSelectedHost.getHostName();
        Integer n = this.fSelectedHost.getSecurityLevel();
        if (n == null) {
            n = 0;
        }
        String string2 = sRes.getString("services.dialog.startjm.admin.blurb", string, n);
        String string3 = sRes.getString("services.dialog.startjm.admin.blurbLevelStr." + n, new Object[0]);
        return String.format("%s\n%s", string2, string3);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.update();
        this.checkValidity();
    }
}

