/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.guide;

import com.mathworks.toolbox.shared.controllib.guide.ColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class HMITableUtils {

    public static class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ColorRenderer fEditorComponent = new ColorRenderer();
        private ColorChooser fPopup;
        private static final long serialVersionUID = 1L;

        public ColorEditor(boolean bl) {
            this.fPopup = new ColorChooser((Frame)null, bl);
            this.fPopup.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                    ColorEditor.this.fEditorComponent.setBackground(ColorEditor.this.fPopup.getSelectedColor());
                    ColorEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.fEditorComponent.getBackground();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.fEditorComponent.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ColorEditor.this.fPopup.setSelectedColor(ColorEditor.this.fEditorComponent.getBackground());
                    Point point = ColorEditor.this.fEditorComponent.getLocationOnScreen();
                    ColorEditor.this.fPopup.setLocation(point.x, point.y + ((ColorEditor)ColorEditor.this).fEditorComponent.getSize().height + 2);
                    ColorEditor.this.fPopup.show();
                }
            });
            return this.fEditorComponent;
        }
    }

    public static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private Border unselectedBorder = null;
        private Border selectedBorder = null;
        private static final long serialVersionUID = 1L;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = object == null ? Color.BLACK : (Color)object;
            this.setBackground(color);
            if (bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            }
            return this;
        }
    }

    public static class ColorRenderer1
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Color color = (Color)object;
            this.setBackground(color);
            this.setText("");
            return this;
        }
    }

    public static class RadioEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private RadioRenderer fEditorComponent = new RadioRenderer();
        private static final long serialVersionUID = 1L;

        public RadioEditor() {
            this.fEditorComponent.setRequestFocusEnabled(true);
            this.fEditorComponent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RadioEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.fEditorComponent.isSelected();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.fEditorComponent.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
            return this.fEditorComponent;
        }
    }

    public static class RadioRenderer
    extends JRadioButton
    implements TableCellRenderer {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private static final long serialVersionUID = 1L;

        public RadioRenderer() {
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }
}

