/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.desktop;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Callback;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.shared.controllib.desktop.BasicToolClient;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ToolGroupWrapper {
    private DefaultToolGroup fToolGroup;
    private BasicToolClient fToolClient;
    private String SELECTED_TAB = "";
    private Object fClosingEventData = null;
    private boolean fClosingApprovalNeeded = false;
    private ToolClientListener fClientListener;
    private final Callback fClientCallback = new Callback();
    private ToolGroupListener fGroupListener;
    private final Callback fGroupCallback = new Callback();
    private Toolstrip fToolstripProxy;
    private AttributeChangeListener fAttributeChangeListener = null;
    private final Callback fAttributeCallback = new Callback();
    private static Desktop sDesktop = MatlabDesktopServices.getDesktop();

    public ToolGroupWrapper(String string, String string2) {
        this.fToolGroup = new DefaultToolGroup(string, string2);
        this.fToolClient = new BasicToolClient((DTGroupPropertyProvider)this.fToolGroup);
    }

    public DefaultToolGroup getWrappedComponent() {
        return this.fToolGroup;
    }

    public void setDefaultLocation() {
        DTLocation dTLocation = DTLocation.createExternal((int)100, (int)100, (int)960, (int)710);
        sDesktop.setGroupLocation(this.fToolGroup.getGroupName(), dTLocation);
    }

    public Callback getAttributeCallback() {
        return this.fAttributeCallback;
    }

    public Callback getClientCallback() {
        return this.fClientCallback;
    }

    public Callback getGroupCallback() {
        return this.fGroupCallback;
    }

    public void notifyAttributeAction(AttributeChangeEvent attributeChangeEvent) {
        this.fAttributeCallback.postCallback(new Object[]{attributeChangeEvent});
    }

    public void notifyClientAction(DTClientEvent dTClientEvent) {
        this.fClientCallback.postCallback(new Object[]{dTClientEvent});
    }

    public void notifyGroupAction(DTGroupEvent dTGroupEvent) {
        this.fGroupCallback.postCallback(new Object[]{dTGroupEvent});
    }

    public void setPanel(JPanel jPanel) {
        this.fToolClient.setPanel(jPanel);
    }

    public String getName() {
        return this.fToolGroup.getGroupName();
    }

    public String getTitle() {
        return this.fToolGroup.getGroupTitle();
    }

    public void setTitle(String string) {
        this.fToolGroup.setGroupTitle(string);
    }

    public boolean isEnabled() {
        DTFrame dTFrame = sDesktop.getFrameContainingGroup(this.fToolGroup.getGroupName());
        return dTFrame != null ? dTFrame.isEnabled() : true;
    }

    public void setEnabled(boolean bl) {
        DTFrame dTFrame = sDesktop.getFrameContainingGroup(this.fToolGroup.getGroupName());
        if (dTFrame != null && !sDesktop.isGroupDocked(this.fToolGroup.getGroupName())) {
            dTFrame.setEnabled(bl);
        }
    }

    public String getCurrentTab() {
        return this.SELECTED_TAB;
    }

    public void setCurrentTab(String string) {
        this.SELECTED_TAB = string;
        Toolstrip toolstrip = this.fToolGroup.getToolstrip();
        if (toolstrip != null) {
            toolstrip.setCurrentTab(this.SELECTED_TAB);
        }
    }

    public boolean isCollapsable() {
        Toolstrip toolstrip = this.fToolGroup.getToolstrip();
        if (toolstrip != null) {
            return (Boolean)toolstrip.getAttribute((Attribute)Toolstrip.COLLAPSABLE);
        }
        return false;
    }

    public void setCollapsable(boolean bl) {
        Toolstrip toolstrip = this.fToolGroup.getToolstrip();
        if (toolstrip != null) {
            toolstrip.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)bl);
        }
    }

    public void addActionsPanel(JComponent jComponent) {
        Toolstrip toolstrip = this.fToolGroup.getToolstrip();
        if (toolstrip != null) {
            toolstrip.addActionsPanel(jComponent);
        }
    }

    public void removeActionsPanel(JComponent jComponent) {
        Toolstrip toolstrip = this.fToolGroup.getToolstrip();
        if (toolstrip != null) {
            toolstrip.removeActionsPanel(jComponent);
        }
    }

    public int indexOf(ToolstripTab toolstripTab) {
        if (MLDesktop.getInstance().useToolstrip()) {
            return this.fToolGroup.getTabList().indexOf(toolstripTab);
        }
        return this.fToolGroup.getToolstrip().getModel().indexOf((Client)toolstripTab);
    }

    public ToolstripTab get(int n) {
        if (MLDesktop.getInstance().useToolstrip()) {
            return this.fToolGroup.getTabList().get(n);
        }
        return (ToolstripTab)this.fToolGroup.getToolstrip().getModel().get(n);
    }

    public boolean add(ToolstripTab toolstripTab) {
        boolean bl;
        if (MLDesktop.getInstance().useToolstrip()) {
            List<ToolstripTab> list = this.fToolGroup.getTabList();
            bl = list.add(toolstripTab);
            this.fToolGroup.setTabList(list);
        } else {
            bl = this.fToolGroup.getToolstrip().getModel().add((Client)toolstripTab);
        }
        return bl;
    }

    public boolean add(ToolstripTab toolstripTab, int n) {
        boolean bl = true;
        if (MLDesktop.getInstance().useToolstrip()) {
            List<ToolstripTab> list = this.fToolGroup.getTabList();
            list.add(n, toolstripTab);
            this.fToolGroup.setTabList(list);
        } else {
            bl = this.fToolGroup.getToolstrip().getModel().add(n, (Client)toolstripTab);
        }
        return bl;
    }

    public boolean remove(ToolstripTab toolstripTab) {
        boolean bl;
        if (MLDesktop.getInstance().useToolstrip()) {
            List<ToolstripTab> list = this.fToolGroup.getTabList();
            bl = list.remove(toolstripTab);
            this.fToolGroup.setTabList(list);
        } else {
            bl = this.fToolGroup.getToolstrip().getModel().remove((Client)toolstripTab);
        }
        return bl;
    }

    public boolean move(int n, int n2) {
        boolean bl = true;
        if (MLDesktop.getInstance().useToolstrip()) {
            List<ToolstripTab> list = this.fToolGroup.getTabList();
            ToolstripTab toolstripTab = list.remove(n);
            this.fToolGroup.setTabList(list);
            list.add(n2, toolstripTab);
            this.fToolGroup.setTabList(list);
        } else {
            bl = this.fToolGroup.getToolstrip().getModel().move(n, n2);
        }
        return bl;
    }

    public boolean isClosingApprovalNeeded() {
        return this.fClosingApprovalNeeded;
    }

    public void setClosingApprovalNeeded(boolean bl) {
        this.fClosingApprovalNeeded = bl;
    }

    public void deferGroupClose(Object object) {
        this.fClosingEventData = object;
        this.fToolGroup.deferGroupClose();
    }

    public void vetoGroupClose() {
        if (this.fClosingEventData != null) {
            this.fToolGroup.vetoGroupClose(this.fClosingEventData);
            this.fClosingEventData = null;
        }
    }

    public void approveGroupClose() {
        if (this.fClosingEventData != null) {
            this.fToolGroup.approveGroupClose(this.fClosingEventData);
            this.fClosingEventData = null;
        }
    }

    public void open() {
        String string = this.fToolGroup.getGroupName();
        if (!sDesktop.hasGroup(string)) {
            sDesktop.addGroup((DTGroupPropertyProvider)this.fToolGroup);
            sDesktop.addClient((Component)((Object)this.fToolClient), this.fToolClient.getClientName(), false, DTLocation.create((String)"W"), false);
            this.attachListeners();
            sDesktop.setGroupDocked(string, false);
            sDesktop.setDocumentBarPosition(string, 1);
            this.setDefaultLocation();
        }
        String string2 = this.SELECTED_TAB;
        sDesktop.showGroup(string, true);
        sDesktop.showClient(this.fToolClient.getClientName(), string);
        this.setCurrentTab(string2);
    }

    private void cleanup() {
        this.detachListeners();
        String string = this.fToolGroup.getGroupName();
        sDesktop.removeClient(this.fToolClient.getClientName(), string);
        sDesktop.removeGroup(string);
    }

    private void attachListeners() {
        this.fClientListener = new ToolClientListener();
        this.fGroupListener = new ToolGroupListener();
        sDesktop.addClientListener(this.fToolGroup.getGroupName(), (DTClientListener)this.fClientListener);
        sDesktop.addGroupListener(this.fToolGroup.getGroupName(), (DTGroupListener)this.fGroupListener);
    }

    private void detachListeners() {
        sDesktop.removeClientListener(this.fToolGroup.getGroupName(), (DTClientListener)this.fClientListener);
        sDesktop.removeGroupListener(this.fToolGroup.getGroupName(), (DTGroupListener)this.fGroupListener);
        this.fClientListener = null;
        this.fGroupListener = null;
    }

    private void addToolstripAttributeChangeListener() {
        if (this.fAttributeChangeListener != null) {
            return;
        }
        this.fAttributeChangeListener = new AttributeChangeListener(){

            public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
                if (attributeChangeEvent.getAttribute() == Toolstrip.SELECTED_TAB) {
                    ToolGroupWrapper.this.SELECTED_TAB = (String)attributeChangeEvent.getNewValue();
                    ToolGroupWrapper.this.notifyAttributeAction(attributeChangeEvent);
                }
            }
        };
        this.fToolstripProxy = this.fToolGroup.getToolstrip();
        this.fToolstripProxy.addAttributeChangeListener(this.fAttributeChangeListener);
    }

    private void removeToolstripAttributeChangeListener() {
        if (this.fToolstripProxy != null) {
            this.fToolstripProxy.removeAttributeChangeListener(this.fAttributeChangeListener);
            this.fToolstripProxy = null;
        }
        this.fAttributeChangeListener = null;
    }

    private class Wrapper
    extends MJPanel {
        private static final long serialVersionUID = 1L;
        private JComponent fControls;

        private Wrapper(final Toolstrip toolstrip) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add(toolstrip.getComponent(), "Center");
            this.putClientProperty("HandlesDesktopControls", Boolean.TRUE);
            this.addPropertyChangeListener("DesktopControls", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JComponent jComponent = (JComponent)propertyChangeEvent.getNewValue();
                    if (jComponent != Wrapper.this.fControls) {
                        if (Wrapper.this.fControls != null) {
                            toolstrip.removeActionsPanel(Wrapper.this.fControls);
                            Wrapper.this.fControls = null;
                        }
                        if (jComponent != null) {
                            Wrapper.this.fControls = jComponent;
                            Wrapper.this.setOpaqueness(Wrapper.this.fControls, false);
                            toolstrip.addActionsPanel(Wrapper.this.fControls);
                        }
                        Wrapper.this.revalidate();
                        Wrapper.this.repaint();
                    }
                }
            });
        }

        private void setOpaqueness(JComponent jComponent, boolean bl) {
            jComponent.setOpaque(bl);
            if (jComponent.getComponentCount() > 0) {
                for (Component component : jComponent.getComponents()) {
                    if (!(component instanceof JComponent)) continue;
                    this.setOpaqueness((JComponent)component, bl);
                }
            }
        }
    }

    class ToolGroupListener
    extends DTGroupAdapter {
        ToolGroupListener() {
        }

        public void groupActivated(DTGroupEvent dTGroupEvent) {
            ToolGroupWrapper.this.notifyGroupAction(dTGroupEvent);
        }

        public void groupDeactivated(DTGroupEvent dTGroupEvent) {
            ToolGroupWrapper.this.notifyGroupAction(dTGroupEvent);
        }

        public void groupOpened(DTGroupEvent dTGroupEvent) {
            ToolGroupWrapper.this.addToolstripAttributeChangeListener();
            ToolGroupWrapper.this.notifyGroupAction(dTGroupEvent);
        }

        public void groupClosing(DTGroupEvent dTGroupEvent) {
            if (ToolGroupWrapper.this.isClosingApprovalNeeded()) {
                ToolGroupWrapper.this.deferGroupClose(dTGroupEvent.getData());
            }
            ToolGroupWrapper.this.notifyGroupAction(dTGroupEvent);
        }

        public void groupClosed(DTGroupEvent dTGroupEvent) {
            ToolGroupWrapper.this.cleanup();
            ToolGroupWrapper.this.removeToolstripAttributeChangeListener();
            ToolGroupWrapper.this.notifyGroupAction(dTGroupEvent);
        }
    }

    class ToolClientListener
    extends DTClientAdapter {
        ToolClientListener() {
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            ToolGroupWrapper.this.notifyClientAction(dTClientEvent);
        }

        public void clientDeactivated(DTClientEvent dTClientEvent) {
            ToolGroupWrapper.this.notifyClientAction(dTClientEvent);
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component instanceof DTClientBase) {
                ((DTClientBase)component).putClientProperty((Object)DTProperty.PERMIT_USER_UNDOCK, (Object)false);
            }
            ToolGroupWrapper.this.notifyClientAction(dTClientEvent);
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            ToolGroupWrapper.this.notifyClientAction(dTClientEvent);
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            ToolGroupWrapper.this.notifyClientAction(dTClientEvent);
        }
    }

    private class DefaultToolGroup
    extends DTGroupBase {
        private Toolstrip fToolstrip = null;

        public DefaultToolGroup(String string, String string2) {
            this.setGroupName(string);
            this.setTitle(string2);
            this.setDontMergeMenu(true);
            this.setShowSingleEntryDocumentBar(true);
            this.setDockable(false);
            this.setIsSessionGuest(true);
            this.setHeavyweight(true);
            this.setCloseUponeEmpty(false);
            this.setPermitUserFloat(true);
            if (!MLDesktop.getInstance().useToolstrip()) {
                this.fToolstrip = new DefaultToolstrip();
                this.setToolBarAlternative((JComponent)((Object)new Wrapper(this.fToolstrip)));
            }
        }

        public void addQuickAccessBarFilter() {
            Predicate<TSToolPath> predicate = new Predicate<TSToolPath>(){

                public boolean accept(TSToolPath tSToolPath) {
                    List<String> list = Arrays.asList("save", "cut", "copy", "paste", "undo", "redo");
                    return !list.contains(tSToolPath.getToolName());
                }
            };
            this.setQuickAccessToolBarFilter((Predicate)predicate);
        }

        public Toolstrip getToolstrip() {
            if (MLDesktop.getInstance().useToolstrip()) {
                DTFrame dTFrame = sDesktop.getFrameContainingGroup(this.getGroupName());
                if (dTFrame != null) {
                    return dTFrame.getToolstrip();
                }
                return null;
            }
            return this.fToolstrip;
        }

        public List<ToolstripTab> getTabList() {
            ToolstripTab[] toolstripTabArray;
            ArrayList<ToolstripTab> arrayList = new ArrayList<ToolstripTab>();
            if (MLDesktop.getInstance().useToolstrip() && (toolstripTabArray = (ToolstripTab[])this.getGroupProperty(DTProperty.TOOLSTRIP_TABS)) != null) {
                arrayList.addAll(Arrays.asList(toolstripTabArray));
            }
            return arrayList;
        }

        public void setTabList(List<ToolstripTab> list) {
            if (MLDesktop.getInstance().useToolstrip()) {
                ToolstripTab[] toolstripTabArray = list.toArray(new ToolstripTab[list.size()]);
                this.setToolstripTabs(toolstripTabArray);
            }
        }

        public String getGroupName() {
            return (String)this.getGroupProperty(DTProperty.NAME);
        }

        public String getGroupTitle() {
            return (String)this.getGroupProperty(DTProperty.TITLE);
        }

        public void setGroupTitle(String string) {
            this.setTitle(string);
        }

        public void deferGroupClose() {
            this.deferClose();
        }

        public void vetoGroupClose(Object object) {
            this.vetoClose(object);
        }

        public void approveGroupClose(Object object) {
            this.approveClose(object);
        }
    }
}

