/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser;

import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.shared.controllib.databrowser.IDataBrowserActionProvider;
import com.mathworks.widgets.recordlist.DefaultNoSelectionPopupMenu;
import com.mathworks.widgets.recordlist.IActionProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class NoSelectionPopupMenu
extends DefaultNoSelectionPopupMenu {
    private static final long serialVersionUID = -8180538048053991920L;
    private MJAbstractAction fPasteAction;
    private JMenuItem fPasteActionMenuItem;
    private SharedActionListener fSharedActionListener;
    private Vector<JMenuItem> fMenuItems;
    private Callback fMenuItemSelectionEventSource = new Callback();

    public NoSelectionPopupMenu(IDataBrowserActionProvider iDataBrowserActionProvider) {
        super((IActionProvider)iDataBrowserActionProvider);
        this.fPasteAction = iDataBrowserActionProvider.getAction(1000);
        if (this.fPasteAction != null) {
            this.fPasteActionMenuItem = this.add((Action)this.fPasteAction);
        }
        this.fSharedActionListener = new SharedActionListener();
        this.fMenuItems = new Vector();
    }

    public void addMenuItem(String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setName(string2);
        jMenuItem.setActionCommand(jMenuItem.getName());
        jMenuItem.setText(string);
        jMenuItem.addActionListener(this.fSharedActionListener);
        if (n == -1) {
            this.add(jMenuItem);
        } else {
            this.insert(jMenuItem, n);
        }
        this.fMenuItems.add(jMenuItem);
    }

    public void removeMenuItem(String string) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JMenuItem)) continue;
            try {
                if (!component.getName().equals(string)) continue;
                ((JMenuItem)component).removeActionListener(this.fSharedActionListener);
                this.remove(component);
                if (this.fMenuItems.indexOf(component) == -1) break;
                this.fMenuItems.remove(component);
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void addSeparator(int n) {
        this.insert(new JPopupMenu.Separator(), n);
    }

    public void addFullSeparator() {
        this.add(new JSeparator());
    }

    public void addFullSeparator(int n) {
        this.insert(new JSeparator(), n);
    }

    public Callback getMenuItemSelectionEventSource() {
        return this.fMenuItemSelectionEventSource;
    }

    private void notifyMATLABAboutMenuItemSelection(String string) {
        this.fMenuItemSelectionEventSource.postCallback(new Object[]{string});
    }

    public void reset() {
        for (JMenuItem jMenuItem : this.fMenuItems) {
            jMenuItem.removeActionListener(this.fSharedActionListener);
            this.remove(jMenuItem);
        }
        this.fMenuItems.removeAllElements();
    }

    public void cleanup() {
        this.fPasteAction = null;
        this.remove(this.fPasteActionMenuItem);
        this.fPasteActionMenuItem = null;
        this.removeAll();
        this.fSharedActionListener = null;
        this.fMenuItems = null;
    }

    private class SharedActionListener
    implements ActionListener {
        private SharedActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NoSelectionPopupMenu.this.notifyMATLABAboutMenuItemSelection(actionEvent.getActionCommand());
        }
    }
}

