/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlservices;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import java.util.Hashtable;

public class MLLicenseChecker {
    private static Hashtable cache = new Hashtable();
    static DataDrop sDataDrop = new DataDrop();
    private static CheckLicense sCheckLicense = new CheckLicense();

    public static boolean[] haveLicenses(String[] stringArray) {
        boolean[] blArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                blArray = (boolean[])Matlab.mtSendLicenseCheck((Object[])stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            sCheckLicense.setProductIDs(stringArray);
            Matlab.whenMatlabReady((Runnable)sCheckLicense);
            blArray = MLLicenseChecker.sDataDrop.getLicenseStatus();
        }
        return blArray;
    }

    public static synchronized boolean hasLicense(String string) {
        Boolean bl = (Boolean)cache.get(string);
        if (bl == null) {
            String[] stringArray = new String[]{string};
            boolean[] blArray = MLLicenseChecker.haveLicenses(stringArray);
            bl = new Boolean(blArray[0]);
            cache.put(string, bl);
        }
        return bl;
    }

    private static class CheckLicense
    implements Runnable {
        String[] fProductIDs;

        private CheckLicense() {
        }

        @Override
        public void run() {
            try {
                boolean[] blArray = (boolean[])Matlab.mtSendLicenseCheck((Object[])this.fProductIDs);
                sDataDrop.putLicenseStatus(blArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }

        public void setProductIDs(String[] stringArray) {
            this.fProductIDs = stringArray;
        }
    }

    private static class DataDrop {
        private boolean[] fHaveLicenses;
        private boolean fIsAvailable = false;

        private DataDrop() {
        }

        private synchronized boolean[] getLicenseStatus() {
            while (!this.fIsAvailable) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
            }
            this.fIsAvailable = false;
            this.notifyAll();
            return this.fHaveLicenses;
        }

        private synchronized void putLicenseStatus(boolean[] blArray) {
            while (this.fIsAvailable) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
            }
            this.fHaveLicenses = blArray;
            this.fIsAvailable = true;
            this.notifyAll();
        }
    }
}

