/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.product.util;

import com.mathworks.product.util.ProductIdentifier;
import java.util.HashMap;
import java.util.Map;

class ProductIdentifierMap {
    private final Map<String, ProductIdentifier> map = new HashMap<String, ProductIdentifier>();
    private final Map<Integer, ProductIdentifier> idmap = new HashMap<Integer, ProductIdentifier>();

    private ProductIdentifierMap() {
        for (ProductIdentifier productIdentifier : (ProductIdentifier[])ProductIdentifier.class.getEnumConstants()) {
            this.map.put(ProductIdentifierMap.canonicalizeKey(productIdentifier.getFlexName()), productIdentifier);
            this.map.put(ProductIdentifierMap.canonicalizeKey(productIdentifier.getName()), productIdentifier);
            this.map.put(ProductIdentifierMap.canonicalizeKey(productIdentifier.getBaseCode()), productIdentifier);
            this.idmap.put(productIdentifier.getBitNum(), productIdentifier);
        }
    }

    ProductIdentifier get(String string) {
        return this.map.get(ProductIdentifierMap.canonicalizeKey(string));
    }

    ProductIdentifier get(int n) {
        return this.idmap.get(n);
    }

    private static String canonicalizeKey(String string) {
        return string == null ? "" : string.toUpperCase();
    }

    static ProductIdentifierMap createProductIdentifierMap() {
        return new ProductIdentifierMap();
    }
}

