/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.lease.AbstractLeaseMap;
import java.rmi.RemoteException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMapException;
import net.jini.id.Uuid;

public class LandlordLeaseMap
extends AbstractLeaseMap {
    private final Landlord landlord;
    private final Uuid landlordUuid;

    LandlordLeaseMap(Landlord landlord, Uuid uuid, Lease lease, long l) {
        super(lease, l);
        if (landlord == null) {
            throw new NullPointerException("Landlord must be non-null");
        }
        if (uuid == null) {
            throw new NullPointerException("landlordUuid must be non-null");
        }
        this.landlord = landlord;
        this.landlordUuid = uuid;
    }

    public boolean canContainKey(Object object) {
        if (object instanceof LandlordLease) {
            return this.landlordUuid.equals((Object)((LandlordLease)object).landlordUuid());
        }
        return false;
    }

    public void cancelAll() throws LeaseMapException, RemoteException {
        Uuid[] uuidArray = new Uuid[this.size()];
        LandlordLease[] landlordLeaseArray = new LandlordLease[uuidArray.length];
        Iterator iterator = this.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            LandlordLease landlordLease;
            landlordLeaseArray[n] = landlordLease = (LandlordLease)iterator.next();
            uuidArray[n] = landlordLease.cookie();
            ++n;
        }
        Map map = this.landlord.cancelAll(uuidArray);
        if (map == null) {
            return;
        }
        int n2 = map.size();
        for (int i = 0; i < uuidArray.length; ++i) {
            Object v = map.remove(uuidArray[i]);
            if (v == null) continue;
            map.put(landlordLeaseArray[i], v);
            this.remove(landlordLeaseArray[i]);
        }
        if (n2 != map.size()) {
            throw new ConcurrentModificationException();
        }
        throw new LeaseMapException("Failure canceling one or more leases", map);
    }

    public void renewAll() throws LeaseMapException, RemoteException {
        Uuid[] uuidArray = new Uuid[this.size()];
        long[] lArray = new long[uuidArray.length];
        LandlordLease[] landlordLeaseArray = new LandlordLease[uuidArray.length];
        Iterator iterator = this.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            LandlordLease landlordLease;
            landlordLeaseArray[n] = landlordLease = (LandlordLease)iterator.next();
            uuidArray[n] = landlordLease.cookie();
            lArray[n] = (Long)this.get(landlordLease);
            ++n;
        }
        long l = System.currentTimeMillis();
        Landlord.RenewResults renewResults = this.landlord.renewAll(uuidArray, lArray);
        HashMap<LandlordLease, Exception> hashMap = null;
        int n2 = 0;
        for (int i = 0; i < uuidArray.length; ++i) {
            Object object;
            if (renewResults.granted[i] != -1L) {
                long l2 = l + renewResults.granted[i];
                if (l2 < 0L) {
                    l2 = Long.MAX_VALUE;
                }
                landlordLeaseArray[i].setExpiration(l2);
                continue;
            }
            if (hashMap == null) {
                hashMap = new HashMap<LandlordLease, Exception>(renewResults.denied.length + renewResults.denied.length / 2);
            }
            if ((object = this.remove(landlordLeaseArray[i])) == null) {
                throw new ConcurrentModificationException();
            }
            hashMap.put(landlordLeaseArray[i], renewResults.denied[n2++]);
        }
        if (hashMap != null) {
            throw new LeaseMapException("renewing", hashMap);
        }
    }

    Landlord landlord() {
        return this.landlord;
    }
}

