/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class WeakSoftTable {
    private final Map hash = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    private void processQueue() {
        Reference reference;
        while ((reference = this.queue.poll()) != null) {
            if (!(reference instanceof RemovableReference)) continue;
            ((RemovableReference)((Object)reference)).cleared(this.hash);
        }
    }

    public SoftValue get(WeakKey weakKey, int n) {
        List list = (List)this.hash.get(weakKey);
        if (list != null && n < list.size()) {
            return (SoftValue)list.get(n);
        }
        return null;
    }

    public void add(WeakKey weakKey, SoftValue softValue) {
        this.processQueue();
        LinkedList<RemovableReference> linkedList = (LinkedList<RemovableReference>)this.hash.get(weakKey);
        if (linkedList == null) {
            linkedList = new LinkedList<RemovableReference>();
            this.hash.put(weakKey.copy(this.queue), linkedList);
        }
        linkedList.add(softValue.copy(this.queue));
    }

    public SoftValue remove(WeakKey weakKey, int n) {
        this.processQueue();
        List list = (List)this.hash.get(weakKey);
        if (list != null && n < list.size()) {
            return (SoftValue)list.remove(n);
        }
        return null;
    }

    public String toString() {
        return this.hash.toString();
    }

    public static class SoftValue
    extends SoftReference
    implements RemovableReference {
        protected final WeakKey key;

        public SoftValue(WeakKey weakKey, Object object) {
            super(object);
            this.key = weakKey;
        }

        protected SoftValue(SoftValue softValue, ReferenceQueue referenceQueue) {
            super(softValue.get(), referenceQueue);
            this.key = softValue.key;
        }

        public RemovableReference copy(ReferenceQueue referenceQueue) {
            return new SoftValue(this, referenceQueue);
        }

        public void cleared(Map map) {
            List list = (List)map.get(this.key);
            if (list != null && list.remove(this) && list.isEmpty()) {
                map.remove(this.key);
            }
        }
    }

    public static class WeakKey
    extends WeakReference
    implements RemovableReference {
        private final boolean nullKey;
        private final int hashCode;

        public WeakKey(Object object) {
            super(object);
            this.nullKey = object == null;
            this.hashCode = this.getClass().hashCode() ^ System.identityHashCode(object);
        }

        protected WeakKey(WeakKey weakKey, ReferenceQueue referenceQueue) {
            super(weakKey.get(), referenceQueue);
            this.nullKey = weakKey.nullKey;
            this.hashCode = weakKey.hashCode;
        }

        public RemovableReference copy(ReferenceQueue referenceQueue) {
            return new WeakKey(this, referenceQueue);
        }

        public void cleared(Map map) {
            map.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            WeakKey weakKey = (WeakKey)object;
            if (weakKey.nullKey != this.nullKey) {
                return false;
            }
            if (this.nullKey) {
                return true;
            }
            Object t = weakKey.get();
            return t != null && t == this.get();
        }
    }

    public static interface RemovableReference {
        public RemovableReference copy(ReferenceQueue var1);

        public void cleared(Map var1);
    }
}

