/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.EntryTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;

class ServiceBrowser
extends JFrame {
    private Browser browser;
    private AttributePanel attrPanel;
    private static final int MINIMUM_WINDOW_WIDTH = 320;

    public ServiceBrowser(ServiceItem serviceItem, ServiceRegistrar serviceRegistrar, Browser browser) {
        super("ServiceItem Browser");
        this.browser = browser;
        this.attrPanel = new AttributePanel(serviceItem, serviceRegistrar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BrowserMenuBar(), "North");
        this.getContentPane().add((Component)this.attrPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle rectangle = browser.getBounds();
        Dimension dimension = this.getPreferredSize();
        int n = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
        this.setLocation(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
    }

    class AttributePanel
    extends EntryTreePanel {
        private ServiceItem item;
        private ServiceRegistrar registrar;

        public AttributePanel(ServiceItem serviceItem, ServiceRegistrar serviceRegistrar) {
            super(false);
            this.item = serviceItem;
            this.registrar = serviceRegistrar;
            this.refreshPanel();
        }

        protected Entry[] getEntryArray() {
            try {
                ServiceMatches serviceMatches = this.registrar.lookup(new ServiceTemplate(this.item.serviceID, new Class[]{this.item.service.getClass()}, new Entry[0]), 10);
                if (serviceMatches.totalMatches == 1) {
                    return serviceMatches.items[0].attributeSets;
                }
                Browser.logger.log(Level.INFO, "unexpected lookup matches: {0}", new Integer(serviceMatches.totalMatches));
            }
            catch (Throwable throwable) {
                Browser.logger.log(Level.INFO, "lookup failed", throwable);
            }
            return null;
        }
    }

    class BrowserMenuBar
    extends JMenuBar {
        public BrowserMenuBar() {
            JMenu jMenu = this.add(new JMenu("File"));
            JMenuItem jMenuItem = jMenu.add(new JMenuItem("Refresh"));
            jMenuItem.addActionListener(ServiceBrowser.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceBrowser.this.attrPanel.refreshPanel();
                }
            }));
            jMenuItem = jMenu.add(new JMenuItem("Close"));
            jMenuItem.addActionListener(ServiceBrowser.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceBrowser.this.setVisible(false);
                }
            }));
        }
    }
}

