/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search.index;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.search.index.NekoHtmlDomAdapter;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.index.DocCenterIndexDocumentBuilder;
import com.mathworks.helpsearch.index.DocumentBooster;
import com.mathworks.helpsearch.index.DocumentationBooster;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.ProductIndexer;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.SimpleDocProduct;
import com.mathworks.helpsearch.product.SimpleDocumentationSet;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchLanguage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DocCenterProductIndexer {
    private final File fDocRoot;
    private final DocProduct fProduct;

    public static void main(String[] stringArray) {
        boolean bl;
        Map<String, String> map = DocCenterProductIndexer.parseInputs(stringArray);
        String string = map.get("docroot");
        String string2 = map.get("helploc");
        String string3 = map.get("shortname");
        if (string2 == null && string3 != null) {
            string2 = string3;
        }
        File file = new File(string);
        string2 = DocCenterProductIndexer.validateHelpLocation(file, string2);
        if (string3 == null) {
            string3 = new File(file, string2).getName();
        }
        DocCenterProductIndexer.validateRequiredFields(string2, string);
        String string4 = map.get("language");
        DocLanguage docLanguage = DocCenterProductIndexer.resolveDocLanguage(string4);
        DocProduct docProduct = DocCenterProductIndexer.buildProduct(string3, string2, docLanguage);
        DocCenterProductIndexer docCenterProductIndexer = new DocCenterProductIndexer(file, docProduct);
        try {
            bl = docCenterProductIndexer.index();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        System.exit(bl ? 0 : 1);
    }

    public static DocLanguage resolveDocLanguage(String string) {
        if (string == null || string.trim().length() == 0) {
            return DocLanguage.getDefault();
        }
        Locale locale = DocCenterProductIndexer.toLocale(string);
        if (locale == null) {
            return DocLanguage.getDefault();
        }
        return HelpBrowserUtils.getDocLanguageForLocale(locale);
    }

    private static Locale toLocale(String string) {
        String[] stringArray = string.split("_");
        try {
            String string2 = stringArray[0].toLowerCase(Locale.ENGLISH);
            if (stringArray.length > 1) {
                String string3 = stringArray[1].toUpperCase(Locale.ENGLISH);
                return new Locale(string2, string3);
            }
            return new Locale(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DocProduct buildProduct(String string, String string2, DocLanguage docLanguage) {
        SimpleDocumentationSet simpleDocumentationSet = new SimpleDocumentationSet(ContentFormat.DOC_CENTER_DOC, docLanguage);
        return new SimpleDocProduct((DocumentationSet)simpleDocumentationSet, string, string, string2);
    }

    private static Map<String, String> parseInputs(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray) {
            String[] stringArray2 = string.split("=");
            if (stringArray2.length != 2) continue;
            String string2 = stringArray2[0];
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
            }
            hashMap.put(string2.toLowerCase(Locale.ENGLISH), stringArray2[1]);
        }
        return hashMap;
    }

    private static void validateRequiredFields(String string, String string2) {
        if (string == null || string2 == null) {
            System.out.println("Please specify the doc root and help location.");
            System.out.println("Usage:");
            System.out.println("\tjava com.mathworks.help.helpui.search.index.DocCenterProductIndexer [shortname=<shortname>] docroot=<docroot> [language=<language>] [helploc=<helploc>]");
            System.out.println("\tYou must include either the shortname or the helploc argument; specify both for a product whose help directory is not named the same as the product shortname (e.g. matlab/techdoc)");
            System.out.println("\tAcceptable language arguments include ENGLISH, JAPANESE, EN, JA, en, ja, en_US, ja_JP, etc.");
            System.exit(1);
        }
    }

    private static String validateHelpLocation(File file, String string) {
        if (!file.exists() || !file.isDirectory()) {
            System.out.println(file.getAbsolutePath() + " appears to be an invalid doc root");
            System.exit(1);
            return null;
        }
        File file2 = new File(string);
        if (!file2.exists() || !file2.isDirectory()) {
            file2 = new File(file, string);
        }
        if (!file2.exists() || !file2.isDirectory()) {
            System.out.println(string + " appears to be an invalid help location");
            System.exit(1);
            return null;
        }
        return DocCenterProductIndexer.getRelativeHelpLoc(file, file2);
    }

    private static String getRelativeHelpLoc(File file, File file2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '/');
            }
            stringBuilder.insert(0, file3.getName());
        }
        return stringBuilder.toString();
    }

    private DocCenterProductIndexer(File file, DocProduct docProduct) {
        this.fDocRoot = file;
        this.fProduct = docProduct;
    }

    private boolean index() throws IOException {
        File file = new File(this.fDocRoot, this.fProduct.getHelpLocation());
        ProductConfig productConfig = new ProductConfig(file, this.fProduct.getDocSet().getLanguage());
        Indexer indexer = this.getIndexer(productConfig);
        DocCenterIndexDocumentBuilder docCenterIndexDocumentBuilder = new DocCenterIndexDocumentBuilder(null, (DocumentBooster)new DocumentationBooster());
        ProductIndexer productIndexer = new ProductIndexer((IndexerConfig)productConfig, this.fProduct, (HtmlToDomAdapter)new NekoHtmlDomAdapter(), (IndexDocumentBuilder)docCenterIndexDocumentBuilder, indexer);
        productIndexer.disableReports();
        return productIndexer.index();
    }

    private Indexer getIndexer(IndexerConfig indexerConfig) throws IOException {
        SearchLanguage searchLanguage = this.fProduct.getDocSet().getLanguage().getSearchLanguage();
        return IndexUtils.createDocCenterIndexer((SearchLanguage)searchLanguage, (IndexerConfig)indexerConfig, (boolean)true);
    }

    private static class ProductConfig
    implements IndexerConfig {
        private final File fHelpLocation;
        private final DocLanguage fLanguage;

        private ProductConfig(File file, DocLanguage docLanguage) {
            this.fHelpLocation = file;
            this.fLanguage = docLanguage;
        }

        public File getIndexDirectory() {
            return new File(this.fHelpLocation, this.getIndexDirectoryName());
        }

        private String getIndexDirectoryName() {
            String string = "helpsearch";
            if (this.fLanguage != null && this.fLanguage != DocLanguage.ENGLISH) {
                Locale locale = this.fLanguage.getLocale();
                string = string + "_" + locale.getLanguage() + "_" + locale.getCountry();
            }
            return string;
        }

        public File getHelpLocation(DocProduct docProduct) {
            return this.fHelpLocation;
        }

        public LocalizedFileLocator getFileLocator() {
            if (this.fLanguage == null || this.fLanguage == DocLanguage.ENGLISH) {
                return null;
            }
            return new LocaleFileLocator(this.fLanguage.getLocale());
        }

        public boolean getUseLocks() {
            return false;
        }
    }
}

