/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.util.FreehepCreator;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputGenerator;
import com.mathworks.hg.util.OutputGeneratorCreatorInfo;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperInstantiationException;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.util.GraphicsDeviceUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class HGVectorOutputHelper
extends OutputHelper {
    private Exception fException;
    public String fDebugStatus;
    protected MPrintJob fPrintJob;
    private OutputGenerator fOutputGenerator;
    private Graphics fGraphics;
    private OutputGeneratorCreatorInfo fCreatorInfo;
    private boolean fSupportsCDataFromBufferedImage;
    private boolean fSupportsMultiplePages;
    private BufferedImage fBufImg;
    private static final Map<String, OutputGeneratorCreatorInfo> sDriverToCreatorMap;
    private static ResourceBundle sVectorHelperInfo;
    private static final FreehepCreator freehepCreator;
    private static final OutputGeneratorCreatorInfo sEMFCreatorInfo;
    private static final OutputGeneratorCreatorInfo sEPSCreatorInfo;
    private static final OutputGeneratorCreatorInfo sPDFCreatorInfo;
    private static final OutputGeneratorCreatorInfo sPSCreatorInfo;
    private static final OutputGeneratorCreatorInfo sSVGCreatorInfo;

    public HGVectorOutputHelper(MPrintJob mPrintJob) throws OutputHelperInstantiationException {
        super(mPrintJob);
        this.fPrintJob = mPrintJob;
        this.fCreatorInfo = HGVectorOutputHelper.lookupCreatorInfoForDriver(this.fPrintJob.getDriver());
        if (this.fCreatorInfo == null) {
            throw new OutputHelperInstantiationException(sVectorHelperInfo.getString("vector.unknownDriver") + " " + this.fPrintJob.getDriver());
        }
    }

    @Override
    public void open() throws OutputHelperProcessingException {
        this.fOutputGenerator = this.fCreatorInfo.createGenerator();
        double d = (double)this.fPrintJob.getPaperPosition_X() * HGVectorOutputHelper.getJAVA2D_DPI();
        double d2 = (double)this.fPrintJob.getPaperPosition_Y() * HGVectorOutputHelper.getJAVA2D_DPI();
        double d3 = (double)this.fPrintJob.getPaperPosition_Width() * HGVectorOutputHelper.getJAVA2D_DPI();
        double d4 = (double)this.fPrintJob.getPaperPosition_Height() * HGVectorOutputHelper.getJAVA2D_DPI();
        this.fGraphics = this.fOutputGenerator.open(this.fPrintJob.getDriver(), new Rectangle((int)d, (int)d2, (int)d3, (int)d4), this.fPrintJob.getFilename());
    }

    @Override
    public void beginPage() throws OutputHelperProcessingException {
        if (this.supportsMultiplePages()) {
            this.fOutputGenerator.doPage(true);
        }
    }

    @Override
    public void generateOutput(final FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.validateContainerState(figurePanelContainer.getTargetContainer());
        Graphics2D graphics2D = (Graphics2D)this.fGraphics;
        double d = HGVectorOutputHelper.getJAVA2D_DPI() / (double)GraphicsDeviceUtilities.getDefaultScreenResolution();
        graphics2D.scale(d, d);
        final Graphics2D graphics2D2 = graphics2D;
        this.fException = null;
        Throwable throwable = null;
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    assert (figurePanelContainer.getTargetContainer().isDisplayable()) : "Expected the container to be displayable before generating output.";
                    HGVectorOutputHelper.this.fException = figurePanelContainer.printFigurePanel(graphics2D2, HGVectorOutputHelper.this.fPrintJob.isShowUI(), HGVectorOutputHelper.this.fPrintJob.isDebugMode());
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (this.fException != null) {
            throw new OutputHelperProcessingException(this.fException);
        }
        if (throwable != null) {
            throw new OutputHelperProcessingException(throwable);
        }
    }

    @Override
    public void endPage() throws OutputHelperProcessingException {
        if (this.supportsMultiplePages()) {
            this.fOutputGenerator.doPage(false);
        }
    }

    @Override
    public void close() throws OutputHelperProcessingException {
        this.fOutputGenerator.close();
        this.fOutputGenerator = null;
    }

    @Override
    public boolean supportsGettingCDataFromBufferedImage() {
        return this.fCreatorInfo.isCDataFromBufferedImageSupported();
    }

    @Override
    public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
        return null;
    }

    @Override
    public boolean supportsMultiplePages() {
        return this.fCreatorInfo.isMultiplePagesSupported();
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return this.fCreatorInfo.isClipboardSupported();
    }

    @Override
    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        return null;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
    }

    private static OutputGeneratorCreatorInfo lookupCreatorInfoForDriver(String string) {
        return sDriverToCreatorMap.get(string);
    }

    static {
        sVectorHelperInfo = ResourceBundle.getBundle("com.mathworks.hg.util.resources.RES_vectorhelper");
        freehepCreator = new FreehepCreator();
        sEMFCreatorInfo = new OutputGeneratorCreatorInfo(".emf", freehepCreator, true, false, false);
        sEPSCreatorInfo = new OutputGeneratorCreatorInfo(".eps", freehepCreator, false, false, false);
        sPDFCreatorInfo = new OutputGeneratorCreatorInfo(".pdf", freehepCreator, true, true, false);
        sPSCreatorInfo = new OutputGeneratorCreatorInfo(".ps", freehepCreator, false, true, false);
        sSVGCreatorInfo = new OutputGeneratorCreatorInfo(".svg", freehepCreator, true, false, false);
        sDriverToCreatorMap = new HashMap<String, OutputGeneratorCreatorInfo>();
        sDriverToCreatorMap.put("meta", sEMFCreatorInfo);
        sDriverToCreatorMap.put("eps", sEPSCreatorInfo);
        sDriverToCreatorMap.put("eps2", sEPSCreatorInfo);
        sDriverToCreatorMap.put("epsc", sEPSCreatorInfo);
        sDriverToCreatorMap.put("eps2c", sEPSCreatorInfo);
        sDriverToCreatorMap.put("pdfwrite", sPDFCreatorInfo);
        sDriverToCreatorMap.put("ps", sPSCreatorInfo);
        sDriverToCreatorMap.put("ps2", sPSCreatorInfo);
        sDriverToCreatorMap.put("psc", sPSCreatorInfo);
        sDriverToCreatorMap.put("ps2c", sPSCreatorInfo);
        sDriverToCreatorMap.put("svg", sSVGCreatorInfo);
    }
}

