/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.jmi.Matlab;
import com.mathworks.util.GraphicsDeviceUtilities;
import java.awt.Rectangle;

public class HGGraphicsDeviceUtilities
extends GraphicsDeviceUtilities {
    public static void initializeScreenData() {
        GraphicsDeviceUtilities.registerLoadLibraryMethod((Runnable)new NativeHGLoadRunnable());
        HGGraphicsDeviceUtilities.initializeClass();
        GraphicsDeviceUtilities.registerNotifyDisplayChangeMethod((GraphicsDeviceUtilities.DisplayChangeListener)new HGDisplayChangedListener());
    }

    private static native void hgSendDisplayChangedEvent(int var0, int var1, int var2, Rectangle var3);

    private static class NativeHGLoadRunnable
    implements Runnable {
        private NativeHGLoadRunnable() {
        }

        @Override
        public void run() {
            try {
                if (Matlab.isMatlabAvailable()) {
                    System.loadLibrary("nativehg");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    public static class HGDisplayChangedListener
    implements GraphicsDeviceUtilities.DisplayChangeListener {
        public void sendDisplayChangedEvent(final int n, final int n2, final int n3, final Rectangle rectangle) {
            if (Matlab.isMatlabAvailable()) {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HGGraphicsDeviceUtilities.hgSendDisplayChangedEvent(n, n2, n3, rectangle);
                    }
                });
            }
        }
    }
}

