/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.format;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.grid.TableUtils;
import com.mathworks.hg.types.table.format.AbstractFormatPanel;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import com.mathworks.hg.types.table.format.MLFormatTypeEnum;
import com.mathworks.hg.types.table.panel.EditableTableUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.table.ListColorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class MLFormatPanel
extends AbstractFormatPanel {
    private MJTable typeTable;
    private MJLabel exampleValue;
    private EventList<MLFormatTypeEnum> eventList;
    private String initialValue;
    private boolean isStandalone;

    public MLFormatPanel(FormatTypeEnum formatTypeEnum, String string, boolean bl) {
        super(formatTypeEnum);
        this.initialValue = string;
        this.isStandalone = bl;
    }

    @Override
    public JComponent getFocusTarget() {
        return this.typeTable;
    }

    @Override
    protected JPanel buildTitlePanel(String string) {
        return this.isStandalone ? null : super.buildTitlePanel(string);
    }

    @Override
    protected JPanel buildFormatPanel() {
        JPanel jPanel = this.buildFormatTypePanel();
        if (this.isStandalone) {
            jPanel.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 0dlu, 2dlu"));
        } else {
            jPanel.setBorder(Borders.DLU7_BORDER);
        }
        return jPanel;
    }

    @Override
    protected String getFormat() {
        int n = this.typeTable.getSelectedRow();
        if (n != -1) {
            return ((MLFormatTypeEnum)((Object)((EventTableModel)this.typeTable.getModel()).getElementAt(n))).getName();
        }
        return null;
    }

    @Override
    protected boolean isValidFormat() {
        boolean bl;
        boolean bl2 = bl = this.typeTable.getSelectedRow() != -1;
        if (!bl) {
            EditableTableUtils.showWarningMessage((JComponent)this.typeTable, this.getResourceString("mlformat.validate_msg1"));
            this.setInitialSelection();
            this.typeTable.requestFocusInWindow();
        }
        return bl;
    }

    private JPanel buildFormatTypePanel() {
        JPanel jPanel = this.buildExamplePanel();
        String[] stringArray = new String[]{"name", "example", "description"};
        String[] stringArray2 = new String[]{"Format", "Example", "Description"};
        TableFormat tableFormat = GlazedLists.tableFormat(MLFormatTypeEnum.class, (String[])stringArray, (String[])stringArray2);
        this.eventList = new BasicEventList();
        this.eventList.addAll(Arrays.asList(MLFormatTypeEnum.values()));
        this.typeTable = new MJTable((TableModel)new EventTableModel(this.eventList, tableFormat));
        this.typeTable.setShowGrid(false);
        this.typeTable.setSelectionMode(0);
        this.typeTable.setTableHeader(null);
        this.typeTable.setIntercellSpacing(new Dimension(0, 1));
        TableUtils.autoResizeAllColumns((JTable)this.typeTable);
        this.typeTable.setAutoResizeMode(0);
        this.typeTable.setColumnSelectionAllowed(false);
        this.typeTable.setRowSelectionAllowed(true);
        this.typeTable.setHorizontalAutoScrollEnabled(true);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.typeTable);
        mJScrollPane.getViewport().setBackground(this.typeTable.getBackground());
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        ListColorUtils.installListRenderer((JTable)this.typeTable);
        this.attachSelectionListener();
        this.setInitialSelection();
        this.attachScrollPaneResizeListener((JTable)this.typeTable);
        MJLabel mJLabel = new MJLabel(this.getResourceString("mlformat.listlabel"));
        FormLayout formLayout = new FormLayout("fill:0dlu:g(1.0)", "p, 2dlu, fill:0dlu:g(1.0), 12dlu, p, 12dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)mJScrollPane, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    private JPanel buildExamplePanel() {
        MJLabel mJLabel = new MJLabel(this.getResourceString("mlformat.example_label"));
        this.exampleValue = new MJLabel();
        FormLayout formLayout = new FormLayout("p, 8dlu, p:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.exampleValue, cellConstraints.xy(3, 1));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBackground(SystemColor.controlHighlight);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow), Borders.createEmptyBorder((String)"2dlu, 4dlu, 2dlu, 4dlu")));
        return jPanel;
    }

    private void attachSelectionListener() {
        this.typeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = MLFormatPanel.this.typeTable.getSelectedRow();
                    if (n != -1) {
                        MLFormatTypeEnum mLFormatTypeEnum = (MLFormatTypeEnum)((Object)((EventTableModel)MLFormatPanel.this.typeTable.getModel()).getElementAt(n));
                        MLFormatPanel.this.exampleValue.setText(mLFormatTypeEnum.getExample());
                    } else {
                        MLFormatPanel.this.exampleValue.setText(null);
                    }
                }
            }
        });
    }

    private void setInitialSelection() {
        MLFormatTypeEnum mLFormatTypeEnum;
        if (this.initialValue != null && (mLFormatTypeEnum = MLFormatTypeEnum.parseString(this.initialValue)) != null) {
            int n = this.eventList.indexOf((Object)mLFormatTypeEnum);
            this.typeTable.getSelectionModel().setSelectionInterval(n, n);
        }
        if (this.typeTable.getSelectedRow() == -1) {
            this.typeTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        TableUtils.ensureRowSelectionVisible((JTable)this.typeTable);
    }

    private void attachScrollPaneResizeListener(final JTable jTable) {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Object object;
                int n;
                JComponent jComponent = (JComponent)componentEvent.getComponent();
                int n2 = jComponent.getWidth() - jComponent.getInsets().right - jComponent.getInsets().left;
                if (n2 > (n = jTable.getColumnModel().getTotalColumnWidth())) {
                    int n3;
                    object = jTable.getColumnModel();
                    int n4 = n3 = n2 - n;
                    int n5 = jTable.getColumnCount();
                    for (int i = 0; i < n5; ++i) {
                        int n6 = object.getColumn(i).getWidth();
                        int n7 = (int)((double)n3 * ((double)n6 * 1.0 / (double)n));
                        if (i == n5 - 1) {
                            n7 = n4;
                        }
                        n4 -= n7;
                        object.getColumn(i).setWidth(n6 + n7);
                        object.getColumn(i).setPreferredWidth(n6 + n7);
                    }
                }
                if ((object = (ComponentAdapter)jTable.getClientProperty("SCROLL_SIZE_LISTENER")) != null) {
                    jTable.getParent().removeComponentListener((ComponentListener)object);
                    jTable.putClientProperty("SCROLL_SIZE_LISTENER", null);
                }
            }
        };
        jTable.getParent().addComponentListener(componentAdapter);
        jTable.putClientProperty("SCROLL_SIZE_LISTENER", componentAdapter);
    }
}

