/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.LineStyleSpecifier;
import com.mathworks.hg.types.MarkerSpecifier;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.text.StrBuilder;

public final class LineSpec {
    private final LineStyleSpecifier lineStyle;
    private final MarkerSpecifier marker;

    public LineSpec(LineStyleSpecifier lineStyleSpecifier, MarkerSpecifier markerSpecifier) {
        if (lineStyleSpecifier == null) {
            throw new IllegalArgumentException("lineStyle argument must not be null.");
        }
        if (markerSpecifier == null) {
            throw new IllegalArgumentException("marker argument must not be null.");
        }
        this.lineStyle = lineStyleSpecifier;
        this.marker = markerSpecifier;
    }

    public LineSpec() {
        this(LineStyleSpecifier.getDefault(), MarkerSpecifier.getDefault());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineSpec)) {
            return false;
        }
        LineSpec lineSpec = (LineSpec)object;
        return this.lineStyle == lineSpec.lineStyle && this.marker == lineSpec.marker;
    }

    public static boolean equals(LineSpec lineSpec, LineSpec lineSpec2) {
        if (lineSpec != null) {
            return lineSpec.equals(lineSpec2);
        }
        return lineSpec == lineSpec2;
    }

    public String getSpecifier() {
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.setNullText("");
        if (this.lineStyle != null) {
            strBuilder.append(this.lineStyle.getSpecifier());
        }
        if (this.marker != null) {
            strBuilder.append(this.marker.getSpecifier());
        }
        return strBuilder.toString();
    }

    public LineStyleSpecifier getLineStyleSpecifier() {
        return this.lineStyle;
    }

    public MarkerSpecifier getMarkerSpecifier() {
        return this.marker;
    }

    public static String toString(List<LineSpec> list) {
        if (list == null || list.isEmpty()) {
            return "{}";
        }
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.append("{");
        for (int i = 0; i < list.size(); ++i) {
            LineSpec lineSpec = list.get(i);
            if (lineSpec == null || StringUtils.isBlank((String)lineSpec.getSpecifier())) continue;
            strBuilder.append("'");
            strBuilder.append(lineSpec.getSpecifier());
            strBuilder.append("'");
            if (i >= list.size() - 1) continue;
            strBuilder.append(",");
        }
        strBuilder.append("}");
        return strBuilder.toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("lineStyle", (Object)this.lineStyle).append("marker", (Object)this.marker).toString();
    }
}

