/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.table;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.AbstractStyleTableModel;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.mathworks.hg.peer.ui.table.TableHeaderNames;
import com.mathworks.hg.peer.ui.table.event.UITableCellEvent;
import com.mathworks.hg.peer.ui.table.event.UITableDataUpdateEvent;
import com.mathworks.hg.peer.ui.table.event.UITableDataUpdateListener;
import com.mathworks.hg.peer.ui.table.event.UITableModelCellEditListener;
import com.mathworks.hg.peer.ui.table.utils.UITableStringUtils;
import com.mathworks.hg.types.HGColor;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultUIStyleTableModel
extends AbstractStyleTableModel
implements ContextSensitiveTableModel {
    protected final Object mMutex = new Object();
    private ValueTableModel fWrappedModel;
    private TableHeaderNames fColumnName;
    private CellStyle fCellStyle;
    private List<HGColor> fBackgroundColors;
    private boolean fIsTableEditable;
    private List<Boolean> fEditableColumns;
    private int fDataColumnCount;
    private int fDataRowCount;
    private int fRowNameCount;
    private boolean fShowRowStriping;
    protected EventListenerList listenerList = new EventListenerList();
    private MatlabMCR fMatlabMCR;
    private static final String sEditorContextName = "DefaultUIStyleTableModelEditorContext";
    private static int sEditorContextCount = 0;
    private final int fEditorContextCount = sEditorContextCount++;

    public DefaultUIStyleTableModel(Object object, MatlabMCR matlabMCR) {
        if (Matlab.isMatlabAvailable()) {
            this.fWrappedModel = new UITableValueTableModel(object);
        }
        this.fColumnName = new TableHeaderNames();
        this.fCellStyle = new CellStyle();
        this.fBackgroundColors = new ArrayList<HGColor>();
        this.fIsTableEditable = false;
        this.fEditableColumns = new ArrayList<Boolean>();
        this.fRowNameCount = 0;
        this.fShowRowStriping = true;
        this.fMatlabMCR = matlabMCR;
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.fColumnName.setNames(objectArray);
        this.fireTableStructureChanged();
    }

    public void setRowNameCount(int n) {
        this.fRowNameCount = n;
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.fDataRowCount || n2 >= this.fDataColumnCount) {
            return "";
        }
        Object object = this.fWrappedModel.getValueAt(n, n2);
        if (object instanceof ValueDataSection) {
            return ((ValueDataSection)object).getValueAt(0, 0);
        }
        return object;
    }

    public int getRowCount() {
        return this.fWrappedModel.getRowCount();
    }

    public int getColumnCount() {
        return this.fWrappedModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.fColumnName.getHeaderName(n);
    }

    public String getContextKey() {
        return sEditorContextName + this.fEditorContextCount;
    }

    public ConverterContext getConverterContextAt(int n, int n2) {
        return new ConverterContext(this.getContextKey());
    }

    public EditorContext getEditorContextAt(int n, int n2) {
        return new EditorContext(this.getContextKey());
    }

    public Class getCellClassAt(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return object == null ? String.class : object.getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.fEditableColumns == null || this.fEditableColumns.isEmpty() || n2 >= this.fEditableColumns.size()) {
            return this.fIsTableEditable;
        }
        return this.fEditableColumns.get(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        String string;
        Object object2 = this.getValueAt(n, n2);
        String string2 = string = object2 == null ? "" : UITableStringUtils.getDisplayValue(object2).toString();
        if (object.toString().equals(string)) {
            return;
        }
        Object object3 = this.mMutex;
        synchronized (object3) {
            UITableCellEvent uITableCellEvent = new UITableCellEvent(n, n2, object);
            this.fireCellChanged(uITableCellEvent);
        }
    }

    public void updateCellAt(int n, int n2) {
        this.fWrappedModel.updateData(n, n2);
        this.fireTableCellUpdated(n, n2);
    }

    public void setTableEditable(boolean bl) {
        if (this.fIsTableEditable == bl) {
            return;
        }
        this.fIsTableEditable = bl;
        this.fireTableDataChanged();
    }

    public void setColumnEditable(boolean[] blArray) {
        if (blArray == null) {
            this.setTableEditable(false);
            return;
        }
        if (this.fEditableColumns == null) {
            this.fEditableColumns = new ArrayList<Boolean>();
        } else {
            this.fEditableColumns.clear();
        }
        if (blArray.length == 1) {
            this.fIsTableEditable = blArray[0];
            return;
        }
        for (boolean bl : blArray) {
            this.fEditableColumns.add(bl);
        }
    }

    public void setBackground(Color color) {
        this.fCellStyle.setBackground(color);
    }

    public void setForeground(Color color) {
        this.fCellStyle.setForeground(color);
    }

    public void setRowStriping(boolean bl) {
        this.fShowRowStriping = bl;
        this.fireTableDataChanged();
    }

    public void setBackground(HGColor[] hGColorArray) {
        if (hGColorArray == null || hGColorArray.length == 0 || hGColorArray.length == 1 && hGColorArray[0] == null) {
            this.fBackgroundColors = null;
            this.fBackgroundColors = new ArrayList<HGColor>();
            this.fCellStyle.setBackground(this.fCellStyle.getBackground());
        } else {
            this.fBackgroundColors = Arrays.asList(hGColorArray);
        }
        this.fireTableDataChanged();
    }

    public CellStyle getCellStyleAt(int n, int n2) {
        Color color = this.fCellStyle.getBackground();
        if (this.fBackgroundColors != null && this.fBackgroundColors.size() > 0) {
            if (this.fShowRowStriping) {
                int n3 = this.fBackgroundColors.size();
                this.fCellStyle.setBackground(HGColor.getColor(this.fBackgroundColors.get(n % n3)));
            } else {
                this.fCellStyle.setBackground(HGColor.getColor(this.fBackgroundColors.get(0)));
            }
            return this.fCellStyle;
        }
        this.fCellStyle.setBackground(color);
        return this.fCellStyle;
    }

    public boolean isCellStyleOn() {
        return true;
    }

    public void setDataRowCount(int n) {
        this.fDataRowCount = n;
    }

    public void setDataColumnCount(int n) {
        this.fDataColumnCount = n;
    }

    public void updateData() {
        this.fWrappedModel.updateData();
        this.fireTableStructureChanged();
    }

    public synchronized void removeUITableModelCellEditListener(UITableModelCellEditListener uITableModelCellEditListener) {
        this.listenerList.remove(UITableModelCellEditListener.class, uITableModelCellEditListener);
    }

    public synchronized void addUITableModelCellEditListener(UITableModelCellEditListener uITableModelCellEditListener) {
        this.listenerList.add(UITableModelCellEditListener.class, uITableModelCellEditListener);
    }

    protected void fireCellChanged(UITableCellEvent uITableCellEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.listenerList.getListeners(UITableModelCellEditListener.class)) {
            ((UITableModelCellEditListener)eventListener).cellChanged(uITableCellEvent);
        }
    }

    public synchronized void removeUITableDataUpdateListener(UITableDataUpdateListener uITableDataUpdateListener) {
        this.listenerList.remove(UITableDataUpdateListener.class, uITableDataUpdateListener);
    }

    public synchronized void addUITableDataUpdateListener(UITableDataUpdateListener uITableDataUpdateListener) {
        this.listenerList.add(UITableDataUpdateListener.class, uITableDataUpdateListener);
    }

    protected void fireDataUpdated(UITableDataUpdateEvent uITableDataUpdateEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.listenerList.getListeners(UITableDataUpdateListener.class)) {
            ((UITableDataUpdateListener)eventListener).dataUpdated(uITableDataUpdateEvent);
        }
    }

    class UITableValueTableModel
    extends ValueTableModel {
        private static final String NAME = "__uitable__";
        private Object handle;
        private boolean handleIsSet;

        public UITableValueTableModel(Object object) {
            super(NAME);
            this.handleIsSet = false;
            this.handle = object;
            this.handleIsSet = true;
        }

        public int getRowCount() {
            return Math.max(DefaultUIStyleTableModel.this.fDataRowCount, DefaultUIStyleTableModel.this.fRowNameCount);
        }

        public int getColumnCount() {
            return Math.max(DefaultUIStyleTableModel.this.fDataColumnCount, DefaultUIStyleTableModel.this.fColumnName.getNameCount());
        }

        protected Object getValueAt(int n, int n2, boolean bl, Formatter formatter) {
            Object object = super.getValueAt(n, n2, bl, formatter);
            return object;
        }

        protected boolean useAlternateInputs() {
            return true;
        }

        protected Object[] alternateInputs() {
            return new Object[]{this.handle, "Data"};
        }

        protected boolean okToCallMatlab() {
            return super.okToCallMatlab() && this.handleIsSet && this.handle != null;
        }

        protected void callToMatlabComplete() {
            DefaultUIStyleTableModel.this.fireDataUpdated(new UITableDataUpdateEvent());
        }

        protected boolean callMatlabOnlyAtPrompt() {
            return false;
        }

        protected MatlabMCR getMatlabMCR() {
            return DefaultUIStyleTableModel.this.fMatlabMCR;
        }
    }
}

