/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ComponentPositionListener;
import com.mathworks.hg.peer.FigureBoundsNotification;
import com.mathworks.hg.peer.FigureHG2Client;
import com.mathworks.hg.peer.FigureMediator;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigurePaintNotification;
import com.mathworks.hg.peer.FigureWindowNotification;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.PositionDataInDevice;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class FigureHG2Mediator
extends FigureMediator
implements FigureHG2Client {
    private FigureComponentPositionListener fPosListener = new FigureComponentPositionListener();

    public FigureHG2Mediator(Desktop desktop, String string, boolean bl, String string2, UIComponentParent uIComponentParent) {
        this.createFigureBase(desktop, string, bl, string2, uIComponentParent);
    }

    @Override
    public Component getAxisComponent() {
        Component component = super.getAxisComponent();
        if (component == null) {
            component = this.fFigurePanel.getContainer();
        }
        return component;
    }

    @Override
    public void requestFocusInAxis() {
        this.fFigurePanel.requestFocus();
    }

    @Override
    public void paintCallback(Graphics graphics) {
        this.handleNotification(new FigureWindowNotification(2));
        this.handleNotification(new FigurePaintNotification(this.fFigureCompContainerProxy.getComponent(), graphics));
    }

    @Override
    public void addSceneServerPeer(JavaSceneServerPeer javaSceneServerPeer) {
        assert (javaSceneServerPeer != null);
        javaSceneServerPeer.setParent(this.fFigurePanel);
        javaSceneServerPeer.getComponent().requestFocus();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.fFigurePanel.setBackgroundColor(color);
    }

    @Override
    public void initializeClient(int n, boolean bl) {
        super.initializeClient(n, bl);
        this.fFigurePanel.addContainerPositionListener(this.fPosListener);
    }

    @Override
    public void disposeClient() {
        this.fFigurePanel.removeContainerPositionListener(this.fPosListener);
        super.disposeClient();
    }

    private PositionDataInDevice constructPosDataInDeviceOnMoveResize() {
        Object object;
        assert (SwingUtilities.isEventDispatchThread()) : "Must call FigureHG2Mediator::positionChanged on EDT";
        Rectangle rectangle = this.fClientProxy.getClientRectangle();
        Insets insets = null;
        if (this.fClientProxy.isClientDocked()) {
            insets = this.fClientProxy.getDockedClientInsets();
        } else {
            object = this.getFigurePanelContainer();
            Rectangle rectangle2 = ((Component)object).getBounds();
            Container container = object;
            Window window = SwingUtilities.getWindowAncestor((Component)object);
            do {
                if ((container = container.getParent()) == null) continue;
                Point point = container.getLocation();
                rectangle2.translate(point.x, point.y);
            } while (container != null && !container.equals(window));
            insets = new Insets(rectangle2.y - rectangle.y, rectangle2.x - rectangle.x, rectangle.height - rectangle2.height - (rectangle2.y - rectangle.y), rectangle.width - rectangle2.width - (rectangle2.x - rectangle.x));
        }
        object = null;
        if (insets.top >= 0 && insets.left >= 0 && insets.bottom >= 0 && insets.right >= 0) {
            object = new PositionDataInDevice(rectangle, insets);
        }
        return object;
    }

    private boolean areFigurePanelContainerBoundsValid() {
        Container container = this.getFigurePanelContainer();
        return container != null && container.isDisplayable();
    }

    private void handleBoundsChange() {
        if (!this.areFigurePanelContainerBoundsValid()) {
            return;
        }
        PositionDataInDevice positionDataInDevice = this.constructPosDataInDeviceOnMoveResize();
        if (positionDataInDevice == null) {
            return;
        }
        FigureBoundsNotification figureBoundsNotification = new FigureBoundsNotification(positionDataInDevice);
        super.handleNotification(figureBoundsNotification);
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        if (figureNotification instanceof FigureMoveResizeNotification) {
            this.handleBoundsChange();
        } else {
            super.handleNotification(figureNotification);
        }
    }

    private class FigureComponentPositionListener
    extends ComponentPositionListener {
        @Override
        protected void positionChanged() {
            FigureHG2Mediator.this.handleBoundsChange();
        }
    }
}

