/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.hg.peer.UIPanel;
import com.mathworks.hg.peer.UnitPos;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;

public class FigureChild
implements HGPeerQueueUser {
    private double fUIContainer;
    private UnitPos fUnitPos;
    private Component fFigureComponent;
    private Container fFigureContainer;
    private UIComponentParent fCompParent;
    private UIPanel fUIPanel;
    private final Object fUIPanelLock = new Object();
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddFigureChild = 0;
    protected static final int sRemoveFigureChild = 1;
    protected static final int sSetPosition = 2;
    protected static final int sSetUnits = 3;
    protected static final int sSetVisible = 4;
    private static final int sLastMethodIndex = 4;
    private static final String[] sLogMessages = new String[]{"addFigureChild", "removetFigureChildUnits", "setFigureChildPosition", "setFigureChildUnits", "setFigureChildVisible"};

    public FigureChild(Component component) {
        this(20.0, 20.0, 60.0, 20.0);
        this.setFigureComponent(component);
    }

    public FigureChild(double d, double d2, double d3, double d4) {
        this.fUnitPos = new UnitPos(4, new HGRectangle(d, d2, d3, d4));
    }

    void add(final UIComponentParent uIComponentParent, final Container container) {
        if (this.doPreAdd(uIComponentParent, container)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 0, 0, false){

                @Override
                public void run() {
                    FigureChild.this.doAdd(uIComponentParent, container);
                }
            });
        }
    }

    void remove(final UIComponentParent uIComponentParent, final Container container) {
        if (this.doPreRemove(uIComponentParent, container)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 1, 1, false){

                @Override
                public void run() {
                    FigureChild.this.doRemove(uIComponentParent, container);
                }
            });
        }
    }

    protected boolean doPreAdd(UIComponentParent uIComponentParent, Container container) {
        this.addLogMessage(0);
        this.fCompParent = uIComponentParent;
        this.fFigureContainer = container;
        return this.fCompParent != null && this.fFigureContainer != null && this.fFigureComponent != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAdd(UIComponentParent uIComponentParent, Container container) {
        if (uIComponentParent != null) {
            Object object = this.fUIPanelLock;
            synchronized (object) {
                this.fUIPanel = new UIPanel(uIComponentParent, this.getFigureComponent(), this);
                this.fUIPanel.addTo(container);
            }
        }
    }

    protected boolean doPreRemove(UIComponentParent uIComponentParent, Container container) {
        this.addLogMessage(1);
        boolean bl = this.fCompParent != null && container != null && this.fFigureComponent != null;
        this.fCompParent = null;
        this.fFigureContainer = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(UIComponentParent uIComponentParent, Container container) {
        Object object = this.fUIPanelLock;
        synchronized (object) {
            if (this.fUIPanel != null) {
                this.fUIPanel.removeFrom(container);
                this.fUIPanel = null;
            }
        }
    }

    UnitPos getUnitPos() {
        return this.fUnitPos;
    }

    public void setUIContainer(double d) {
        this.fUIContainer = d;
    }

    public double getUIContainer() {
        return this.fUIContainer;
    }

    public Component getFigureComponent() {
        assert (this.fFigureComponent != null) : "Figure component handle not set.";
        return this.fFigureComponent;
    }

    protected void setFigureComponent(Component component) {
        this.fFigureComponent = component;
    }

    public double[] getPosition() {
        return this.fUnitPos.getDoublePosition();
    }

    public double[] getPixelPosition() {
        double[] dArray = new double[4];
        HGRectangle hGRectangle = this.fUnitPos.getPosition(UnitPos.unitsToInt("pixels"), this.getContainerSize());
        dArray[0] = hGRectangle.getX();
        dArray[1] = hGRectangle.getY();
        dArray[2] = hGRectangle.getWidth();
        dArray[3] = hGRectangle.getHeight();
        return dArray;
    }

    public void setPixelBounds(double[] dArray) throws Throwable {
        int n = (int)(dArray[2] - dArray[0]);
        int n2 = (int)(dArray[3] - dArray[1]);
        int n3 = (int)dArray[0];
        int n4 = (int)dArray[1];
        final Rectangle rectangle = new Rectangle(n3, n4, n, n2);
        Dimension dimension = this.localGetContainerSize();
        HGRectangle hGRectangle = UnitPos.boundsToPixelPositionWithPixelOriginOffset(rectangle, dimension);
        this.syncUnitPos(new double[]{hGRectangle.getX(), hGRectangle.getY(), hGRectangle.getWidth(), hGRectangle.getHeight()}, dimension);
        HGUtils.invokeLater(new HGPeerRunnable(this, 2, 7){

            @Override
            public void run() {
                FigureChild.this.setBoundsOnJavaComponent(rectangle);
            }
        });
    }

    private Dimension localGetContainerSize() throws Throwable {
        Dimension dimension = this.getContainerSize();
        if (dimension == null || dimension.getWidth() == 0.0 || dimension.getHeight() == 0.0) {
            dimension = (Dimension)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)new AWTUtilities.InvocationRunnable(){

                public Object runWithOutput() {
                    return FigureChild.this.getContainerSize();
                }
            });
        }
        return dimension;
    }

    private void syncUnitPos(double[] dArray, Dimension dimension) {
        int n = this.fUnitPos.getUnits();
        this.fUnitPos.setUnits(UnitPos.unitsToInt("pixels"), dimension);
        this.fUnitPos.setPosition(dArray);
        this.fUnitPos.setUnits(n, dimension);
    }

    public void setPixelPosition(double[] dArray) {
        this.syncUnitPos(dArray, this.getContainerSize());
        this.updatePosition(false);
    }

    private Dimension getContainerSize() {
        return this.fFigureContainer == null ? null : this.fFigureContainer.getSize();
    }

    private void updatePosition(boolean bl) {
        if (bl) {
            this.updateHGProxyPosition();
        }
        HGUtils.invokeLater(new HGPeerRunnable(this, 2, 7){

            @Override
            public void run() {
                Container container = FigureChild.this.fFigureContainer;
                if (container != null) {
                    Rectangle rectangle = FigureChild.this.fUnitPos.getBounds(container.getSize());
                    FigureChild.this.setBoundsOnJavaComponent(rectangle);
                }
            }
        });
    }

    private void updateHGProxyPosition() {
        try {
            double[] dArray = this.getPixelPosition();
            double[] dArray2 = (double[])Matlab.mtFeval((String)"getpixelposition", (Object[])new Object[]{this.fUIContainer, true}, (int)1);
            if (dArray[0] != dArray2[0] || dArray[1] != dArray2[1] || dArray[2] != dArray2[2] || dArray[3] != dArray2[3]) {
                Matlab.mtFeval((String)"setpixelposition", (Object[])new Object[]{this.fUIContainer, dArray, true}, (int)0);
            }
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private void setBoundsOnJavaComponent(Rectangle rectangle) {
        Container container = this.getFigureComponent().getParent();
        if (container != null) {
            container.setBounds(rectangle);
            container.validate();
            container.repaint();
        } else {
            this.getFigureComponent().setBounds(rectangle);
        }
    }

    public void setPosition(double[][] dArray) {
        this.fUnitPos.setPosition(dArray);
        this.updatePosition(true);
    }

    public void setPosition(double[] dArray) {
        this.fUnitPos.setPosition(dArray);
        this.updatePosition(true);
    }

    public String getUnits() {
        return UnitPos.unitsToString(this.fUnitPos.getUnits());
    }

    public void setUnits(String string) {
        this.fUnitPos.setUnits(UnitPos.unitsToInt(string), this.getContainerSize());
        try {
            Matlab.mtFeval((String)"set", (Object[])new Object[]{this.fUIContainer, "Units", string}, (int)0);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public void setVisible(String string) {
        if (string.equals("on")) {
            this.setVisible(true);
            return;
        }
        if (string.equals("off")) {
            this.setVisible(false);
            return;
        }
        assert (false) : "Invalid value for Visible - expected 'on' or 'off'";
    }

    public void setVisible(final boolean bl) {
        try {
            Matlab.mtFeval((String)"set", (Object[])new Object[]{this.fUIContainer, "Visible", bl ? "on" : "off"}, (int)0);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        HGUtils.invokeLater(new HGPeerRunnable(this, 4, 7){

            @Override
            public void run() {
                FigureChild.this.getFigureComponent().setVisible(bl);
            }
        });
    }

    public boolean isVisible() {
        return this.getFigureComponent().isVisible();
    }

    UIComponentParent getUIComponentParent() {
        return this.fCompParent;
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.fCompParent;
    }

    @Override
    public int getUserLastMethodID() {
        return FigureChild.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 4) {
            string = sLogMessages[n - 0];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return 4;
    }

    public void addLogMessage(int n) {
        if (DebugUtilities.isDebugOptions() && n <= this.getUserLastMethodID()) {
            DebugUtilities.logMessage(32, this.getClass().getName() + "." + this.getUserMethodDescription(n), this);
        }
    }
}

