/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.jfreechart.ValueSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TreePair<V extends Comparable> {
    private SimpleTree<V> start = new SimpleTree<Comparable>(GlazedLists.comparableComparator());
    private SimpleTree<V> end = new SimpleTree<Comparable>(GlazedLists.comparableComparator());

    TreePair() {
    }

    public void insert(ValueSegment<V, ?> segment) {
        this.start.addInSortedOrder((byte)1, segment.getStart(), 1);
        this.end.addInSortedOrder((byte)1, segment.getEnd(), 1);
    }

    public void update(ValueSegment<V, ?> previousSegment, ValueSegment<V, ?> newSegment) {
        this.delete(previousSegment);
        this.insert(newSegment);
    }

    public void delete(ValueSegment<V, ?> segment) {
        int startIndex = this.start.indexOfValue(segment.getStart(), true, false, (byte)1);
        int endIndex = this.end.indexOfValue(segment.getEnd(), true, false, (byte)1);
        this.start.remove(startIndex, 1);
        this.end.remove(endIndex, 1);
    }

    public void clear() {
        this.start = new SimpleTree<Comparable>(GlazedLists.comparableComparator());
        this.end = new SimpleTree<Comparable>(GlazedLists.comparableComparator());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int getCount(V start, V end) {
        int numStartedBeforeSegmentEnd = this.start.indexOfValue(end, true, true, (byte)1);
        int numEndedBeforeSegmentStart = this.end.indexOfValue(start, true, true, (byte)1);
        return numStartedBeforeSegmentEnd - numEndedBeforeSegmentStart;
    }

    public int size() {
        return this.start.size();
    }
}

