/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(long[].class);
    private static final int scale = unsafe.arrayIndexScale(long[].class);
    private final long[] array;

    private long rawIndex(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return base + n * scale;
    }

    public AtomicLongArray(int n) {
        this.array = new long[n];
        if (n > 0) {
            unsafe.putLongVolatile(this.array, this.rawIndex(0), 0L);
        }
    }

    public AtomicLongArray(long[] lArray) {
        if (lArray == null) {
            throw new NullPointerException();
        }
        int n = lArray.length;
        this.array = new long[n];
        if (n > 0) {
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                this.array[i] = lArray[i];
            }
            unsafe.putLongVolatile(this.array, this.rawIndex(n2), lArray[n2]);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final long get(int n) {
        return unsafe.getLongVolatile(this.array, this.rawIndex(n));
    }

    public final void set(int n, long l) {
        unsafe.putLongVolatile(this.array, this.rawIndex(n), l);
    }

    public final void lazySet(int n, long l) {
        unsafe.putOrderedLong(this.array, this.rawIndex(n), l);
    }

    public final long getAndSet(int n, long l) {
        long l2;
        while (!this.compareAndSet(n, l2 = this.get(n), l)) {
        }
        return l2;
    }

    public final boolean compareAndSet(int n, long l, long l2) {
        return unsafe.compareAndSwapLong(this.array, this.rawIndex(n), l, l2);
    }

    public final boolean weakCompareAndSet(int n, long l, long l2) {
        return this.compareAndSet(n, l, l2);
    }

    public final long getAndIncrement(int n) {
        long l;
        long l2;
        while (!this.compareAndSet(n, l2 = this.get(n), l = l2 + 1L)) {
        }
        return l2;
    }

    public final long getAndDecrement(int n) {
        long l;
        long l2;
        while (!this.compareAndSet(n, l2 = this.get(n), l = l2 - 1L)) {
        }
        return l2;
    }

    public final long getAndAdd(int n, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(n, l3 = this.get(n), l2 = l3 + l)) {
        }
        return l3;
    }

    public final long incrementAndGet(int n) {
        long l;
        long l2;
        while (!this.compareAndSet(n, l2 = this.get(n), l = l2 + 1L)) {
        }
        return l;
    }

    public final long decrementAndGet(int n) {
        long l;
        long l2;
        while (!this.compareAndSet(n, l2 = this.get(n), l = l2 - 1L)) {
        }
        return l;
    }

    public long addAndGet(int n, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(n, l3 = this.get(n), l2 = l3 + l)) {
        }
        return l2;
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

