/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLEntityScanner;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.xml.internal.stream.Entity;
import com.sun.xml.internal.stream.XMLEntityStorage;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public abstract class XMLScanner
implements XMLComponent {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final boolean DEBUG_ATTR_NORMALIZATION = false;
    private boolean fNeedNonNormalizedValue = false;
    protected ArrayList attributeValueCache = new ArrayList();
    protected ArrayList stringBufferCache = new ArrayList();
    protected int fStringBufferIndex = 0;
    protected boolean fAttributeCacheInitDone = false;
    protected int fAttributeCacheUsedCount = 0;
    protected boolean fValidation = false;
    protected boolean fNamespaces;
    protected boolean fNotifyCharRefs = false;
    protected boolean fParserSettings = true;
    protected PropertyManager fPropertyManager = null;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager = null;
    protected XMLEntityStorage fEntityStore = null;
    protected XMLEvent fEvent;
    protected XMLEntityScanner fEntityScanner = null;
    protected int fEntityDepth;
    protected String fCharRefLiteral = null;
    protected boolean fScanningAttribute;
    protected boolean fReportEntity;
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fEncodingSymbol = "encoding".intern();
    protected static final String fStandaloneSymbol = "standalone".intern();
    protected static final String fAmpSymbol = "amp".intern();
    protected static final String fLtSymbol = "lt".intern();
    protected static final String fGtSymbol = "gt".intern();
    protected static final String fQuotSymbol = "quot".intern();
    protected static final String fAposSymbol = "apos".intern();
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();
    protected XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    int initialCacheCount = 6;

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fParserSettings = xMLComponentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fParserSettings = true;
        }
        if (!this.fParserSettings) {
            this.init();
            return;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.fEntityStore = this.fEntityManager.getEntityStore();
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        try {
            this.fNotifyCharRefs = xMLComponentManager.getFeature(NOTIFY_CHAR_REFS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNotifyCharRefs = false;
        }
        this.init();
    }

    protected void setPropertyManager(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            } else if (string2.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)object;
            }
        }
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (VALIDATION.equals(string)) {
            this.fValidation = bl;
        } else if (NOTIFY_CHAR_REFS.equals(string)) {
            this.fNotifyCharRefs = bl;
        }
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        if (VALIDATION.equals(string)) {
            return this.fValidation;
        }
        if (NOTIFY_CHAR_REFS.equals(string)) {
            return this.fNotifyCharRefs;
        }
        throw new XMLConfigurationException(0, string);
    }

    protected void reset() {
        this.init();
        this.fValidation = true;
        this.fNotifyCharRefs = false;
    }

    public void reset(PropertyManager propertyManager) {
        this.init();
        this.fSymbolTable = (SymbolTable)propertyManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)propertyManager.getProperty(ENTITY_MANAGER);
        this.fEntityStore = this.fEntityManager.getEntityStore();
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
        this.fValidation = false;
        this.fNotifyCharRefs = false;
    }

    protected void scanXMLDeclOrTextDecl(boolean bl, String[] stringArray) throws IOException, XNIException {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = this.fEntityScanner.skipSpaces();
        while (this.fEntityScanner.peekChar() != 63) {
            bl2 = true;
            String string4 = this.scanPseudoAttribute(bl, this.fString);
            switch (n) {
                case 0: {
                    if (string4.equals(fVersionSymbol)) {
                        if (!bl3) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        string = this.fString.toString();
                        n = 1;
                        if (!this.versionSupported(string)) {
                            this.reportFatalError("VersionNotSupported", new Object[]{string});
                        }
                        if (!string.equals("1.1")) break;
                        Entity.ScannedEntity scannedEntity = this.fEntityManager.getTopLevelEntity();
                        if (scannedEntity != null && (scannedEntity.version == null || scannedEntity.version.equals("1.0"))) {
                            this.reportFatalError("VersionMismatch", null);
                        }
                        this.fEntityManager.setScannerVersion((short)2);
                        break;
                    }
                    if (string4.equals(fEncodingSymbol)) {
                        if (!bl) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!bl3) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n = bl ? 3 : 2;
                        break;
                    }
                    if (bl) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (string4.equals(fEncodingSymbol)) {
                        if (!bl3) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n = bl ? 3 : 2;
                        break;
                    }
                    if (!bl && string4.equals(fStandaloneSymbol)) {
                        if (!bl3) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string3 = this.fString.toString();
                        n = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (string4.equals(fStandaloneSymbol)) {
                        if (!bl3) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string3 = this.fString.toString();
                        n = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            bl3 = this.fEntityScanner.skipSpaces();
        }
        if (bl && n != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (bl) {
            if (!bl2 && string2 == null) {
                this.reportFatalError("EncodingDeclRequired", null);
            }
        } else if (!bl2 && string == null) {
            this.reportFatalError("VersionInfoRequired", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
    }

    public String scanPseudoAttribute(boolean bl, XMLString xMLString) throws IOException, XNIException {
        String string = this.fEntityScanner.scanName();
        if (string == null) {
            this.reportFatalError("PseudoAttrNameExpected", null);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError(bl ? "EqRequiredInTextDecl" : "EqRequiredInXMLDecl", new Object[]{string});
        }
        this.fEntityScanner.skipSpaces();
        int n = this.fEntityScanner.peekChar();
        if (n != 39 && n != 34) {
            this.reportFatalError(bl ? "QuoteRequiredInTextDecl" : "QuoteRequiredInXMLDecl", new Object[]{string});
        }
        this.fEntityScanner.scanChar();
        int n2 = this.fEntityScanner.scanLiteral(n, xMLString);
        if (n2 != n) {
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append(xMLString);
                if (n2 == -1) continue;
                if (n2 == 38 || n2 == 37 || n2 == 60 || n2 == 93) {
                    this.fStringBuffer2.append((char)this.fEntityScanner.scanChar());
                    continue;
                }
                if (XMLChar.isHighSurrogate(n2)) {
                    this.scanSurrogates(this.fStringBuffer2);
                    continue;
                }
                if (!this.isInvalidLiteral(n2)) continue;
                String string2 = bl ? "InvalidCharInTextDecl" : "InvalidCharInXMLDecl";
                this.reportFatalError(string2, new Object[]{Integer.toString(n2, 16)});
                this.fEntityScanner.scanChar();
            } while ((n2 = this.fEntityScanner.scanLiteral(n, xMLString)) != n);
            this.fStringBuffer2.append(xMLString);
            xMLString.setValues(this.fStringBuffer2);
        }
        if (!this.fEntityScanner.skipChar(n)) {
            this.reportFatalError(bl ? "CloseQuoteMissingInTextDecl" : "CloseQuoteMissingInXMLDecl", new Object[]{string});
        }
        return string;
    }

    protected void scanPI(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        this.fReportEntity = false;
        String string = this.fEntityScanner.scanName();
        if (string == null) {
            this.reportFatalError("PITargetRequired", null);
        }
        this.scanPIData(string, xMLStringBuffer);
        this.fReportEntity = true;
    }

    protected void scanPIData(String string, XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        int n;
        if (string.length() == 3) {
            n = Character.toLowerCase(string.charAt(0));
            char c = Character.toLowerCase(string.charAt(1));
            char c2 = Character.toLowerCase(string.charAt(2));
            if (n == 120 && c == 'm' && c2 == 'l') {
                this.reportFatalError("ReservedPITarget", null);
            }
        }
        if (!this.fEntityScanner.skipSpaces()) {
            if (this.fEntityScanner.skipString("?>")) {
                return;
            }
            this.reportFatalError("SpaceRequiredInPI", null);
        }
        if (this.fEntityScanner.scanData("?>", xMLStringBuffer)) {
            do {
                if ((n = this.fEntityScanner.peekChar()) == -1) continue;
                if (XMLChar.isHighSurrogate(n)) {
                    this.scanSurrogates(xMLStringBuffer);
                    continue;
                }
                if (!this.isInvalidLiteral(n)) continue;
                this.reportFatalError("InvalidCharInPI", new Object[]{Integer.toHexString(n)});
                this.fEntityScanner.scanChar();
            } while (this.fEntityScanner.scanData("?>", xMLStringBuffer));
        }
    }

    protected void scanComment(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        xMLStringBuffer.clear();
        while (this.fEntityScanner.scanData("--", xMLStringBuffer)) {
            int n = this.fEntityScanner.peekChar();
            if (n == -1) continue;
            if (XMLChar.isHighSurrogate(n)) {
                this.scanSurrogates(xMLStringBuffer);
            }
            if (!this.isInvalidLiteral(n)) continue;
            this.reportFatalError("InvalidCharInComment", new Object[]{Integer.toHexString(n)});
            this.fEntityScanner.scanChar();
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("DashDashInComment", null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scanAttributeValue(XMLString xMLString, XMLString xMLString2, String string, XMLAttributes xMLAttributes, int n, boolean bl) throws IOException, XNIException {
        int n2;
        int n3;
        block29: {
            XMLStringBuffer xMLStringBuffer = null;
            n3 = this.fEntityScanner.peekChar();
            if (n3 != 39 && n3 != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{string});
            }
            this.fEntityScanner.scanChar();
            int n4 = this.fEntityDepth;
            int n5 = this.fEntityScanner.scanLiteral(n3, xMLString);
            if (this.fNeedNonNormalizedValue) {
                this.fStringBuffer2.clear();
                this.fStringBuffer2.append(xMLString);
            }
            if (this.fEntityScanner.whiteSpaceLen > 0) {
                this.normalizeWhitespace(xMLString);
            }
            if (n5 == n3) break block29;
            this.fScanningAttribute = true;
            xMLStringBuffer = this.getStringBuffer();
            xMLStringBuffer.clear();
            do {
                block32: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block30: {
                                        String string2;
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block34: {
                                                        block33: {
                                                            block31: {
                                                                int n6;
                                                                xMLStringBuffer.append(xMLString);
                                                                if (n5 != 38) break block30;
                                                                this.fEntityScanner.skipChar(38);
                                                                if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                                                    this.fStringBuffer2.append('&');
                                                                }
                                                                if (!this.fEntityScanner.skipChar(35)) break block31;
                                                                if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                                                    this.fStringBuffer2.append('#');
                                                                }
                                                                if ((n6 = this.fNeedNonNormalizedValue ? this.scanCharReferenceValue(xMLStringBuffer, this.fStringBuffer2) : this.scanCharReferenceValue(xMLStringBuffer, null)) == -1) {
                                                                    // empty if block
                                                                }
                                                                break block32;
                                                            }
                                                            string2 = this.fEntityScanner.scanName();
                                                            if (string2 == null) {
                                                                this.reportFatalError("NameRequiredInReference", null);
                                                            } else if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                                                this.fStringBuffer2.append(string2);
                                                            }
                                                            if (!this.fEntityScanner.skipChar(59)) {
                                                                this.reportFatalError("SemicolonRequiredInReference", new Object[]{string2});
                                                            } else if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                                                this.fStringBuffer2.append(';');
                                                            }
                                                            if (string2 != fAmpSymbol) break block33;
                                                            xMLStringBuffer.append('&');
                                                            break block32;
                                                        }
                                                        if (string2 != fAposSymbol) break block34;
                                                        xMLStringBuffer.append('\'');
                                                        break block32;
                                                    }
                                                    if (string2 != fLtSymbol) break block35;
                                                    xMLStringBuffer.append('<');
                                                    break block32;
                                                }
                                                if (string2 != fGtSymbol) break block36;
                                                xMLStringBuffer.append('>');
                                                break block32;
                                            }
                                            if (string2 != fQuotSymbol) break block37;
                                            xMLStringBuffer.append('\"');
                                            break block32;
                                        }
                                        if (this.fEntityStore.isExternalEntity(string2)) {
                                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{string2});
                                            break block32;
                                        } else {
                                            if (!this.fEntityStore.isDeclaredEntity(string2)) {
                                                if (bl) {
                                                    if (this.fValidation) {
                                                        this.fErrorReporter.reportError(this.fEntityScanner, "http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{string2}, (short)1);
                                                    }
                                                } else {
                                                    this.reportFatalError("EntityNotDeclared", new Object[]{string2});
                                                }
                                            }
                                            this.fEntityManager.startEntity(string2, true);
                                        }
                                        break block32;
                                    }
                                    if (n5 != 60) break block38;
                                    this.reportFatalError("LessthanInAttValue", new Object[]{null, string});
                                    this.fEntityScanner.scanChar();
                                    if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                        this.fStringBuffer2.append((char)n5);
                                    }
                                    break block32;
                                }
                                if (n5 != 37 && n5 != 93) break block39;
                                this.fEntityScanner.scanChar();
                                xMLStringBuffer.append((char)n5);
                                if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                    this.fStringBuffer2.append((char)n5);
                                }
                                break block32;
                            }
                            if (n5 != 10 && n5 != 13) break block40;
                            this.fEntityScanner.scanChar();
                            xMLStringBuffer.append(' ');
                            if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                this.fStringBuffer2.append('\n');
                            }
                            break block32;
                        }
                        if (n5 == -1 || !XMLChar.isHighSurrogate(n5)) break block41;
                        if (this.scanSurrogates(this.fStringBuffer3)) {
                            xMLStringBuffer.append(this.fStringBuffer3);
                            if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                                this.fStringBuffer2.append(this.fStringBuffer3);
                            }
                        }
                        break block32;
                    }
                    if (n5 != -1 && this.isInvalidLiteral(n5)) {
                        this.reportFatalError("InvalidCharInAttValue", new Object[]{Integer.toString(n5, 16)});
                        this.fEntityScanner.scanChar();
                        if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                            this.fStringBuffer2.append((char)n5);
                        }
                    }
                }
                n5 = this.fEntityScanner.scanLiteral(n3, xMLString);
                if (n4 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                    this.fStringBuffer2.append(xMLString);
                }
                if (this.fEntityScanner.whiteSpaceLen <= 0) continue;
                this.normalizeWhitespace(xMLString);
            } while (n5 != n3 || n4 != this.fEntityDepth);
            xMLStringBuffer.append(xMLString);
            xMLString.setValues(xMLStringBuffer);
            this.fScanningAttribute = false;
        }
        if (this.fNeedNonNormalizedValue) {
            xMLString2.setValues(this.fStringBuffer2);
        }
        if ((n2 = this.fEntityScanner.scanChar()) != n3) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{string});
        }
    }

    protected void scanExternalID(String[] stringArray, boolean bl) throws IOException, XNIException {
        String string = null;
        String string2 = null;
        if (this.fEntityScanner.skipString("PUBLIC")) {
            if (!this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterPUBLIC", null);
            }
            this.scanPubidLiteral(this.fString);
            string2 = this.fString.toString();
            if (!this.fEntityScanner.skipSpaces() && !bl) {
                this.reportFatalError("SpaceRequiredBetweenPublicAndSystem", null);
            }
        }
        if (string2 != null || this.fEntityScanner.skipString("SYSTEM")) {
            int n;
            if (string2 == null && !this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterSYSTEM", null);
            }
            if ((n = this.fEntityScanner.peekChar()) != 39 && n != 34) {
                if (string2 != null && bl) {
                    stringArray[0] = null;
                    stringArray[1] = string2;
                    return;
                }
                this.reportFatalError("QuoteRequiredInSystemID", null);
            }
            this.fEntityScanner.scanChar();
            XMLString xMLString = this.fString;
            if (this.fEntityScanner.scanLiteral(n, xMLString) != n) {
                this.fStringBuffer.clear();
                do {
                    this.fStringBuffer.append(xMLString);
                    int n2 = this.fEntityScanner.peekChar();
                    if (XMLChar.isMarkup(n2) || n2 == 93) {
                        this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
                        continue;
                    }
                    if (n2 == -1 || !this.isInvalidLiteral(n2)) continue;
                    this.reportFatalError("InvalidCharInSystemID", new Object[]{Integer.toString(n2, 16)});
                } while (this.fEntityScanner.scanLiteral(n, xMLString) != n);
                this.fStringBuffer.append(xMLString);
                xMLString = this.fStringBuffer;
            }
            string = xMLString.toString();
            if (!this.fEntityScanner.skipChar(n)) {
                this.reportFatalError("SystemIDUnterminated", null);
            }
        }
        stringArray[0] = string;
        stringArray[1] = string2;
    }

    protected boolean scanPubidLiteral(XMLString xMLString) throws IOException, XNIException {
        int n = this.fEntityScanner.scanChar();
        if (n != 39 && n != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            int n2;
            if ((n2 = this.fEntityScanner.scanChar()) == 32 || n2 == 10 || n2 == 13) {
                if (bl) continue;
                this.fStringBuffer.append(' ');
                bl = true;
                continue;
            }
            if (n2 == n) {
                if (bl) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(n2)) {
                this.fStringBuffer.append((char)n2);
                bl = false;
                continue;
            }
            if (n2 == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            bl2 = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(n2)});
        }
        xMLString.setValues(this.fStringBuffer);
        return bl2;
    }

    protected void normalizeWhitespace(XMLString xMLString) {
        int n = 0;
        int[] nArray = this.fEntityScanner.whiteSpaceLookup;
        int n2 = this.fEntityScanner.whiteSpaceLen;
        int n3 = xMLString.offset + xMLString.length;
        for (int i = 0; i < n2; ++i) {
            n = nArray[i];
            if (n >= n3) continue;
            xMLString.ch[n] = 32;
        }
    }

    public void startEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        ++this.fEntityDepth;
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
        this.fEntityStore = this.fEntityManager.getEntityStore();
    }

    public void endEntity(String string, Augmentations augmentations) throws IOException, XNIException {
        --this.fEntityDepth;
    }

    protected int scanCharReferenceValue(XMLStringBuffer xMLStringBuffer, XMLStringBuffer xMLStringBuffer2) throws IOException, XNIException {
        int n;
        int n2;
        boolean bl = false;
        if (this.fEntityScanner.skipChar(120)) {
            if (xMLStringBuffer2 != null) {
                xMLStringBuffer2.append('x');
            }
            bl = true;
            this.fStringBuffer3.clear();
            n2 = 1;
            n = this.fEntityScanner.peekChar();
            int n3 = n2 = n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70 ? 1 : 0;
            if (n2 != 0) {
                if (xMLStringBuffer2 != null) {
                    xMLStringBuffer2.append((char)n);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n);
                do {
                    int n4 = n2 = (n = this.fEntityScanner.peekChar()) >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70 ? 1 : 0;
                    if (n2 == 0) continue;
                    if (xMLStringBuffer2 != null) {
                        xMLStringBuffer2.append((char)n);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)n);
                } while (n2 != 0);
            } else {
                this.reportFatalError("HexdigitRequiredInCharRef", null);
            }
        } else {
            this.fStringBuffer3.clear();
            n2 = 1;
            n = this.fEntityScanner.peekChar();
            int n5 = n2 = n >= 48 && n <= 57 ? 1 : 0;
            if (n2 != 0) {
                if (xMLStringBuffer2 != null) {
                    xMLStringBuffer2.append((char)n);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n);
                do {
                    int n6 = n2 = (n = this.fEntityScanner.peekChar()) >= 48 && n <= 57 ? 1 : 0;
                    if (n2 == 0) continue;
                    if (xMLStringBuffer2 != null) {
                        xMLStringBuffer2.append((char)n);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)n);
                } while (n2 != 0);
            } else {
                this.reportFatalError("DigitRequiredInCharRef", null);
            }
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInCharRef", null);
        }
        if (xMLStringBuffer2 != null) {
            xMLStringBuffer2.append(';');
        }
        n2 = -1;
        try {
            n2 = Integer.parseInt(this.fStringBuffer3.toString(), bl ? 16 : 10);
            if (this.isInvalid(n2)) {
                StringBuffer stringBuffer = new StringBuffer(this.fStringBuffer3.length + 1);
                if (bl) {
                    stringBuffer.append('x');
                }
                stringBuffer.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
                this.reportFatalError("InvalidCharRef", new Object[]{stringBuffer.toString()});
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer(this.fStringBuffer3.length + 1);
            if (bl) {
                stringBuffer.append('x');
            }
            stringBuffer.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
            this.reportFatalError("InvalidCharRef", new Object[]{stringBuffer.toString()});
        }
        if (!XMLChar.isSupplemental(n2)) {
            xMLStringBuffer.append((char)n2);
        } else {
            xMLStringBuffer.append(XMLChar.highSurrogate(n2));
            xMLStringBuffer.append(XMLChar.lowSurrogate(n2));
        }
        if (this.fNotifyCharRefs && n2 != -1) {
            String string = "#" + (bl ? "x" : "") + this.fStringBuffer3.toString();
            if (!this.fScanningAttribute) {
                this.fCharRefLiteral = string;
            }
        }
        return n2;
    }

    protected boolean isInvalid(int n) {
        return XMLChar.isInvalid(n);
    }

    protected boolean isInvalidLiteral(int n) {
        return XMLChar.isInvalid(n);
    }

    protected boolean isValidNameChar(int n) {
        return XMLChar.isName(n);
    }

    protected boolean isValidNCName(int n) {
        return XMLChar.isNCName(n);
    }

    protected boolean isValidNameStartChar(int n) {
        return XMLChar.isNameStart(n);
    }

    protected boolean versionSupported(String string) {
        return string.equals("1.0") || string.equals("1.1");
    }

    protected boolean scanSurrogates(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        int n = this.fEntityScanner.scanChar();
        int n2 = this.fEntityScanner.peekChar();
        if (!XMLChar.isLowSurrogate(n2)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n, 16)});
            return false;
        }
        this.fEntityScanner.scanChar();
        int n3 = XMLChar.supplemental((char)n, (char)n2);
        if (this.isInvalid(n3)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n3, 16)});
            return false;
        }
        xMLStringBuffer.append((char)n);
        xMLStringBuffer.append((char)n2);
        return true;
    }

    protected void reportFatalError(String string, Object[] objectArray) throws XNIException {
        this.fErrorReporter.reportError(this.fEntityScanner, "http://www.w3.org/TR/1998/REC-xml-19980210", string, objectArray, (short)2);
    }

    private void init() {
        this.fEntityScanner = null;
        this.fEntityDepth = 0;
        this.fReportEntity = true;
        this.fResourceIdentifier.clear();
        if (!this.fAttributeCacheInitDone) {
            for (int i = 0; i < this.initialCacheCount; ++i) {
                this.attributeValueCache.add(new XMLString());
                this.stringBufferCache.add(new XMLStringBuffer());
            }
            this.fAttributeCacheInitDone = true;
        }
        this.fStringBufferIndex = 0;
        this.fAttributeCacheUsedCount = 0;
    }

    XMLStringBuffer getStringBuffer() {
        if (this.fStringBufferIndex < this.initialCacheCount || this.fStringBufferIndex < this.stringBufferCache.size()) {
            return (XMLStringBuffer)this.stringBufferCache.get(this.fStringBufferIndex++);
        }
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        ++this.fStringBufferIndex;
        this.stringBufferCache.add(xMLStringBuffer);
        return xMLStringBuffer;
    }
}

