/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.comparisons.param.parameter.CParameterIncludeSubfolders;
import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceIncludeSubfolders;
import com.mathworks.comparisons.register.ComparisonTypeRegister;
import com.mathworks.comparisons.selection.BrowseAction;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.dialog.ComparisonTypesReady;
import com.mathworks.comparisons.selection.dialog.DetermineComparisonTypes;
import com.mathworks.comparisons.selection.dialog.SourceSelectionComboBox;
import com.mathworks.comparisons.selection.dialog.SourceSelectionComboBoxModel;
import com.mathworks.comparisons.selection.dialog.SourceSelectionErrorReporter;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.selection.dialog.SourceSelectionPickerButton;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.NarrowBevelBorder;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public final class SourceSelectionPanelBuilder
implements ComponentBuilder {
    public static final String COMPARE_BUTTON = "CompareButton";
    public static final String CANCEL_BUTTON = "CancelButton";
    public static final String INCLUDE_SUBFOLDERS_CHECKBOX = "IncludeSubfoldersCheckBox";
    public static final String FIRST_FILE_COMBOBOX = "FirstSelectionComboBox";
    public static final String FIRST_BROWSE_BUTTON = "FirstBrowseButton";
    public static final String SECOND_FILE_COMBOBOX = "SecondSelectionComboBox";
    public static final String SECOND_BROWSE_BUTTON = "SecondBrowseButton";
    public static final String COMPARISON_TYPE_COMBOBOX = "ComparisonTypeComboBox";
    public static final String ERROR_TEXT_COMPONENT = "ErrorTextComponent";
    public static final String SOURCE_SELECTION_PANEL = "SourceSelectionPanel";
    private static final int ERROR_TEXT_ROWS = 2;
    private static final int ERROR_TEXT_COLS = 60;
    private final SourceSelectionListModel mPreviouslySelectedList;
    private final ComparisonTypeRegister mComparisonTypeRegister;
    private final SelectionPoliciesRegister mSelectionPoliciesRegister;
    private final ComparisonSelection mCurrentSelection;
    private final SourceSelectionErrorReporter mSourceSelectionErrorReporter;
    private Component mErrorComponent;
    private MJButton mCompareButton;
    private MJButton mCancelButton;
    private SourceSelectionPickerButton mFirstBrowseButton;
    private SourceSelectionPickerButton mSecondBrowseButton;
    private SourceSelectionComboBox mFirstSelectionCombo;
    private SourceSelectionComboBox mSecondSelectionCombo;
    private MJComboBox mComparisonTypeComboBox;
    private MJCheckBox mIncludeSubFolders;
    private MJPanel mPanel;

    public SourceSelectionPanelBuilder(ComparisonTypeRegister comparisonTypeRegister, SelectionPoliciesRegister selectionPoliciesRegister, SourceSelectionListModel sourceSelectionListModel, ComparisonSelection comparisonSelection) {
        this.mComparisonTypeRegister = comparisonTypeRegister;
        this.mSelectionPoliciesRegister = selectionPoliciesRegister;
        this.mPreviouslySelectedList = sourceSelectionListModel;
        this.mCurrentSelection = comparisonSelection;
        this.mSourceSelectionErrorReporter = new SourceSelectionErrorReporter(2, 60, ERROR_TEXT_COMPONENT);
    }

    public void createPanel() {
        this.mErrorComponent = this.mSourceSelectionErrorReporter.getComponent();
        this.mCompareButton = this.createButton(COMPARE_BUTTON, "selectiondialog.comparebutton");
        this.mCompareButton.setEnabled(false);
        this.mCancelButton = this.createButton(CANCEL_BUTTON, "selectiondialog.cancelbutton");
        this.mIncludeSubFolders = this.createCheckBox(INCLUDE_SUBFOLDERS_CHECKBOX, "selectiondialog.includesubfolders");
        this.mIncludeSubFolders.setEnabled(false);
        this.mIncludeSubFolders.setSelected(false);
        this.mIncludeSubFolders.addActionListener(this.createIncludeSubfoldersListener());
        this.mFirstSelectionCombo = this.createSelectionComboBox(FIRST_FILE_COMBOBOX);
        this.mSecondSelectionCombo = this.createSelectionComboBox(SECOND_FILE_COMBOBOX);
        this.mFirstBrowseButton = this.createBrowseButton(FIRST_BROWSE_BUTTON, this.mFirstSelectionCombo);
        this.mSecondBrowseButton = this.createBrowseButton(SECOND_BROWSE_BUTTON, this.mSecondSelectionCombo);
        this.mComparisonTypeComboBox = this.createComparisonTypeComboBox(COMPARISON_TYPE_COMBOBOX);
        this.mPanel = new MJPanel();
        this.mPanel.setName(SOURCE_SELECTION_PANEL);
        this.mErrorComponent.setBackground(this.mPanel.getBackground());
        this.layoutPanel();
        ComparisonTypesReady comparisonTypesReady = this.createComparisonTypesReady();
        this.mComparisonTypeComboBox.addActionListener((ActionListener)comparisonTypesReady);
        DetermineComparisonTypes determineComparisonTypes = this.createDetermineComparisonTypes();
        this.mFirstSelectionCombo.addActionListener(determineComparisonTypes);
        this.mSecondSelectionCombo.addActionListener(determineComparisonTypes);
    }

    public void addCompareActionListener(ActionListener actionListener) {
        this.mCompareButton.addActionListener(actionListener);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.mCancelButton.addActionListener(actionListener);
    }

    public JComponent getComponent() {
        return this.mPanel;
    }

    public void dispose() {
        if (this.mFirstSelectionCombo != null) {
            this.mFirstSelectionCombo.dispose();
            this.mFirstSelectionCombo = null;
        }
        if (this.mSecondSelectionCombo != null) {
            this.mSecondSelectionCombo.dispose();
            this.mSecondSelectionCombo = null;
        }
        this.mErrorComponent = null;
    }

    public void setInitialFocus() {
        if (this.mCompareButton.isEnabled()) {
            this.mCompareButton.requestFocusInWindow();
        }
    }

    public void setInitialSelections() {
        if (this.mCurrentSelection == null || this.mCurrentSelection.getSelection(ComparisonSelection.Index.FIRST) == null && this.mCurrentSelection.getSelection(ComparisonSelection.Index.FIRST) == null) {
            if (this.mFirstSelectionCombo.getModel().getSize() > 0) {
                this.mFirstSelectionCombo.setSelectedIndex(0);
            }
            if (this.mSecondSelectionCombo.getModel().getSize() > 1) {
                this.mSecondSelectionCombo.setSelectedIndex(1);
            }
        }
    }

    private MJButton createButton(String string, String string2) {
        MJButton mJButton = new MJButton(ResourceManager.getString(string2));
        mJButton.setName(string);
        return mJButton;
    }

    private MJCheckBox createCheckBox(String string, String string2) {
        MJCheckBox mJCheckBox = new MJCheckBox(ResourceManager.getString(string2));
        mJCheckBox.setName(string);
        return mJCheckBox;
    }

    private SourceSelectionComboBox createSelectionComboBox(String string) {
        SourceSelectionComboBoxModel sourceSelectionComboBoxModel = new SourceSelectionComboBoxModel(this.mSelectionPoliciesRegister, this.mPreviouslySelectedList, this.mSourceSelectionErrorReporter);
        SourceSelectionComboBox sourceSelectionComboBox = new SourceSelectionComboBox(sourceSelectionComboBoxModel);
        sourceSelectionComboBox.setName(string);
        sourceSelectionComboBox.setEditable(true);
        sourceSelectionComboBox.setMaximumRowCount(this.mPreviouslySelectedList.getMaxSize());
        sourceSelectionComboBox.setTipWhenTruncatedEnabled(true);
        for (SelectionPolicies selectionPolicies : this.mSelectionPoliciesRegister.getAllPolicies()) {
            sourceSelectionComboBox.register(selectionPolicies.createDropPolicy());
        }
        return sourceSelectionComboBox;
    }

    private SourceSelectionPickerButton createBrowseButton(String string, SourceSelectionComboBox sourceSelectionComboBox) {
        SourceSelectionPickerButton sourceSelectionPickerButton = new SourceSelectionPickerButton(sourceSelectionComboBox);
        for (SelectionPolicies selectionPolicies : this.mSelectionPoliciesRegister.getAllPolicies()) {
            BrowseAction browseAction = selectionPolicies.createBrowseAction();
            if (browseAction != null) {
                browseAction.setAssociatedCombo(sourceSelectionComboBox);
            }
            sourceSelectionPickerButton.register(selectionPolicies.getSelectionDataType(), selectionPolicies.getDescription(), selectionPolicies.getIcon(), browseAction);
        }
        sourceSelectionPickerButton.setName(string);
        sourceSelectionPickerButton.setBorder((Border)new NarrowBevelBorder(0));
        return sourceSelectionPickerButton;
    }

    private MJComboBox createComparisonTypeComboBox(String string) {
        MJComboBox mJComboBox = new MJComboBox(new DefaultComboBoxModel());
        mJComboBox.setName(string);
        mJComboBox.setEditable(false);
        mJComboBox.setTipWhenTruncatedEnabled(true);
        return mJComboBox;
    }

    private void layoutPanel() {
        FormLayout formLayout = new FormLayout("6dlu, p, 6dlu, 240dlu:grow, 2dlu, p, 6dlu", "4dlu, p, 2dlu, p, 2dlu, p, 4dlu, p, 4dlu");
        formLayout.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.mPanel);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(ResourceManager.getString("selectiondialog.first"), cellConstraints.xy(2, 2));
        panelBuilder.addLabel(ResourceManager.getString("selectiondialog.second"), cellConstraints.xy(2, 4));
        panelBuilder.addLabel(ResourceManager.getString("selectiondialog.comparisontype"), cellConstraints.xy(2, 6));
        panelBuilder.add((Component)((Object)this.mFirstSelectionCombo), cellConstraints.xy(4, 2));
        panelBuilder.add((Component)((Object)this.mSecondSelectionCombo), cellConstraints.xy(4, 4));
        panelBuilder.add((Component)this.mComparisonTypeComboBox, cellConstraints.xy(4, 6));
        panelBuilder.add((Component)((Object)this.mFirstBrowseButton), cellConstraints.xy(6, 2));
        panelBuilder.add((Component)((Object)this.mSecondBrowseButton), cellConstraints.xy(6, 4));
        FormLayout formLayout2 = new FormLayout("10dlu, 140dlu, 10dlu:grow, 60dlu, 10dlu, 60dlu", "p, 6dlu, p");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.add((Component)this.mIncludeSubFolders, cellConstraints.xyw(4, 1, 3, "center,center"));
        panelBuilder2.add(this.mErrorComponent, cellConstraints.xywh(2, 1, 1, 3, "center,center"));
        panelBuilder2.add((Component)this.mCompareButton, cellConstraints.xy(4, 3));
        panelBuilder2.add((Component)this.mCancelButton, cellConstraints.xy(6, 3));
        JPanel jPanel = panelBuilder2.getPanel();
        panelBuilder.add((Component)jPanel, cellConstraints.xyw(2, 8, 5));
    }

    private DetermineComparisonTypes createDetermineComparisonTypes() {
        return new DetermineComparisonTypes(this.mCurrentSelection, this.mComparisonTypeRegister, this.mSelectionPoliciesRegister, this.mFirstSelectionCombo, this.mSecondSelectionCombo, this.mComparisonTypeComboBox, this.mSourceSelectionErrorReporter);
    }

    private ComparisonTypesReady createComparisonTypesReady() {
        return new ComparisonTypesReady(this.mCurrentSelection, this.mCompareButton, this.mIncludeSubFolders);
    }

    private ActionListener createIncludeSubfoldersListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                assert (actionEvent.getSource() instanceof MJCheckBox);
                ComparisonPrefsManager.getInstance().setValue(CPreferenceIncludeSubfolders.getInstance(), SourceSelectionPanelBuilder.this.mIncludeSubFolders.isSelected());
                SourceSelectionPanelBuilder.this.mCurrentSelection.setValue(CParameterIncludeSubfolders.getInstance(), SourceSelectionPanelBuilder.this.mIncludeSubFolders.isSelected());
            }
        };
    }
}

