/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.param.ComparisonParameter;
import com.mathworks.comparisons.param.parameter.CParameterIncludeSubfolders;
import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceIncludeSubfolders;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public final class ComparisonTypesReady
implements ActionListener {
    private final ComparisonSelection mCurrentSelectionState;
    private final MJButton mCompareButton;
    private final MJCheckBox mIncludeSubfolders;
    private final ComparisonParameter mIncludeSubfoldersProperty = CParameterIncludeSubfolders.getInstance();

    public ComparisonTypesReady(ComparisonSelection comparisonSelection, MJButton mJButton, MJCheckBox mJCheckBox) {
        this.mCurrentSelectionState = comparisonSelection;
        this.mCompareButton = mJButton;
        this.mIncludeSubfolders = mJCheckBox;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        assert (actionEvent.getSource() instanceof MJComboBox);
        MJComboBox mJComboBox = (MJComboBox)actionEvent.getSource();
        int n = mJComboBox.getSelectedIndex();
        if (n >= 0) {
            ComparisonType comparisonType = (ComparisonType)mJComboBox.getSelectedItem();
            this.mCurrentSelectionState.setComparisonType(comparisonType);
            if (comparisonType.hasFeature(ComparisonTypeFeature.ISLISTCOMPARISON)) {
                this.mIncludeSubfolders.setEnabled(true);
                Boolean bl = this.getIncludeSubfoldersFromPrefs();
                this.mIncludeSubfolders.setSelected(bl.booleanValue());
                this.mCurrentSelectionState.setValue(this.mIncludeSubfoldersProperty, bl);
            } else {
                this.disableIncludeSubfolders();
            }
            this.mCompareButton.setEnabled(true);
            this.mCompareButton.requestFocusInWindow();
        } else {
            this.mCompareButton.setEnabled(false);
            this.disableIncludeSubfolders();
        }
    }

    private void disableIncludeSubfolders() {
        if (this.mIncludeSubfolders.isEnabled()) {
            this.storeIncludeSubfoldersInPrefs(this.mIncludeSubfolders.isSelected());
        }
        this.mIncludeSubfolders.setEnabled(false);
        this.mIncludeSubfolders.setSelected(false);
        this.mCurrentSelectionState.removeParameter(this.mIncludeSubfoldersProperty);
    }

    private Boolean getIncludeSubfoldersFromPrefs() {
        return (Boolean)ComparisonPrefsManager.getInstance().getValue(CPreferenceIncludeSubfolders.getInstance());
    }

    private void storeIncludeSubfoldersInPrefs(boolean bl) {
        ComparisonPrefsManager.getInstance().setValue(CPreferenceIncludeSubfolders.getInstance(), bl);
    }
}

