/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.variable;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.actionid.ActionIDBack;
import com.mathworks.comparisons.decorator.impl.AbstractComparisonAction;
import com.mathworks.comparisons.decorator.variable.ArrayDifferencesPanel;
import com.mathworks.comparisons.decorator.variable.StringDifferencesPanel;
import com.mathworks.comparisons.decorator.variable.StructDifferencesPanel;
import com.mathworks.comparisons.decorator.variable.VariableDifferences;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.DTMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public class VariableComparisonDecorator
implements ComparisonReportDecorator,
ComparisonEventListener {
    private MJPanel fRootPanel;
    private SubsrefCallbackProvider fSubsrefCallback;
    private Stack<String> mSubsrefStack1;
    private Stack<String> mSubsrefStack2;
    private GoBackAction mGoBackAction;
    private boolean mUpToDate;

    public VariableComparisonDecorator(SubsrefCallbackProvider subsrefCallbackProvider) {
        this.fSubsrefCallback = subsrefCallbackProvider;
        this.mSubsrefStack1 = new Stack();
        this.mSubsrefStack2 = new Stack();
        this.mGoBackAction = new GoBackAction();
        this.mUpToDate = false;
    }

    @Override
    public void processEvent(ComparisonEvent comparisonEvent) {
    }

    @Override
    public Component createCentralComponent() {
        this.fRootPanel = new MJPanel((LayoutManager)new BorderLayout());
        return this.fRootPanel;
    }

    @Override
    public MJToolBar decorate(MJToolBar mJToolBar) {
        mJToolBar.add((Action)((Object)this.mGoBackAction));
        return mJToolBar;
    }

    @Override
    public MJMenuBar decorate(MJMenuBar mJMenuBar) {
        DTMenu dTMenu = new DTMenu(ResourceManager.getString("comparisonreport.comparisonmenu"));
        dTMenu.add((Action)((Object)this.mGoBackAction));
        mJMenuBar.add((JMenu)dTMenu);
        return mJMenuBar;
    }

    @Override
    public void disableControls() {
        this.mGoBackAction.setEnabled(false);
    }

    @Override
    public void enableControls() {
        this.mGoBackAction.setEnabled(!this.mSubsrefStack1.empty());
    }

    @Override
    public void dispose() {
    }

    public void showDifferences(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, String string, String string2, VariableDifferences variableDifferences) {
        Component component;
        if (string != null) {
            this.mSubsrefStack1.push(string);
            this.mSubsrefStack2.push(string2);
        } else {
            this.mSubsrefStack1.clear();
            this.mSubsrefStack2.clear();
        }
        switch (variableDifferences.getType()) {
            case STRUCTS: 
            case OBJECTS: {
                component = this.showStructDiffs(variableDifferences);
                break;
            }
            case STRINGS: {
                component = this.showStringDiffs(variableDifferences);
                break;
            }
            default: {
                component = this.showArrayDiffs(variableDifferences);
            }
        }
        this.fRootPanel.removeAll();
        this.fRootPanel.add(component, (Object)"Center");
        this.fRootPanel.revalidate();
        this.enableControls();
        this.mUpToDate = true;
    }

    public void showError(String string, boolean bl) {
        if (bl) {
            this.mSubsrefStack1.push("#error");
            this.mSubsrefStack2.push("#error");
        } else {
            this.mSubsrefStack1.clear();
            this.mSubsrefStack2.clear();
        }
        this.fRootPanel.removeAll();
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setIcon((Icon)DialogIcon.ERROR_32x32.getIcon());
        mJLabel.setHorizontalAlignment(0);
        mJLabel.setVerticalAlignment(0);
        this.fRootPanel.add((Component)mJLabel, (Object)"Center");
        this.fRootPanel.revalidate();
        this.enableControls();
        this.mUpToDate = true;
    }

    public void doIndexSubsref(int n, int n2) {
        assert (this.mSubsrefStack1.size() == this.mSubsrefStack2.size());
        String string = String.valueOf(n + 1) + "," + String.valueOf(n2 + 1);
        this.doSubsref(string, string);
    }

    public void doFieldSubsref(String string) {
        String string2 = "." + string;
        String string3 = "." + string;
        if (!this.mSubsrefStack1.empty()) {
            string2 = this.mSubsrefStack1.peek() + "|" + string2;
            string3 = this.mSubsrefStack2.peek() + "|" + string3;
        }
        this.fSubsrefCallback.doSubsref(string2, string3);
    }

    public boolean isUpToDate() {
        return this.mUpToDate;
    }

    private void doSubsref(String string, String string2) {
        if (!this.mSubsrefStack1.empty()) {
            string = this.mSubsrefStack1.peek() + "|" + string;
            string2 = this.mSubsrefStack2.peek() + "|" + string2;
        }
        this.mUpToDate = false;
        this.fSubsrefCallback.doSubsref(string, string2);
    }

    private Component showArrayDiffs(VariableDifferences variableDifferences) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayDifferencesPanel arrayDifferencesPanel = new ArrayDifferencesPanel(this, variableDifferences);
        return arrayDifferencesPanel;
    }

    private Component showStructDiffs(VariableDifferences variableDifferences) {
        assert (SwingUtilities.isEventDispatchThread());
        return new StructDifferencesPanel(this, variableDifferences);
    }

    private Component showStringDiffs(VariableDifferences variableDifferences) {
        assert (SwingUtilities.isEventDispatchThread());
        return new StringDifferencesPanel(variableDifferences);
    }

    class GoBackAction
    extends AbstractComparisonAction {
        GoBackAction() {
            super(ActionIDBack.getInstance());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (VariableComparisonDecorator.this.mSubsrefStack1.size() == VariableComparisonDecorator.this.mSubsrefStack2.size());
            VariableComparisonDecorator.this.mSubsrefStack1.pop();
            VariableComparisonDecorator.this.mSubsrefStack2.pop();
            String string = VariableComparisonDecorator.this.mSubsrefStack1.empty() ? null : (String)VariableComparisonDecorator.this.mSubsrefStack1.pop();
            String string2 = VariableComparisonDecorator.this.mSubsrefStack2.empty() ? null : (String)VariableComparisonDecorator.this.mSubsrefStack2.pop();
            VariableComparisonDecorator.this.fSubsrefCallback.doSubsref(string, string2);
            VariableComparisonDecorator.this.enableControls();
        }
    }

    public static interface SubsrefCallbackProvider {
        public void doSubsref(String var1, String var2);
    }
}

