/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.panels;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.toolbox.instrument.device.PropertyChangedListener;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.guiutil.panels.DeviceDriverHelper;
import com.mathworks.toolbox.instrument.device.guiutil.panels.DevicePanel;
import com.mathworks.toolbox.instrument.device.guiutil.panels.FunctionPanelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FunctionPanel
extends DevicePanel
implements PropertyChangedListener,
ListSelectionListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int HELP = 0;
    private static final int EXECUTE = 1;
    private static Vector<FunctionPanelListener> listeners = new Vector();
    private JList functions;
    private JButton showHelp;
    private JButton execute;
    private JLabel objectLabel;
    private JLabel inputArgLabel;
    private JLabel outputArgLabel;
    private JTextField functionDefinition;
    private JComboBox functionObject;
    private JTextField inputArg;
    private JTextField outputArg;
    private JLabel tempLabel = new JLabel("");
    private boolean isEnabled = true;
    private DeviceDriverHelper helper = null;
    private ICDevice deviceObject = null;

    public FunctionPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
    }

    public void update(ICDevice iCDevice, Parser parser, DeviceDriverHelper deviceDriverHelper) {
        this.helper = deviceDriverHelper;
        if (this.helper == null) {
            this.helper = new DeviceDriverHelper(parser);
        }
        this.deviceObject = iCDevice;
        this.functions.setListData(this.helper.getFunctionListData());
        ICDevice.addPropertyChangedListener(this);
    }

    public void cleanup() {
        ICDevice.removePropertyChangedListener(this);
    }

    private void layoutPanel() {
        JPanel jPanel = this.add(this.createFunctionToExecutePanel(), this.createFunctionInfoPanel(), 4);
        this.add((Component)jPanel, "North");
        this.add((Component)this.createFunctionButtonPanel(), "South");
    }

    private JPanel createFunctionToExecutePanel() {
        this.functions = new JList();
        this.functions.setName("Function to execute Listbox");
        JScrollPane jScrollPane = new JScrollPane(this.functions);
        jScrollPane.setPreferredSize(new Dimension(70, 140));
        this.functions.addListSelectionListener(this);
        if (this.functions.getModel().getSize() > 0) {
            this.functions.setSelectedIndex(0);
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createFunctionInfoPanel() {
        this.objectLabel = new JLabel("Object:");
        this.inputArgLabel = new JLabel("Input argument(s):");
        this.outputArgLabel = new JLabel("Output argument(s):");
        this.objectLabel.setVerticalAlignment(1);
        this.inputArgLabel.setVerticalAlignment(1);
        this.outputArgLabel.setVerticalAlignment(1);
        this.functionDefinition = new JTextField(20);
        this.functionObject = new JComboBox();
        this.inputArg = new JTextField();
        this.outputArg = new JTextField();
        this.functionDefinition.setEditable(false);
        this.functionDefinition.setBorder(null);
        this.functionDefinition.setBackground(this.objectLabel.getBackground());
        this.functionDefinition.setForeground(this.objectLabel.getForeground());
        this.functionDefinition.setCaretPosition(0);
        this.functionDefinition.addMouseListener(this);
        this.functionDefinition.setName("Function definition Label");
        this.functionObject.setName("Object to test Combobox");
        this.inputArg.setName("Input arguments(s) Text Field");
        this.outputArg.setName("Output argument(s) Text Field");
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, 2));
        jPanel.add(this.objectLabel);
        jPanel.add(this.inputArgLabel);
        jPanel.add(this.outputArgLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 2));
        jPanel2.add(this.functionObject);
        jPanel2.add(this.inputArg);
        jPanel2.add(this.outputArg);
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 7));
        jPanel3.add((Component)this.functionDefinition, "North");
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    private JPanel createFunctionButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 4, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.showHelp = new JButton("Show Help...");
        this.execute = new JButton("Execute");
        this.showHelp.setName("Show Help Button");
        this.execute.setName("Execute Button");
        this.showHelp.putClientProperty(ACTION, new Integer(0));
        this.execute.putClientProperty(ACTION, new Integer(1));
        this.showHelp.addActionListener(this);
        this.execute.addActionListener(this);
        jPanel2.add(this.showHelp);
        jPanel2.add(this.execute);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.helper.showFunctionHelp(this.functions.getSelectedIndex());
                break;
            }
            case 1: {
                String string = this.helper.getFunction(this.functions.getSelectedIndex());
                String string2 = (String)this.functionObject.getSelectedItem();
                FunctionPanel.functionExecuted(string, string2, this.inputArg.getText(), this.outputArg.getText());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.functionObject == null) {
            return;
        }
        int n = this.functions.getSelectedIndex();
        if (n == -1) {
            return;
        }
        if (this.helper.isFunctionHeader(n)) {
            this.setFunctionComponentsEnabled(false);
            this.functionDefinition.setText("");
            this.functionObject.removeAllItems();
            return;
        }
        this.setFunctionComponentsEnabled(true);
        String string = this.helper.getFunction(n);
        String string2 = this.helper.getSelectedFunctionGroup(n);
        this.updateFunctionInformation(string, string2, n);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.tempLabel.setText(this.functionDefinition.getText());
        if (this.functionDefinition.getWidth() < this.tempLabel.getPreferredSize().width) {
            this.functionDefinition.setToolTipText(this.functionDefinition.getText());
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.functionDefinition.setToolTipText("");
    }

    private void updateFunctionInformation(String string, String string2, int n) {
        this.updateObject(string2);
        String string3 = this.helper.getFunctionDefinition(string2, n);
        this.functionDefinition.setText(string3);
        this.functionDefinition.setCaretPosition(0);
        String string4 = "'" + string + "')";
        this.inputArg.setText("");
        if (this.helper.isDefaultFunctionName(string, string2)) {
            this.enableInputArgument(false);
        } else if (string3.indexOf(string4) != -1) {
            this.enableInputArgument(false);
        } else {
            this.enableInputArgument(true);
        }
        this.outputArg.setText("");
        if (string3.indexOf("=") == -1) {
            this.enableOutputArgument(false);
        } else {
            this.enableOutputArgument(true);
        }
    }

    private void enableOutputArgument(boolean bl) {
        this.outputArg.setEnabled(bl);
        this.outputArgLabel.setEnabled(bl);
    }

    private void enableInputArgument(boolean bl) {
        this.inputArg.setEnabled(bl);
        this.inputArgLabel.setEnabled(bl);
    }

    private void updateObject(String string) {
        this.functionObject.removeAllItems();
        if (string.equals("parent")) {
            this.functionObject.addItem("Device object");
            return;
        }
        int n = this.helper.getGroupSize(string);
        for (int i = 0; i < n; ++i) {
            this.functionObject.addItem(this.helper.getGroupCommandNameAt(string, i + 1));
        }
        this.functionObject.addItem("All objects");
    }

    public void setFunctionComponentsEnabled(boolean bl) {
        if (this.isEnabled == bl) {
            return;
        }
        this.objectLabel.setEnabled(bl);
        this.inputArgLabel.setEnabled(bl);
        this.outputArgLabel.setEnabled(bl);
        this.functionObject.setEnabled(bl);
        this.inputArg.setEnabled(bl);
        this.outputArg.setEnabled(bl);
        this.showHelp.setEnabled(bl);
        if (this.deviceObject.getStatus() == 1 && bl) {
            this.execute.setEnabled(bl);
        } else {
            this.execute.setEnabled(false);
        }
        this.isEnabled = bl;
    }

    @Override
    public void propertyChanged(final Object object, final String string, final Object object2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FunctionPanel.this.propertyChanged(object, string, object2);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (!object.equals(this.deviceObject)) {
            return;
        }
        if (!string.equals("Status")) {
            return;
        }
        if (object2.equals("open")) {
            if (!this.helper.isFunctionHeader(this.functions.getSelectedIndex())) {
                this.execute.setEnabled(true);
            }
        } else {
            this.execute.setEnabled(false);
        }
    }

    public String generateCode() {
        boolean bl = !this.functionObject.getSelectedItem().equals("Device object");
        String string = this.getInvokeCommand(bl);
        if (!bl) {
            return string;
        }
        String string2 = this.helper.getSelectedFunctionGroup(this.functions.getSelectedIndex());
        String string3 = "groupObj = get(deviceObj, '" + string2 + "');";
        String string4 = (String)this.functionObject.getSelectedItem();
        int n = this.functionObject.getSelectedIndex();
        String string5 = "All objects";
        if (!string4.equals(string5)) {
            string3 = string3 + "\n" + "groupObj = groupObj(" + (n + 1) + ");";
        }
        return string3 + "\n" + string;
    }

    private String getInvokeCommand(boolean bl) {
        boolean bl2;
        String string = this.helper.getFunction(this.functions.getSelectedIndex());
        String string2 = this.outputArg.getText();
        boolean bl3 = bl2 = !string2.equals("");
        if (string.equals("devicereset")) {
            return "devicereset(deviceObj);";
        }
        if (string.equals("geterror")) {
            if (bl2) {
                return "[" + string2 + "] = geterror(deviceObj);";
            }
            return "geterror(deviceObj)";
        }
        if (string.equals("selftest")) {
            if (bl2) {
                return "[" + string2 + "] = selftest(deviceObj);";
            }
            return "selftest(deviceObj)";
        }
        String string3 = "";
        if (bl2) {
            string3 = "[" + string2 + "] = ";
        }
        string3 = string3 + "invoke(";
        string3 = !bl ? string3 + "deviceObj, '" + string + "'" : string3 + "groupObj, '" + string + "'";
        String string4 = this.inputArg.getText();
        string3 = string4.equals("") ? string3 + ");" : string3 + ", " + string4 + ");";
        return string3;
    }

    public DeviceDriverHelper getDeviceDriverHelper() {
        return this.helper;
    }

    public void setFunction(int n) {
        this.functions.setSelectedIndex(n);
    }

    public int getFunction() {
        return this.functions.getSelectedIndex();
    }

    public void setObject(int n) {
        try {
            this.functionObject.setSelectedIndex(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getObject() {
        return this.functionObject.getSelectedIndex();
    }

    public void setInputArguments(String string) {
        this.inputArg.setText(string);
    }

    public String getInputArguments() {
        return this.inputArg.getText();
    }

    public void setOutputArguments(String string) {
        this.outputArg.setText(string);
    }

    public String getOutputArguments() {
        return this.outputArg.getText();
    }

    public static void addFunctionPanelListener(FunctionPanelListener functionPanelListener) {
        if (!listeners.contains(functionPanelListener)) {
            listeners.addElement(functionPanelListener);
        }
    }

    public static void removeFunctionPanelListener(FunctionPanelListener functionPanelListener) {
        listeners.removeElement(functionPanelListener);
        functionPanelListener = null;
    }

    public static void functionExecuted(String string, String string2, String string3, String string4) {
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.elementAt(i).functionExecuted(string, string2, string3, string4);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

